/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.FindMax;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.impl.TableOperationsHelper;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.mock.MockAccumulo;
import org.apache.accumulo.core.client.mock.MockNamespace;
import org.apache.accumulo.core.client.mock.MockScanner;
import org.apache.accumulo.core.client.mock.MockTable;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

class MockTableOperationsImpl
extends TableOperationsHelper {
    private static final byte[] ZERO = new byte[]{0};
    private final MockAccumulo acu;
    private final String username;

    MockTableOperationsImpl(MockAccumulo acu, String username) {
        this.acu = acu;
        this.username = username;
    }

    @Override
    public SortedSet<String> list() {
        return new TreeSet<String>(this.acu.tables.keySet());
    }

    @Override
    public boolean exists(String tableName) {
        return this.acu.tables.containsKey(tableName);
    }

    private boolean namespaceExists(String namespace) {
        return this.acu.namespaces.containsKey(namespace);
    }

    @Override
    public void create(String tableName) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        this.create(tableName, true, TimeType.MILLIS);
    }

    @Override
    public void create(String tableName, boolean versioningIter) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        this.create(tableName, versioningIter, TimeType.MILLIS);
    }

    @Override
    public void create(String tableName, boolean versioningIter, TimeType timeType) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        String namespace = Tables.qualify(tableName).getFirst();
        if (!tableName.matches("^(\\w+\\.)?(\\w+)$")) {
            throw new IllegalArgumentException();
        }
        if (this.exists(tableName)) {
            throw new TableExistsException(tableName, tableName, "");
        }
        if (!this.namespaceExists(namespace)) {
            throw new IllegalArgumentException("Namespace (" + namespace + ") does not exist, create it first");
        }
        this.acu.createTable(this.username, tableName, versioningIter, timeType);
    }

    @Override
    public void addSplits(String tableName, SortedSet<Text> partitionKeys) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
        this.acu.addSplits(tableName, partitionKeys);
    }

    @Override
    @Deprecated
    public Collection<Text> getSplits(String tableName) throws TableNotFoundException {
        return this.listSplits(tableName);
    }

    @Override
    @Deprecated
    public Collection<Text> getSplits(String tableName, int maxSplits) throws TableNotFoundException {
        return this.listSplits(tableName);
    }

    @Override
    public Collection<Text> listSplits(String tableName) throws TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
        return this.acu.getSplits(tableName);
    }

    @Override
    public Collection<Text> listSplits(String tableName, int maxSplits) throws TableNotFoundException {
        return this.listSplits(tableName);
    }

    @Override
    public void delete(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
        this.acu.tables.remove(tableName);
    }

    @Override
    public void rename(String oldTableName, String newTableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        if (!this.exists(oldTableName)) {
            throw new TableNotFoundException(oldTableName, oldTableName, "");
        }
        if (this.exists(newTableName)) {
            throw new TableExistsException(newTableName, newTableName, "");
        }
        MockTable t = this.acu.tables.remove(oldTableName);
        String namespace = Tables.qualify(newTableName).getFirst();
        MockNamespace n = this.acu.namespaces.get(namespace);
        if (n == null) {
            n = new MockNamespace();
        }
        t.setNamespaceName(namespace);
        t.setNamespace(n);
        this.acu.namespaces.put(namespace, n);
        this.acu.tables.put(newTableName, t);
    }

    @Override
    @Deprecated
    public void flush(String tableName) throws AccumuloException, AccumuloSecurityException {
    }

    @Override
    public void setProperty(String tableName, String property, String value) throws AccumuloException, AccumuloSecurityException {
        this.acu.tables.get((Object)tableName).settings.put(property, value);
    }

    @Override
    public void removeProperty(String tableName, String property) throws AccumuloException, AccumuloSecurityException {
        this.acu.tables.get((Object)tableName).settings.remove(property);
    }

    @Override
    public Iterable<Map.Entry<String, String>> getProperties(String tableName) throws TableNotFoundException {
        String namespace = Tables.qualify(tableName).getFirst();
        if (!this.exists(tableName)) {
            if (!this.namespaceExists(namespace)) {
                throw new TableNotFoundException(tableName, new NamespaceNotFoundException(null, namespace, null));
            }
            throw new TableNotFoundException(null, tableName, null);
        }
        HashSet<Map.Entry<String, String>> props = new HashSet<Map.Entry<String, String>>(this.acu.namespaces.get((Object)namespace).settings.entrySet());
        Set<Map.Entry<String, String>> tableProps = this.acu.tables.get((Object)tableName).settings.entrySet();
        for (Map.Entry<String, String> e : tableProps) {
            if (props.contains(e)) {
                props.remove(e);
            }
            props.add(e);
        }
        return props;
    }

    @Override
    public void setLocalityGroups(String tableName, Map<String, Set<Text>> groups) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
        this.acu.tables.get(tableName).setLocalityGroups(groups);
    }

    @Override
    public Map<String, Set<Text>> getLocalityGroups(String tableName) throws AccumuloException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
        return this.acu.tables.get(tableName).getLocalityGroups();
    }

    @Override
    public Set<Range> splitRangeByTablets(String tableName, Range range, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
        return Collections.singleton(range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importDirectory(String tableName, String dir, String failureDir, boolean setTime) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        long time = System.currentTimeMillis();
        MockTable table = this.acu.tables.get(tableName);
        if (table == null) {
            throw new TableNotFoundException(null, tableName, "The table was not found");
        }
        Path importPath = new Path(dir);
        Path failurePath = new Path(failureDir);
        FileSystem fs = this.acu.getFileSystem();
        if (fs.isFile(importPath)) {
            throw new IOException("Import path must be a directory.");
        }
        if (fs.isFile(failurePath)) {
            throw new IOException("Failure path must be a directory.");
        }
        Path createPath = failurePath.suffix("/.createFile");
        FSDataOutputStream createStream = null;
        try {
            createStream = fs.create(createPath);
        }
        catch (IOException e) {
            throw new IOException("Error path is not writable.");
        }
        finally {
            if (createStream != null) {
                createStream.close();
            }
        }
        fs.delete(createPath, false);
        FileStatus[] failureChildStats = fs.listStatus(failurePath);
        if (failureChildStats.length > 0) {
            throw new IOException("Error path must be empty.");
        }
        for (FileStatus importStatus : fs.listStatus(importPath)) {
            try {
                FileSKVIterator importIterator = FileOperations.getInstance().openReader(importStatus.getPath().toString(), true, fs, fs.getConf(), AccumuloConfiguration.getDefaultConfiguration());
                while (importIterator.hasTop()) {
                    Key key = (Key)importIterator.getTopKey();
                    Value value = (Value)importIterator.getTopValue();
                    if (setTime) {
                        key.setTimestamp(time);
                    }
                    Mutation mutation = new Mutation(key.getRow());
                    if (!key.isDeleted()) {
                        mutation.put(key.getColumnFamily(), key.getColumnQualifier(), new ColumnVisibility(key.getColumnVisibilityData().toArray()), key.getTimestamp(), value);
                    } else {
                        mutation.putDelete(key.getColumnFamily(), key.getColumnQualifier(), new ColumnVisibility(key.getColumnVisibilityData().toArray()), key.getTimestamp());
                    }
                    table.addMutation(mutation);
                    importIterator.next();
                }
            }
            catch (Exception e) {
                FSDataOutputStream failureWriter = null;
                FilterInputStream failureReader = null;
                try {
                    failureWriter = fs.create(failurePath.suffix("/" + importStatus.getPath().getName()));
                    failureReader = fs.open(importStatus.getPath());
                    int read = 0;
                    byte[] buffer = new byte[1024];
                    while (-1 != (read = ((DataInputStream)failureReader).read(buffer))) {
                        failureWriter.write(buffer, 0, read);
                    }
                }
                finally {
                    if (failureReader != null) {
                        failureReader.close();
                    }
                    if (failureWriter != null) {
                        failureWriter.close();
                    }
                }
            }
            fs.delete(importStatus.getPath(), true);
        }
    }

    @Override
    public void offline(String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.offline(tableName, false);
    }

    @Override
    public void offline(String tableName, boolean wait) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
    }

    @Override
    public void online(String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.online(tableName, false);
    }

    @Override
    public void online(String tableName, boolean wait) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
    }

    @Override
    public void clearLocatorCache(String tableName) throws TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
    }

    @Override
    public Map<String, String> tableIdMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String table : this.acu.tables.keySet()) {
            if ("accumulo.root".equals(table)) {
                result.put(table, "+r");
                continue;
            }
            if ("accumulo.metadata".equals(table)) {
                result.put(table, "!0");
                continue;
            }
            result.put(table, table);
        }
        return result;
    }

    @Override
    public List<DiskUsage> getDiskUsage(Set<String> tables) throws AccumuloException, AccumuloSecurityException {
        ArrayList<DiskUsage> diskUsages = new ArrayList<DiskUsage>();
        diskUsages.add(new DiskUsage(new TreeSet<String>(tables), 0L));
        return diskUsages;
    }

    @Override
    public void merge(String tableName, Text start, Text end) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
        this.acu.merge(tableName, start, end);
    }

    @Override
    public void deleteRows(String tableName, Text start, Text end) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
        MockTable t = this.acu.tables.get(tableName);
        Text startText = start != null ? new Text(start) : new Text();
        Text endText = end != null ? new Text(end) : new Text(t.table.lastKey().getRow().getBytes());
        startText.append(ZERO, 0, 1);
        endText.append(ZERO, 0, 1);
        TreeSet<Key> keep = new TreeSet<Key>(t.table.subMap(new Key(startText), new Key(endText)).keySet());
        t.table.keySet().removeAll(keep);
    }

    @Override
    public void compact(String tableName, Text start, Text end, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
    }

    @Override
    public void compact(String tableName, Text start, Text end, List<IteratorSetting> iterators, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
    }

    @Override
    public void cancelCompaction(String tableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
    }

    @Override
    public void clone(String srcTableName, String newTableName, boolean flush2, Map<String, String> propertiesToSet, Set<String> propertiesToExclude) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        throw new NotImplementedException();
    }

    @Override
    public void flush(String tableName, Text start, Text end, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (!this.exists(tableName)) {
            throw new TableNotFoundException(tableName, tableName, "");
        }
    }

    @Override
    public Text getMaxRow(String tableName, Authorizations auths, Text startRow, boolean startInclusive, Text endRow, boolean endInclusive) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        MockTable table = this.acu.tables.get(tableName);
        if (table == null) {
            throw new TableNotFoundException(tableName, tableName, "no such table");
        }
        return FindMax.findMax(new MockScanner(table, auths), startRow, startInclusive, endRow, endInclusive);
    }

    @Override
    public void importTable(String tableName, String exportDir) throws TableExistsException, AccumuloException, AccumuloSecurityException {
        throw new NotImplementedException();
    }

    @Override
    public void exportTable(String tableName, String exportDir) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        throw new NotImplementedException();
    }

    @Override
    public boolean testClassLoad(String tableName, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            AccumuloVFSClassLoader.loadClass((String)className, Class.forName(asTypeName));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

