/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.impl.OfflineScanner;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractInputFormat<K, V>
extends InputFormat<K, V> {
    protected static final Class<?> CLASS = AccumuloInputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setConnectorInfo(Job job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        InputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, token);
    }

    public static void setConnectorInfo(Job job, String principal, String tokenFile) throws AccumuloSecurityException {
        InputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, tokenFile);
    }

    protected static Boolean isConnectorInfoSet(JobContext context) {
        return InputConfigurator.isConnectorInfoSet(CLASS, AbstractInputFormat.getConfiguration(context));
    }

    protected static String getPrincipal(JobContext context) {
        return InputConfigurator.getPrincipal(CLASS, AbstractInputFormat.getConfiguration(context));
    }

    @Deprecated
    protected static String getTokenClass(JobContext context) {
        return AbstractInputFormat.getAuthenticationToken(context).getClass().getName();
    }

    @Deprecated
    protected static byte[] getToken(JobContext context) {
        return AuthenticationToken.AuthenticationTokenSerializer.serialize(AbstractInputFormat.getAuthenticationToken(context));
    }

    protected static AuthenticationToken getAuthenticationToken(JobContext context) {
        return InputConfigurator.getAuthenticationToken(CLASS, AbstractInputFormat.getConfiguration(context));
    }

    @Deprecated
    public static void setZooKeeperInstance(Job job, String instanceName, String zooKeepers) {
        AbstractInputFormat.setZooKeeperInstance(job, new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(instanceName).withZkHosts(zooKeepers));
    }

    public static void setZooKeeperInstance(Job job, ClientConfiguration clientConfig) {
        InputConfigurator.setZooKeeperInstance(CLASS, job.getConfiguration(), clientConfig);
    }

    public static void setMockInstance(Job job, String instanceName) {
        InputConfigurator.setMockInstance(CLASS, job.getConfiguration(), instanceName);
    }

    protected static Instance getInstance(JobContext context) {
        return InputConfigurator.getInstance(CLASS, AbstractInputFormat.getConfiguration(context));
    }

    public static void setLogLevel(Job job, Level level) {
        InputConfigurator.setLogLevel(CLASS, job.getConfiguration(), level);
    }

    protected static Level getLogLevel(JobContext context) {
        return InputConfigurator.getLogLevel(CLASS, AbstractInputFormat.getConfiguration(context));
    }

    public static void setScanAuthorizations(Job job, Authorizations auths) {
        InputConfigurator.setScanAuthorizations(CLASS, job.getConfiguration(), auths);
    }

    protected static Authorizations getScanAuthorizations(JobContext context) {
        return InputConfigurator.getScanAuthorizations(CLASS, AbstractInputFormat.getConfiguration(context));
    }

    protected static Map<String, InputTableConfig> getInputTableConfigs(JobContext context) {
        return InputConfigurator.getInputTableConfigs(CLASS, AbstractInputFormat.getConfiguration(context));
    }

    protected static InputTableConfig getInputTableConfig(JobContext context, String tableName) {
        return InputConfigurator.getInputTableConfig(CLASS, AbstractInputFormat.getConfiguration(context), tableName);
    }

    protected static TabletLocator getTabletLocator(JobContext context, String table) throws TableNotFoundException {
        return InputConfigurator.getTabletLocator(CLASS, AbstractInputFormat.getConfiguration(context), table);
    }

    protected static void validateOptions(JobContext context) throws IOException {
        InputConfigurator.validateOptions(CLASS, AbstractInputFormat.getConfiguration(context));
    }

    Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobContext context, String tableId, List<Range> ranges) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Instance instance = AbstractInputFormat.getInstance(context);
        Connector conn = instance.getConnector(AbstractInputFormat.getPrincipal(context), AbstractInputFormat.getAuthenticationToken(context));
        return InputConfigurator.binOffline(tableId, ranges, instance, conn);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        Level logLevel = AbstractInputFormat.getLogLevel(context);
        log.setLevel(logLevel);
        AbstractInputFormat.validateOptions(context);
        Random random = new Random();
        LinkedList<InputSplit> splits = new LinkedList<InputSplit>();
        Map<String, InputTableConfig> tableConfigs = AbstractInputFormat.getInputTableConfigs(context);
        for (Map.Entry<String, InputTableConfig> tableConfigEntry : tableConfigs.entrySet()) {
            List<Range> ranges;
            boolean mockInstance;
            String tableId;
            String tableName = tableConfigEntry.getKey();
            InputTableConfig tableConfig = tableConfigEntry.getValue();
            Instance instance = AbstractInputFormat.getInstance(context);
            if (instance instanceof MockInstance) {
                tableId = "";
                mockInstance = true;
            } else {
                try {
                    tableId = Tables.getTableId(instance, tableName);
                }
                catch (TableNotFoundException e) {
                    throw new IOException(e);
                }
                mockInstance = false;
            }
            Authorizations auths = AbstractInputFormat.getScanAuthorizations(context);
            String principal = AbstractInputFormat.getPrincipal(context);
            AuthenticationToken token = AbstractInputFormat.getAuthenticationToken(context);
            boolean autoAdjust = tableConfig.shouldAutoAdjustRanges();
            List<Range> list = ranges = autoAdjust ? Range.mergeOverlapping(tableConfig.getRanges()) : tableConfig.getRanges();
            if (ranges.isEmpty()) {
                ranges = new ArrayList<Range>(1);
                ranges.add(new Range());
            }
            Map<Object, Object> binnedRanges = new HashMap();
            try {
                if (tableConfig.isOfflineScan()) {
                    binnedRanges = this.binOfflineTable(context, tableId, ranges);
                    while (binnedRanges == null) {
                        UtilWaitThread.sleep(100 + random.nextInt(100));
                        binnedRanges = this.binOfflineTable(context, tableId, ranges);
                    }
                } else {
                    TabletLocator tl = AbstractInputFormat.getTabletLocator(context, tableId);
                    tl.invalidateCache();
                    Credentials creds = new Credentials(AbstractInputFormat.getPrincipal(context), AbstractInputFormat.getAuthenticationToken(context));
                    while (!tl.binRanges(creds, ranges, binnedRanges).isEmpty()) {
                        if (!(instance instanceof MockInstance)) {
                            if (!Tables.exists(instance, tableId)) {
                                throw new TableDeletedException(tableId);
                            }
                            if (Tables.getTableState(instance, tableId) == TableState.OFFLINE) {
                                throw new TableOfflineException(instance, tableId);
                            }
                        }
                        binnedRanges.clear();
                        log.warn((Object)"Unable to locate bins for specified ranges. Retrying.");
                        UtilWaitThread.sleep(100 + random.nextInt(100));
                        tl.invalidateCache();
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HashMap<Range, ArrayList<String>> splitsToAdd = null;
            if (!autoAdjust) {
                splitsToAdd = new HashMap<Range, ArrayList<String>>();
            }
            HashMap<String, String> hostNameCache = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : binnedRanges.entrySet()) {
                String ip = ((String)entry.getKey()).split(":", 2)[0];
                String location = (String)hostNameCache.get(ip);
                if (location == null) {
                    InetAddress inetAddress = InetAddress.getByName(ip);
                    location = inetAddress.getCanonicalHostName();
                    hostNameCache.put(ip, location);
                }
                for (Map.Entry extentRanges : ((Map)entry.getValue()).entrySet()) {
                    Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                    for (Range r : (List)extentRanges.getValue()) {
                        if (autoAdjust) {
                            RangeInputSplit split = new RangeInputSplit(tableName, tableId, ke.clip(r), new String[]{location});
                            split.setOffline(tableConfig.isOfflineScan());
                            split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                            split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                            split.setMockInstance(mockInstance);
                            split.setFetchedColumns(tableConfig.getFetchedColumns());
                            split.setPrincipal(principal);
                            split.setToken(token);
                            split.setInstanceName(instance.getInstanceName());
                            split.setZooKeepers(instance.getZooKeepers());
                            split.setAuths(auths);
                            split.setIterators(tableConfig.getIterators());
                            split.setLogLevel(logLevel);
                            splits.add(split);
                            continue;
                        }
                        ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                        if (locations == null) {
                            locations = new ArrayList<String>(1);
                        }
                        locations.add(location);
                        splitsToAdd.put(r, locations);
                    }
                }
            }
            if (autoAdjust) continue;
            for (Map.Entry<Object, Object> entry : splitsToAdd.entrySet()) {
                RangeInputSplit split = new RangeInputSplit(tableName, tableId, (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0]));
                split.setOffline(tableConfig.isOfflineScan());
                split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                split.setMockInstance(mockInstance);
                split.setFetchedColumns(tableConfig.getFetchedColumns());
                split.setPrincipal(principal);
                split.setToken(token);
                split.setInstanceName(instance.getInstanceName());
                split.setZooKeepers(instance.getZooKeepers());
                split.setAuths(auths);
                split.setIterators(tableConfig.getIterators());
                split.setLogLevel(logLevel);
                splits.add(split);
            }
        }
        return splits;
    }

    static Configuration getConfiguration(JobContext context) {
        try {
            Class<?> c = AbstractInputFormat.class.getClassLoader().loadClass("org.apache.hadoop.mapreduce.JobContext");
            Method m = c.getMethod("getConfiguration", new Class[0]);
            Object o = m.invoke((Object)context, new Object[0]);
            return (Configuration)o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static abstract class AbstractRecordReader<K, V>
    extends RecordReader<K, V> {
        protected long numKeysRead;
        protected Iterator<Map.Entry<Key, Value>> scannerIterator;
        protected RangeInputSplit split;
        protected K currentK = null;
        protected V currentV = null;
        protected Key currentKey = null;

        protected AbstractRecordReader() {
        }

        protected abstract void setupIterators(TaskAttemptContext var1, Scanner var2, String var3, RangeInputSplit var4);

        public void initialize(InputSplit inSplit, TaskAttemptContext attempt) throws IOException {
            Scanner scanner;
            Collection<Pair<Text, Text>> columns;
            List<IteratorSetting> iterators;
            Boolean usesLocalIterators;
            Boolean isIsolated;
            Authorizations authorizations;
            AuthenticationToken token;
            String principal;
            this.split = (RangeInputSplit)inSplit;
            log.debug((Object)("Initializing input split: " + this.split.getRange()));
            Instance instance = this.split.getInstance();
            if (null == instance) {
                instance = AbstractInputFormat.getInstance((JobContext)attempt);
            }
            if (null == (principal = this.split.getPrincipal())) {
                principal = AbstractInputFormat.getPrincipal((JobContext)attempt);
            }
            if (null == (token = this.split.getToken())) {
                token = AbstractInputFormat.getAuthenticationToken((JobContext)attempt);
            }
            if (null == (authorizations = this.split.getAuths())) {
                authorizations = AbstractInputFormat.getScanAuthorizations((JobContext)attempt);
            }
            String table = this.split.getTableName();
            InputTableConfig tableConfig = AbstractInputFormat.getInputTableConfig((JobContext)attempt, this.split.getTableName());
            Boolean isOffline = this.split.isOffline();
            if (null == isOffline) {
                isOffline = tableConfig.isOfflineScan();
            }
            if (null == (isIsolated = this.split.isIsolatedScan())) {
                isIsolated = tableConfig.shouldUseIsolatedScanners();
            }
            if (null == (usesLocalIterators = this.split.usesLocalIterators())) {
                usesLocalIterators = tableConfig.shouldUseLocalIterators();
            }
            if (null == (iterators = this.split.getIterators())) {
                iterators = tableConfig.getIterators();
            }
            if (null == (columns = this.split.getFetchedColumns())) {
                columns = tableConfig.getFetchedColumns();
            }
            try {
                log.debug((Object)("Creating connector with user: " + principal));
                log.debug((Object)("Creating scanner for table: " + table));
                log.debug((Object)("Authorizations are: " + authorizations));
                scanner = isOffline != false ? new OfflineScanner(instance, new Credentials(principal, token), this.split.getTableId(), authorizations) : (instance instanceof MockInstance ? instance.getConnector(principal, token).createScanner(this.split.getTableName(), authorizations) : new ScannerImpl(instance, new Credentials(principal, token), this.split.getTableId(), authorizations));
                if (isIsolated.booleanValue()) {
                    log.info((Object)"Creating isolated scanner");
                    scanner = new IsolatedScanner(scanner);
                }
                if (usesLocalIterators.booleanValue()) {
                    log.info((Object)"Using local iterators");
                    scanner = new ClientSideIteratorScanner(scanner);
                }
                this.setupIterators(attempt, scanner, this.split.getTableName(), this.split);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            for (Pair<Text, Text> c : columns) {
                if (c.getSecond() != null) {
                    log.debug((Object)("Fetching column " + c.getFirst() + ":" + c.getSecond()));
                    scanner.fetchColumn(c.getFirst(), c.getSecond());
                    continue;
                }
                log.debug((Object)("Fetching column family " + c.getFirst()));
                scanner.fetchColumnFamily(c.getFirst());
            }
            scanner.setRange(this.split.getRange());
            this.numKeysRead = 0L;
            this.scannerIterator = scanner.iterator();
        }

        public void close() {
        }

        public float getProgress() throws IOException {
            if (this.numKeysRead > 0L && this.currentKey == null) {
                return 1.0f;
            }
            return this.split.getProgress(this.currentKey);
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.currentK;
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.currentV;
        }
    }
}

