/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ConnectorImpl;
import org.apache.accumulo.core.client.impl.ServerConfigurationUtil;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ZooKeeperInstance
implements Instance {
    private static final Logger log = Logger.getLogger(ZooKeeperInstance.class);
    private String instanceId = null;
    private String instanceName = null;
    private final ZooCache zooCache;
    private final String zooKeepers;
    private final int zooKeepersSessionTimeOut;
    private AccumuloConfiguration accumuloConf;
    private ClientConfiguration clientConf;

    public ZooKeeperInstance(String instanceName, String zooKeepers) {
        this((Configuration)ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zooKeepers));
    }

    @Deprecated
    public ZooKeeperInstance(String instanceName, String zooKeepers, int sessionTimeout) {
        this((Configuration)ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zooKeepers).withZkTimeout(sessionTimeout));
    }

    @Deprecated
    public ZooKeeperInstance(UUID instanceId, String zooKeepers) {
        this((Configuration)ClientConfiguration.loadDefault().withInstance(instanceId).withZkHosts(zooKeepers));
    }

    @Deprecated
    public ZooKeeperInstance(UUID instanceId, String zooKeepers, int sessionTimeout) {
        this((Configuration)ClientConfiguration.loadDefault().withInstance(instanceId).withZkHosts(zooKeepers).withZkTimeout(sessionTimeout));
    }

    public ZooKeeperInstance(Configuration config) {
        ArgumentChecker.notNull(config);
        this.clientConf = config instanceof ClientConfiguration ? (ClientConfiguration)config : new ClientConfiguration(config);
        this.instanceId = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ID);
        this.instanceName = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_NAME);
        if (this.instanceId == null == (this.instanceName == null)) {
            throw new IllegalArgumentException("Expected exactly one of instanceName and instanceId to be set");
        }
        this.zooKeepers = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST);
        this.zooKeepersSessionTimeOut = (int)AccumuloConfiguration.getTimeInMillis(this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_TIMEOUT));
        this.zooCache = ZooCache.getInstance((String)this.zooKeepers, (int)this.zooKeepersSessionTimeOut);
    }

    @Override
    public String getInstanceID() {
        if (this.instanceId == null) {
            String instanceNamePath = "/accumulo/instances/" + this.instanceName;
            byte[] iidb = this.zooCache.get(instanceNamePath);
            if (iidb == null) {
                throw new RuntimeException("Instance name " + this.instanceName + " does not exist in zookeeper.  Run \"accumulo org.apache.accumulo.server.util.ListInstances\" to see a list.");
            }
            this.instanceId = new String(iidb, Constants.UTF8);
        }
        if (this.zooCache.get("/accumulo/" + this.instanceId) == null) {
            if (this.instanceName == null) {
                throw new RuntimeException("Instance id " + this.instanceId + " does not exist in zookeeper");
            }
            throw new RuntimeException("Instance id " + this.instanceId + " pointed to by the name " + this.instanceName + " does not exist in zookeeper");
        }
        return this.instanceId;
    }

    @Override
    public List<String> getMasterLocations() {
        String masterLocPath = ZooUtil.getRoot(this) + "/masters/lock";
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Looking up master location in zoocache.");
        byte[] loc = ZooUtil.getLockData((ZooCache)this.zooCache, (String)masterLocPath);
        opTimer.stop("Found master at " + (loc == null ? null : new String(loc, Constants.UTF8)) + " in %DURATION%");
        if (loc == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new String(loc, Constants.UTF8));
    }

    @Override
    public String getRootTabletLocation() {
        String zRootLocPath = ZooUtil.getRoot(this) + "/root_tablet/location";
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Looking up root tablet location in zookeeper.");
        byte[] loc = this.zooCache.get(zRootLocPath);
        opTimer.stop("Found root tablet at " + (loc == null ? null : new String(loc, Constants.UTF8)) + " in %DURATION%");
        if (loc == null) {
            return null;
        }
        return new String(loc, Constants.UTF8).split("\\|")[0];
    }

    @Override
    public String getInstanceName() {
        if (this.instanceName == null) {
            this.instanceName = ZooKeeperInstance.lookupInstanceName(this.zooCache, UUID.fromString(this.getInstanceID()));
        }
        return this.instanceName;
    }

    @Override
    public String getZooKeepers() {
        return this.zooKeepers;
    }

    @Override
    public int getZooKeepersSessionTimeOut() {
        return this.zooKeepersSessionTimeOut;
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, CharSequence pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, TextUtil.getBytes(new Text(((Object)pass).toString())));
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, ByteBuffer pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, ByteBufferUtil.toBytes(pass));
    }

    @Override
    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        return new ConnectorImpl(this, new Credentials(principal, token));
    }

    @Override
    @Deprecated
    public Connector getConnector(String principal, byte[] pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(principal, new PasswordToken(pass));
    }

    @Override
    @Deprecated
    public AccumuloConfiguration getConfiguration() {
        return ServerConfigurationUtil.convertClientConfig(this.accumuloConf == null ? DefaultConfiguration.getInstance() : this.accumuloConf, (Configuration)this.clientConf);
    }

    @Override
    @Deprecated
    public void setConfiguration(AccumuloConfiguration conf) {
        this.accumuloConf = conf;
    }

    public static String lookupInstanceName(ZooCache zooCache, UUID instanceId) {
        ArgumentChecker.notNull(zooCache, instanceId);
        for (String name : zooCache.getChildren("/accumulo/instances")) {
            String instanceNamePath = "/accumulo/instances/" + name;
            byte[] bytes = zooCache.get(instanceNamePath);
            UUID iid = UUID.fromString(new String(bytes, Constants.UTF8));
            if (!iid.equals(instanceId)) continue;
            return name;
        }
        return null;
    }
}

