/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ClientOpts
extends Help {
    @Parameter(names={"-u", "--user"}, description="Connection user")
    public String principal = System.getProperty("user.name");
    @Parameter(names={"-p"}, converter=PasswordConverter.class, description="Connection password")
    public Password password = null;
    @Parameter(names={"--password"}, converter=PasswordConverter.class, description="Enter the connection password", password=true)
    public Password securePassword = null;
    @Parameter(names={"-tc", "--tokenClass"}, description="Token class")
    public String tokenClassName = PasswordToken.class.getName();
    @DynamicParameter(names={"-l"}, description="login properties in the format key=value. Reuse -l for each property (prompt for properties if this option is missing")
    public Map<String, String> loginProps = new LinkedHashMap<String, String>();
    @Parameter(names={"-z", "--keepers"}, description="Comma separated list of zookeeper hosts (host:port,host:port)")
    public String zookeepers = "localhost:2181";
    @Parameter(names={"-i", "--instance"}, description="The name of the accumulo instance")
    public String instance = null;
    @Parameter(names={"-auths", "--auths"}, converter=AuthConverter.class, description="the authorizations to use when reading or writing")
    public Authorizations auths = Authorizations.EMPTY;
    @Parameter(names={"--debug"}, description="turn on TRACE-level log messages")
    public boolean debug = false;
    @Parameter(names={"-fake", "--mock"}, description="Use a mock Instance")
    public boolean mock = false;
    @Parameter(names={"--site-file"}, description="Read the given accumulo site file to find the accumulo instance")
    public String siteFile = null;
    @Parameter(names={"--ssl"}, description="Connect to accumulo over SSL")
    public boolean sslEnabled = false;
    @Parameter(names={"--config-file"}, description="Read the given client config file.  If omitted, the path searched can be specified with $ACCUMULO_CLIENT_CONF_PATH, which defaults to ~/.accumulo/config:$ACCUMULO_CONF_DIR/client.conf:/etc/accumulo/client.conf")
    public String clientConfigFile = null;
    @Parameter(names={"--trace"}, description="turn on distributed tracing")
    public boolean trace = false;
    protected Instance cachedInstance = null;
    protected ClientConfiguration cachedClientConfig = null;

    public AuthenticationToken getToken() {
        if (!this.loginProps.isEmpty()) {
            AuthenticationToken.Properties props = new AuthenticationToken.Properties();
            for (Map.Entry<String, String> loginOption : this.loginProps.entrySet()) {
                props.put(loginOption.getKey(), loginOption.getValue());
            }
            try {
                AuthenticationToken token = Class.forName(this.tokenClassName).asSubclass(AuthenticationToken.class).newInstance();
                token.init(props);
                return token;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.securePassword != null) {
            return new PasswordToken(this.securePassword.value);
        }
        if (this.password != null) {
            return new PasswordToken(this.password.value);
        }
        return null;
    }

    public void startDebugLogging() {
        if (this.debug) {
            Logger.getLogger((String)"org.apache.accumulo.core").setLevel(Level.TRACE);
        }
    }

    public void startTracing(String applicationName) {
        if (this.trace) {
            Trace.on((String)applicationName);
        }
    }

    public void stopTracing() {
        Trace.off();
    }

    @Override
    public void parseArgs(String programName, String[] args, Object ... others) {
        super.parseArgs(programName, args, others);
        this.startDebugLogging();
        this.startTracing(programName);
    }

    public synchronized Instance getInstance() {
        if (this.cachedInstance != null) {
            return this.cachedInstance;
        }
        if (this.mock) {
            this.cachedInstance = new MockInstance(this.instance);
            return this.cachedInstance;
        }
        this.cachedInstance = new ZooKeeperInstance((org.apache.commons.configuration.Configuration)this.getClientConfiguration());
        return this.cachedInstance;
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        if (this.principal == null || this.getToken() == null) {
            throw new AccumuloSecurityException("You must provide a user (-u) and password (-p)", SecurityErrorCode.BAD_CREDENTIALS);
        }
        return this.getInstance().getConnector(this.principal, this.getToken());
    }

    public void setAccumuloConfigs(Job job) throws AccumuloSecurityException {
        AccumuloInputFormat.setZooKeeperInstance(job, this.getClientConfiguration());
        AccumuloOutputFormat.setZooKeeperInstance(job, this.getClientConfiguration());
    }

    protected ClientConfiguration getClientConfiguration() throws IllegalArgumentException {
        ClientConfiguration clientConfig;
        if (this.cachedClientConfig != null) {
            return this.cachedClientConfig;
        }
        try {
            clientConfig = this.clientConfigFile == null ? ClientConfiguration.loadDefault() : new ClientConfiguration(new org.apache.commons.configuration.Configuration[]{new PropertiesConfiguration(this.clientConfigFile)});
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (this.sslEnabled) {
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_ENABLED, "true");
        }
        if (this.siteFile != null) {
            AccumuloConfiguration config = new AccumuloConfiguration(){
                Configuration xml = new Configuration();
                {
                    this.xml.addResource(new Path(ClientOpts.this.siteFile));
                }

                @Override
                public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
                    for (Map.Entry prop : DefaultConfiguration.getInstance()) {
                        if (!filter.accept(prop.getKey())) continue;
                        props.put((String)prop.getKey(), (String)prop.getValue());
                    }
                    for (Map.Entry prop : this.xml) {
                        if (!filter.accept((String)prop.getKey())) continue;
                        props.put((String)prop.getKey(), (String)prop.getValue());
                    }
                }

                @Override
                public String get(Property property) {
                    String value = this.xml.get(property.getKey());
                    if (value != null) {
                        return value;
                    }
                    return DefaultConfiguration.getInstance().get(property);
                }
            };
            this.zookeepers = config.get(Property.INSTANCE_ZK_HOST);
            String volDir = VolumeConfiguration.getVolumeUris(config)[0];
            Path instanceDir = new Path(volDir, "instance_id");
            String instanceIDFromFile = ZooUtil.getInstanceIDFromHdfs(instanceDir, config);
            if (config.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
                clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_ENABLED, "true");
            }
            this.cachedClientConfig = clientConfig.withInstance(UUID.fromString(instanceIDFromFile)).withZkHosts(this.zookeepers);
            return this.cachedClientConfig;
        }
        this.cachedClientConfig = clientConfig.withInstance(this.instance).withZkHosts(this.zookeepers);
        return this.cachedClientConfig;
    }

    public static class VisibilityConverter
    implements IStringConverter<ColumnVisibility> {
        public ColumnVisibility convert(String value) {
            return new ColumnVisibility(value);
        }
    }

    public static class PasswordConverter
    implements IStringConverter<Password> {
        public Password convert(String value) {
            return new Password(value);
        }
    }

    public static class Password {
        public byte[] value;

        public Password(String dfault) {
            this.value = dfault.getBytes(Constants.UTF8);
        }

        public String toString() {
            return new String(this.value, Constants.UTF8);
        }
    }

    public static class AuthConverter
    implements IStringConverter<Authorizations> {
        public Authorizations convert(String value) {
            return new Authorizations(value.split(","));
        }
    }

    public static class MemoryConverter
    implements IStringConverter<Long> {
        public Long convert(String value) {
            return AccumuloConfiguration.getMemoryInBytes(value);
        }
    }

    public static class TimeConverter
    implements IStringConverter<Long> {
        public Long convert(String value) {
            return AccumuloConfiguration.getTimeInMillis(value);
        }
    }
}

