/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.servicemonitor;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.slider.client.SliderYarnClientImpl;
import org.apache.slider.core.exceptions.UnknownApplicationInstanceException;
import org.apache.slider.server.servicemonitor.Probe;
import org.apache.slider.server.servicemonitor.ProbeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnApplicationProbe
extends Probe {
    protected static final Logger log = LoggerFactory.getLogger(YarnApplicationProbe.class);
    private SliderYarnClientImpl yarnClient;
    private final String clustername;
    private final String username;

    public YarnApplicationProbe(String clustername, SliderYarnClientImpl yarnClient, String name, Configuration conf, String username) throws IOException {
        super("Port probe " + name + " " + clustername, conf);
        this.clustername = clustername;
        this.yarnClient = yarnClient;
        this.username = username;
    }

    @Override
    public void init() throws IOException {
        log.info("Checking " + this.clustername);
    }

    @Override
    public ProbeStatus ping(boolean livePing) {
        ProbeStatus status = new ProbeStatus();
        try {
            List<ApplicationReport> instances = this.yarnClient.listDeployedInstances(this.username);
            ApplicationReport instance = this.yarnClient.findClusterInInstanceList(instances, this.clustername);
            if (instance == null) {
                throw UnknownApplicationInstanceException.unknownInstance(this.clustername);
            }
            status.succeed(this);
        }
        catch (Exception e) {
            status.fail(this, e);
        }
        return status;
    }
}

