/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.servicemonitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.slider.server.servicemonitor.MonitorUtils;
import org.apache.slider.server.servicemonitor.Probe;
import org.apache.slider.server.servicemonitor.ProbeFailedException;
import org.apache.slider.server.servicemonitor.ProbeInterruptedException;
import org.apache.slider.server.servicemonitor.ProbePhase;
import org.apache.slider.server.servicemonitor.ProbeReportHandler;
import org.apache.slider.server.servicemonitor.ProbeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbeWorker
implements Runnable {
    protected static final Logger log = LoggerFactory.getLogger(ProbeWorker.class);
    public static final String FAILED_TO_BOOT = "Monitored service failed to bootstrap after ";
    public static final String FAILURE_OF_A_LIVE_PROBE_DURING_BOOTSTRAPPING = "Failure of a live probe during bootstrapping";
    private final List<Probe> monitorProbes;
    private final List<Probe> dependencyProbes;
    public final int interval;
    protected volatile ProbeStatus lastStatus;
    protected volatile ProbeStatus lastFailingBootstrapProbe;
    protected volatile Probe currentProbe;
    private volatile boolean mustExit;
    private final int bootstrapTimeout;
    private long bootstrapEndtime;
    private ProbeReportHandler reportHandler;
    private volatile ProbePhase probePhase = ProbePhase.INIT;

    public ProbeWorker(List<Probe> monitorProbes, List<Probe> dependencyProbes, int interval, int bootstrapTimeout) {
        this.monitorProbes = monitorProbes;
        this.dependencyProbes = dependencyProbes != null ? dependencyProbes : new ArrayList(0);
        this.interval = interval;
        this.lastStatus = new ProbeStatus(this.now(), "Initial status");
        this.lastStatus.setProbePhase(ProbePhase.INIT);
        this.bootstrapTimeout = bootstrapTimeout;
    }

    public void init() throws IOException {
        for (Probe probe : this.monitorProbes) {
            probe.init();
        }
        for (Probe probe : this.dependencyProbes) {
            probe.init();
        }
    }

    public void setReportHandler(ProbeReportHandler reportHandler) {
        this.reportHandler = reportHandler;
    }

    public void setMustExit() {
        this.mustExit = true;
    }

    public ProbeStatus getLastStatus() {
        return this.lastStatus;
    }

    public synchronized Probe getCurrentProbe() {
        return this.currentProbe;
    }

    public ProbePhase getProbePhase() {
        return this.probePhase;
    }

    private synchronized void enterProbePhase(ProbePhase status) {
        this.probePhase = status;
        if (this.reportHandler != null) {
            this.reportHandler.probeProcessStateChange(status);
        }
    }

    private void reportProbeStatus(ProbeStatus status) {
        ProbePhase phase = this.getProbePhase();
        status.setProbePhase(phase);
        this.lastStatus = status;
        this.reportHandler.probeResult(phase, status);
    }

    private ProbeStatus ping(Probe probe, boolean live) throws ProbeInterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Executing " + probe);
        }
        this.checkForExitRequest();
        this.currentProbe = probe;
        try {
            ProbeStatus probeStatus = probe.ping(live);
            return probeStatus;
        }
        finally {
            this.currentProbe = null;
        }
    }

    private void checkForExitRequest() throws ProbeInterruptedException {
        if (this.mustExit) {
            throw new ProbeInterruptedException();
        }
    }

    private ProbeStatus checkDependencyProbes() throws ProbeInterruptedException {
        ProbeStatus status = null;
        for (Probe dependency : this.dependencyProbes) {
            status = this.ping(dependency, true);
            if (!status.isSuccess()) break;
            this.reportProbeStatus(status);
        }
        return status;
    }

    public boolean checkAndReportDependencyProbes() throws ProbeInterruptedException {
        ProbeStatus status = this.checkDependencyProbes();
        if (status != null && !status.isSuccess()) {
            status.markAsSuccessful();
            this.reportProbeStatus(status);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginBootstrapProbes() {
        ProbeWorker probeWorker = this;
        synchronized (probeWorker) {
            this.bootstrapEndtime = this.now() + (long)this.bootstrapTimeout;
        }
        for (Probe probe : this.monitorProbes) {
            probe.beginBootstrap();
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private boolean checkBootstrapProbes() throws ProbeInterruptedException, ProbeFailedException {
        this.verifyBootstrapHasNotTimedOut();
        boolean probeFailed = false;
        for (Probe probe : this.monitorProbes) {
            ProbeStatus status = this.ping(probe, false);
            if (!status.isSuccess()) {
                probeFailed = true;
                this.lastFailingBootstrapProbe = status;
                ++probe.failureCount;
                if (log.isDebugEnabled()) {
                    log.debug("Booting probe failed: " + status);
                }
                if (!probe.isBooted()) {
                    status.markAsSuccessful();
                    this.reportProbeStatus(status);
                    continue;
                }
                this.reportProbeStatus(status);
                throw this.raiseProbeFailure(status, FAILURE_OF_A_LIVE_PROBE_DURING_BOOTSTRAPPING);
            }
            if (!probe.isBooted()) {
                if (log.isDebugEnabled()) {
                    log.debug("Booting probe is now live: " + probe);
                }
                probe.endBootstrap();
                this.reportHandler.probeBooted(status);
            }
            this.reportProbeStatus(status);
            ++probe.successCount;
        }
        return !probeFailed;
    }

    public int getBootstrapTimeout() {
        return this.bootstrapTimeout;
    }

    public void verifyBootstrapHasNotTimedOut() throws ProbeFailedException {
        if (this.isBootstrapTimeExceeded()) {
            ProbeStatus status;
            String text = FAILED_TO_BOOT + MonitorUtils.millisToHumanTime(this.bootstrapTimeout);
            if (this.lastFailingBootstrapProbe != null) {
                status = this.lastFailingBootstrapProbe;
                status.setSuccess(false);
            } else {
                status = new ProbeStatus();
                status.finish(null, false, text, null);
            }
            throw this.raiseProbeFailure(status, text);
        }
    }

    public synchronized boolean isBootstrapTimeExceeded() {
        return this.now() > this.bootstrapEndtime;
    }

    public boolean checkAndReportBootstrapProbes() throws ProbeInterruptedException, ProbeFailedException {
        if (this.bootstrapTimeout <= 0) {
            return true;
        }
        return this.checkBootstrapProbes();
    }

    protected void checkAndReportLiveProbes() throws ProbeFailedException, ProbeInterruptedException {
        ProbeStatus status = null;
        if (log.isDebugEnabled()) {
            log.debug("Checking live probes");
        }
        for (Probe probe : this.monitorProbes) {
            status = this.ping(probe, true);
            this.reportProbeStatus(status);
            if (!status.isSuccess()) {
                throw this.raiseProbeFailure(status, "Failure of probe in \"live\" monitor");
            }
            ++probe.successCount;
        }
        this.reportHandler.liveProbeCycleCompleted();
    }

    protected void executeProbePhases() throws ProbeFailedException, ProbeInterruptedException {
        switch (this.probePhase) {
            case INIT: {
                this.enterProbePhase(ProbePhase.DEPENDENCY_CHECKING);
            }
            case DEPENDENCY_CHECKING: {
                if (!this.checkAndReportDependencyProbes()) break;
                this.enterProbePhase(ProbePhase.BOOTSTRAPPING);
                this.beginBootstrapProbes();
                break;
            }
            case BOOTSTRAPPING: {
                if (!this.checkAndReportBootstrapProbes()) break;
                this.enterProbePhase(ProbePhase.LIVE);
                break;
            }
            case LIVE: {
                this.checkAndReportLiveProbes();
                break;
            }
        }
    }

    private ProbeFailedException raiseProbeFailure(ProbeStatus status, String text) {
        status.setProbePhase(this.probePhase);
        log.info("Probe failed: " + status);
        return new ProbeFailedException(text, status);
    }

    @Override
    public void run() {
        int size = this.monitorProbes.size();
        log.info("Probe Worker Starting; " + size + " probe" + MonitorUtils.toPlural(size) + ":");
        this.enterProbePhase(ProbePhase.DEPENDENCY_CHECKING);
        for (Probe probe : this.monitorProbes) {
            log.info(probe.getName());
        }
        while (!this.mustExit) {
            try {
                Thread.sleep(this.interval);
                this.executeProbePhases();
            }
            catch (ProbeFailedException e) {
                this.probeFailed(e);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            catch (ProbeInterruptedException probeInterruptedException) {
                break;
            }
        }
        log.info("Probe Worker Exiting");
        this.enterProbePhase(ProbePhase.TERMINATING);
    }

    protected void probeFailed(ProbeFailedException e) {
        this.reportHandler.probeFailure(e);
    }
}

