/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.slider.api.ClusterNode;
import org.apache.slider.api.proto.Messages;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.server.appmaster.state.ContainerAllocationOutcome;
import org.apache.slider.server.appmaster.state.ContainerAssignment;

public final class RoleInstance
implements Cloneable {
    public Container container;
    public final String id;
    public long createTime;
    public long startTime;
    public long completionTime;
    public boolean released;
    public String role;
    public String group;
    public String appVersion;
    public int roleId;
    public int state;
    public int exitCode;
    public String command;
    public String diagnostics;
    public String[] output;
    public String logLink;
    public String[] environment;
    public String ip;
    public String hostname;
    public String host;
    public String hostURL;
    public ContainerAllocationOutcome placement;
    private List<Endpoint> endpoints = new ArrayList<Endpoint>(2);

    public RoleInstance(ContainerAssignment assignment) {
        this(assignment.container);
        this.placement = assignment.placement;
    }

    public RoleInstance(Container container) {
        Preconditions.checkNotNull((Object)container, (Object)"Null container");
        Preconditions.checkState((container.getId() != null ? 1 : 0) != 0, (Object)"Null container ID");
        this.container = container;
        this.id = container.getId().toString();
        if (container.getNodeId() != null) {
            this.host = container.getNodeId().getHost();
        }
        if (container.getNodeHttpAddress() != null) {
            this.hostURL = "http://" + container.getNodeHttpAddress();
        }
    }

    public ContainerId getId() {
        return this.container.getId();
    }

    public NodeId getHost() {
        return this.container.getNodeId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RoleInstance{");
        sb.append("role='").append(this.role).append('\'');
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", container=").append(SliderUtils.containerToString(this.container));
        sb.append(", createTime=").append(this.createTime);
        sb.append(", startTime=").append(this.startTime);
        sb.append(", completionTime=").append(this.completionTime);
        sb.append(", released=").append(this.released);
        sb.append(", roleId=").append(this.roleId);
        sb.append(", host=").append(this.host);
        sb.append(", hostURL=").append(this.hostURL);
        sb.append(", state=").append(this.state);
        sb.append(", placement=").append((Object)this.placement);
        sb.append(", exitCode=").append(this.exitCode);
        sb.append(", command='").append(this.command).append('\'');
        sb.append(", diagnostics='").append(this.diagnostics).append('\'');
        sb.append(", output=").append(Arrays.toString(this.output));
        sb.append(", logLink=").append(this.logLink);
        sb.append(", environment=").append(Arrays.toString(this.environment));
        sb.append('}');
        return sb.toString();
    }

    public ContainerId getContainerId() {
        return this.container != null ? this.container.getId() : null;
    }

    public Messages.RoleInstanceState toProtobuf() {
        Messages.RoleInstanceState.Builder builder = Messages.RoleInstanceState.newBuilder();
        if (this.container != null) {
            builder.setName(this.container.getId().toString());
        } else {
            builder.setName("unallocated instance");
        }
        if (this.command != null) {
            builder.setCommand(this.command);
        }
        if (this.environment != null) {
            builder.addAllEnvironment(Arrays.asList(this.environment));
        }
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        builder.setExitCode(this.exitCode);
        if (this.output != null) {
            builder.addAllOutput(Arrays.asList(this.output));
        }
        if (this.logLink != null) {
            builder.setLogLink(this.logLink);
        }
        if (this.role != null) {
            builder.setRole(this.role);
        }
        builder.setRoleId(this.roleId);
        builder.setState(this.state);
        builder.setReleased(this.released);
        builder.setCreateTime(this.createTime);
        builder.setStartTime(this.startTime);
        builder.setCompletionTime(this.completionTime);
        builder.setHost(this.host);
        builder.setHostURL(this.hostURL);
        if (this.appVersion != null) {
            builder.setAppVersion(this.appVersion);
        }
        return builder.build();
    }

    public ClusterNode toClusterNode() {
        ClusterNode node;
        if (this.container != null) {
            node = new ClusterNode(this.container.getId());
        } else {
            node = new ClusterNode();
            node.name = "unallocated instance";
        }
        node.command = this.command;
        node.createTime = this.createTime;
        node.diagnostics = this.diagnostics;
        if (this.environment != null) {
            node.environment = Arrays.copyOf(this.environment, this.environment.length);
        }
        node.exitCode = this.exitCode;
        node.ip = this.ip;
        node.hostname = this.hostname;
        node.host = this.host;
        node.hostUrl = this.hostURL;
        if (this.output != null) {
            node.output = Arrays.copyOf(this.output, this.output.length);
        }
        node.logLink = this.logLink;
        node.released = this.released;
        node.role = this.role;
        node.roleId = this.roleId;
        node.startTime = this.startTime;
        node.completionTime = this.completionTime;
        node.state = this.state;
        return node;
    }

    public Object clone() throws CloneNotSupportedException {
        RoleInstance cloned = (RoleInstance)super.clone();
        cloned.endpoints = new ArrayList<Endpoint>(this.endpoints);
        return cloned;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void addEndpoint(Endpoint endpoint) {
        Preconditions.checkArgument((endpoint != null ? 1 : 0) != 0);
        this.endpoints.add(endpoint);
    }

    public void registerPortEndpoint(int port, String api) {
        Endpoint epr = RegistryTypeUtils.inetAddrEndpoint((String)api, (String)"tcp", (String)this.host, (int)port);
        this.addEndpoint(epr);
    }

    public ContainerInformation serialize() {
        ContainerInformation info = new ContainerInformation();
        info.containerId = this.id;
        info.component = this.role;
        info.appVersion = this.appVersion;
        info.startTime = this.startTime;
        info.createTime = this.createTime;
        info.completionTime = this.completionTime;
        info.diagnostics = this.diagnostics;
        info.state = this.state;
        info.host = this.host;
        info.hostURL = this.hostURL;
        Boolean bl = info.released = this.released ? Boolean.TRUE : null;
        if (this.placement != null) {
            info.placement = this.placement.toString();
        }
        if (this.output != null) {
            info.output = this.output;
        }
        info.logLink = this.logLink;
        return info;
    }
}

