/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.slider.api.types.NodeEntryInformation;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.common.tools.Comparators;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.server.appmaster.state.ContainerPriority;
import org.apache.slider.server.appmaster.state.NodeEntry;
import org.apache.slider.server.appmaster.state.RoleStatus;

public class NodeInstance {
    public final String hostname;
    private boolean blacklisted = false;
    private NodeState nodeState = NodeState.RUNNING;
    private NodeReport nodeReport = null;
    private long nodeStateUpdateTime = 0L;
    private String nodeLabels = "";
    private final List<NodeEntry> nodeEntries;

    public NodeInstance(String hostname, int roles) {
        this.hostname = hostname;
        this.nodeEntries = new ArrayList<NodeEntry>(roles);
    }

    public synchronized void setBlacklisted(boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    public synchronized boolean updateNode(NodeReport report) {
        this.nodeStateUpdateTime = report.getLastHealthReportTime();
        this.nodeReport = report;
        NodeState oldState = this.nodeState;
        boolean oldStateUnusable = oldState.isUnusable();
        this.nodeState = report.getNodeState();
        boolean newUsable = !this.nodeState.isUnusable();
        boolean nodeNowAvailable = oldStateUnusable && newUsable;
        String labels = this.nodeLabels;
        this.nodeLabels = SliderUtils.extractNodeLabel(report);
        return nodeNowAvailable || newUsable && !this.nodeLabels.equals(labels);
    }

    public String getNodeLabels() {
        return this.nodeLabels;
    }

    public synchronized NodeEntry get(int role) {
        for (NodeEntry nodeEntry : this.nodeEntries) {
            if (nodeEntry.rolePriority != role) continue;
            return nodeEntry;
        }
        return null;
    }

    public synchronized NodeEntry getOrCreate(int role) {
        NodeEntry entry = this.get(role);
        if (entry == null) {
            entry = new NodeEntry(role);
            this.nodeEntries.add(entry);
        }
        return entry;
    }

    public NodeEntry getOrCreate(Container container) {
        return this.getOrCreate(ContainerPriority.extractRole(container));
    }

    public int getActiveRoleInstances(int role) {
        NodeEntry nodeEntry = this.get(role);
        return nodeEntry != null ? nodeEntry.getActive() : 0;
    }

    public int getLiveRoleInstances(int role) {
        NodeEntry nodeEntry = this.get(role);
        return nodeEntry != null ? nodeEntry.getLive() : 0;
    }

    public boolean isOnline() {
        return !this.nodeState.isUnusable();
    }

    public boolean isConsideredUnreliable(int role, int threshold) {
        NodeEntry entry = this.get(role);
        return entry != null && entry.getFailedRecently() > threshold;
    }

    public synchronized NodeEntry remove(int role) {
        NodeEntry nodeEntry = this.get(role);
        if (nodeEntry != null) {
            this.nodeEntries.remove(nodeEntry);
        }
        return nodeEntry;
    }

    public synchronized void set(int role, NodeEntry nodeEntry) {
        this.remove(role);
        this.nodeEntries.add(nodeEntry);
    }

    public synchronized boolean purgeUnusedEntries(long absoluteTime) {
        boolean active = false;
        ListIterator<NodeEntry> entries = this.nodeEntries.listIterator();
        while (entries.hasNext()) {
            NodeEntry entry = entries.next();
            if (entry.notUsedSince(absoluteTime) && entry.getFailedRecently() == 0) {
                entries.remove();
                continue;
            }
            active = true;
        }
        return active;
    }

    public synchronized void resetFailedRecently() {
        for (NodeEntry entry : this.nodeEntries) {
            entry.resetFailedRecently();
        }
    }

    public String toString() {
        return this.hostname;
    }

    public String toFullString() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append("{ ");
        for (NodeEntry entry : this.nodeEntries) {
            sb.append(String.format("\n  [%02d]  ", entry.rolePriority));
            sb.append(entry.toString());
        }
        sb.append("} ");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInstance that = (NodeInstance)o;
        return this.hostname.equals(that.hostname);
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    public boolean exceedsFailureThreshold(RoleStatus role) {
        NodeEntry entry = this.get(role.getKey());
        int numFailuresOnLastHost = entry != null ? entry.getFailedRecently() : 0;
        int failureThreshold = role.getNodeFailureThreshold();
        return failureThreshold < 0 || numFailuresOnLastHost > failureThreshold;
    }

    public synchronized NodeInformation serialize(Map<Integer, String> naming) {
        NodeInformation info = new NodeInformation();
        info.hostname = this.hostname;
        info.state = "" + this.nodeState;
        info.lastUpdated = this.nodeStateUpdateTime;
        info.labels = this.nodeLabels;
        if (this.nodeReport != null) {
            info.httpAddress = this.nodeReport.getHttpAddress();
            info.rackName = this.nodeReport.getRackName();
            info.healthReport = this.nodeReport.getHealthReport();
        }
        info.entries = new HashMap<String, NodeEntryInformation>(this.nodeEntries.size());
        for (NodeEntry nodeEntry : this.nodeEntries) {
            String name = naming.get(nodeEntry.rolePriority);
            if (name == null) {
                name = Integer.toString(nodeEntry.rolePriority);
            }
            info.entries.put(name, nodeEntry.serialize());
        }
        return info;
    }

    public boolean canHost(int role, String label) {
        return this.isOnline() && (SliderUtils.isUnset(label) || label.equals(this.nodeLabels)) && this.getOrCreate(role).isAvailable();
    }

    public static class CompareNames
    implements Comparator<NodeInstance>,
    Serializable {
        @Override
        public int compare(NodeInstance left, NodeInstance right) {
            return left.hostname.compareTo(right.hostname);
        }
    }

    public static class MoreActiveThan
    implements Comparator<NodeInstance>,
    Serializable {
        private final int role;

        public MoreActiveThan(int role) {
            this.role = role;
        }

        @Override
        public int compare(NodeInstance left, NodeInstance right) {
            int activeLeft = left.getActiveRoleInstances(this.role);
            int activeRight = right.getActiveRoleInstances(this.role);
            return activeRight - activeLeft;
        }
    }

    public static class Preferred
    implements Comparator<NodeInstance>,
    Serializable {
        private static final Comparators.InvertedLongComparator comparator = new Comparators.InvertedLongComparator();
        private final int role;

        public Preferred(int role) {
            this.role = role;
        }

        @Override
        public int compare(NodeInstance o1, NodeInstance o2) {
            NodeEntry left = o1.get(this.role);
            NodeEntry right = o2.get(this.role);
            long ageL = left != null ? left.getLastUsed() : -1L;
            long ageR = right != null ? right.getLastUsed() : -1L;
            return comparator.compare(ageL, ageR);
        }
    }
}

