/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.actions;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.slider.api.SliderExitReason;
import org.apache.slider.core.exceptions.TriggerClusterTeardownException;
import org.apache.slider.core.main.ExitCodeProvider;
import org.apache.slider.server.appmaster.SliderAppMaster;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.state.AppState;

public class ActionStopSlider
extends AsyncAction {
    private int exitCode;
    private FinalApplicationStatus finalApplicationStatus;
    private String message;
    private final Exception ex;
    private SliderExitReason exitReason;

    public ActionStopSlider(String name) {
        super(name);
        this.ex = null;
    }

    public ActionStopSlider(String name, long delay, TimeUnit timeUnit, int exitCode, FinalApplicationStatus finalApplicationStatus, String message) {
        super(name, delay, timeUnit, 2);
        this.exitCode = exitCode;
        this.finalApplicationStatus = finalApplicationStatus;
        this.message = message;
        this.ex = null;
    }

    public ActionStopSlider(String name, int exitCode, FinalApplicationStatus finalApplicationStatus, String message) {
        super(name);
        this.exitCode = exitCode;
        this.finalApplicationStatus = finalApplicationStatus;
        this.message = message;
        this.ex = null;
    }

    public ActionStopSlider(TriggerClusterTeardownException ex) {
        this("stop", ex.getExitCode(), ex.getFinalApplicationStatus(), ex.getMessage());
    }

    public ActionStopSlider(Exception ex) {
        super("stop");
        if (ex instanceof ExitCodeProvider) {
            this.setExitCode(((ExitCodeProvider)((Object)ex)).getExitCode());
        } else {
            this.setExitCode(56);
        }
        this.setFinalApplicationStatus(FinalApplicationStatus.FAILED);
        this.setMessage(ex.getMessage());
        this.ex = ex;
    }

    @Override
    public void execute(SliderAppMaster appMaster, QueueAccess queueService, AppState appState) throws Exception {
        SliderAppMaster.getLog().info("SliderAppMasterApi.stopCluster: {}", (Object)this.message);
        appMaster.onAMStop(this);
    }

    @Override
    public String toString() {
        return String.format("%s:  exit code = %d, %s: %s;", this.name, this.exitCode, this.finalApplicationStatus, this.message);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public FinalApplicationStatus getFinalApplicationStatus() {
        return this.finalApplicationStatus;
    }

    public void setFinalApplicationStatus(FinalApplicationStatus finalApplicationStatus) {
        this.finalApplicationStatus = finalApplicationStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Exception getEx() {
        return this.ex;
    }

    public SliderExitReason getExitReason() {
        return this.exitReason;
    }

    public void setExitReason(SliderExitReason exitReason) {
        this.exitReason = exitReason;
    }
}

