/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.launch.AbstractLauncher;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.providers.ProviderUtils;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientProvider
extends Configured {
    private static final Logger log = LoggerFactory.getLogger(AbstractClientProvider.class);
    protected static final ProviderUtils providerUtils = new ProviderUtils(log);
    public static final String PROVIDER_RESOURCE_BASE = "org/apache/slider/providers/";
    public static final String PROVIDER_RESOURCE_BASE_ROOT = "/org/apache/slider/providers/";

    public AbstractClientProvider(Configuration conf) {
        super(conf);
    }

    public abstract String getName();

    public abstract List<ProviderRole> getRoles();

    public void validateInstanceDefinition(AggregateConf instanceDefinition, SliderFileSystem fs) throws SliderException {
        List<ProviderRole> roles = this.getRoles();
        ConfTreeOperations resources = instanceDefinition.getResourceOperations();
        for (ProviderRole role : roles) {
            String name = role.name;
            MapOperations component = resources.getComponent(role.group);
            if (component == null) continue;
            String instances = component.get("yarn.component.instances");
            if (instances == null) {
                String message = "No instance count provided for " + name;
                log.error("{} with \n{}", (Object)message, (Object)resources.toString());
                throw new BadClusterStateException(message, new Object[0]);
            }
            String ram = component.get("yarn.memory");
            String cores = component.get("yarn.vcores");
            providerUtils.getRoleResourceRequirement(ram, 256, Integer.MAX_VALUE);
            providerUtils.getRoleResourceRequirement(cores, 1, Integer.MAX_VALUE);
        }
    }

    public void prepareInstanceConfiguration(AggregateConf aggregateConf) throws SliderException, IOException {
    }

    public void prepareAMAndConfigForLaunch(SliderFileSystem fileSystem, Configuration serviceConf, AbstractLauncher launcher, AggregateConf instanceDescription, Path snapshotConfDirPath, Path generatedConfDirPath, Configuration clientConfExtras, String libdir, Path tempPath, boolean miniClusterTestRun) throws IOException, SliderException {
    }

    protected void mergeTemplates(AggregateConf instanceConf, String internalTemplate, String resourceTemplate, String appConfTemplate) throws IOException {
        ConfTreeOperations template;
        if (internalTemplate != null) {
            template = ConfTreeOperations.fromResource(internalTemplate);
            instanceConf.getInternalOperations().mergeWithoutOverwrite(template.confTree);
        }
        if (resourceTemplate != null) {
            ConfTreeOperations resTemplate = ConfTreeOperations.fromResource(resourceTemplate);
            instanceConf.getResourceOperations().mergeWithoutOverwrite(resTemplate.confTree);
        }
        if (appConfTemplate != null) {
            template = ConfTreeOperations.fromResource(appConfTemplate);
            instanceConf.getAppConfOperations().mergeWithoutOverwrite(template.confTree);
        }
    }

    public void preflightValidateClusterConfiguration(SliderFileSystem sliderFileSystem, String clustername, Configuration configuration, AggregateConf instanceDefinition, Path clusterDirPath, Path generatedConfDirPath, boolean secure) throws SliderException, IOException {
        this.validateInstanceDefinition(instanceDefinition, sliderFileSystem);
    }

    public Set<String> getApplicationTags(SliderFileSystem fileSystem, String appDef) throws SliderException {
        return Collections.emptySet();
    }

    public void processClientOperation(SliderFileSystem fileSystem, RegistryOperations registryOperations, Configuration configuration, String operation, File clientInstallPath, File clientPackage, JSONObject clientConfig, String name) throws SliderException {
        throw new SliderException("Provider does not support client operations.");
    }
}

