/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.slider.common.tools.MapRSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialUtils {
    public static final String JOB_CREDENTIALS_BINARY = "mapreduce.job.credentials.binary";
    private static final Logger LOG = LoggerFactory.getLogger(CredentialUtils.class);

    private CredentialUtils() {
    }

    public static ByteBuffer marshallCredentials(Credentials credentials) throws IOException {
        ByteBuffer buffer = null;
        if (!credentials.getAllTokens().isEmpty()) {
            try (DataOutputBuffer dob = new DataOutputBuffer();){
                credentials.writeTokenStorageToStream((DataOutputStream)dob);
            }
            buffer = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        }
        return buffer;
    }

    public static File locateEnvCredentials(Map<String, String> env, Configuration conf, StringBuffer sourceTextOut) throws FileNotFoundException {
        String tokenFilename = env.get("HADOOP_TOKEN_FILE_LOCATION");
        String source = "environment variable HADOOP_TOKEN_FILE_LOCATION";
        if (tokenFilename == null) {
            tokenFilename = conf.get(JOB_CREDENTIALS_BINARY);
            source = "configuration option mapreduce.job.credentials.binary";
        }
        if (tokenFilename != null) {
            File file = new File(tokenFilename.trim());
            String details = String.format("Token File %s from %s", file, source);
            if (!file.exists()) {
                throw new FileNotFoundException("No " + details);
            }
            if (!file.isFile() && !file.canRead()) {
                throw new FileNotFoundException("Cannot read " + details);
            }
            sourceTextOut.append(details);
            return file;
        }
        return null;
    }

    public static Credentials loadTokensFromEnvironment(Map<String, String> env, Configuration conf) throws IOException {
        StringBuffer origin = new StringBuffer();
        File file = CredentialUtils.locateEnvCredentials(env, conf, origin);
        if (file != null) {
            LOG.debug("Using {}", (Object)origin);
            return Credentials.readTokenStorageFile((File)file, (Configuration)conf);
        }
        return null;
    }

    public static void saveTokens(File file, Credentials credentials) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataOutputStream daos = new DataOutputStream(new FileOutputStream(file));){
            credentials.writeTokenStorageToStream(daos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getRMPrincipal(Configuration conf) throws IOException {
        String hostname;
        String principal = conf.get("yarn.resourcemanager.principal", "");
        Preconditions.checkState((!principal.isEmpty() ? 1 : 0) != 0, (Object)"Not set: yarn.resourcemanager.principal");
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            if (yarnConf.get("yarn.resourcemanager.ha.id") == null) {
                String[] rmIds = yarnConf.getStrings("yarn.resourcemanager.ha.rm-ids");
                Preconditions.checkState((rmIds != null && rmIds.length > 0 ? 1 : 0) != 0, (Object)"Not set yarn.resourcemanager.ha.rm-ids");
                yarnConf.set("yarn.resourcemanager.ha.id", rmIds[0]);
            }
            hostname = yarnConf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032).getHostName();
        } else {
            hostname = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032).getHostName();
        }
        return SecurityUtil.getServerPrincipal((String)principal, (String)hostname);
    }

    public static Token<?>[] addRMRenewableFSDelegationTokens(Configuration conf, FileSystem fs, Credentials credentials) throws IOException {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0);
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0);
        if (MapRSecurityUtil.isMapRSecurityEnabled() || MapRSecurityUtil.isKerberosEnabled()) {
            return fs.addDelegationTokens(CredentialUtils.getRMPrincipal(conf), credentials);
        }
        return null;
    }

    public static void addSelfRenewableFSDelegationTokens(FileSystem fs, Credentials credentials) throws IOException {
        Preconditions.checkArgument((fs != null ? 1 : 0) != 0);
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0);
        fs.addDelegationTokens(CredentialUtils.getSelfRenewer(), credentials);
    }

    public static String getSelfRenewer() throws IOException {
        return UserGroupInformation.getLoginUser().getShortUserName();
    }

    public static Token<TokenIdentifier> addRMDelegationToken(YarnClient yarnClient, Credentials credentials) throws IOException, YarnException {
        Configuration conf = yarnClient.getConfig();
        Text rmPrincipal = new Text(CredentialUtils.getRMPrincipal(conf));
        Text rmDTService = ClientRMProxy.getRMDelegationTokenService((Configuration)conf);
        Token rmDelegationToken = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)yarnClient.getRMDelegationToken(rmPrincipal), (Text)rmDTService);
        credentials.addToken(rmDelegationToken.getService(), rmDelegationToken);
        return rmDelegationToken;
    }

    public static Token<TimelineDelegationTokenIdentifier> maybeAddTimelineToken(Configuration conf, Credentials credentials) throws IOException, YarnException {
        if (conf.getBoolean("yarn.timeline-service.enabled", false)) {
            LOG.debug("Timeline service enabled -fetching token");
            Throwable throwable = null;
            Object var3_4 = null;
            try (TimelineClient timelineClient = TimelineClient.createTimelineClient();){
                timelineClient.init(conf);
                timelineClient.start();
                Token token = timelineClient.getDelegationToken(CredentialUtils.getRMPrincipal(conf));
                credentials.addToken(token.getService(), token);
                return token;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        LOG.debug("Timeline service is disabled");
        return null;
    }

    public static Credentials filterTokens(Credentials credentials, List<Text> filter) {
        Credentials result = new Credentials(credentials);
        Iterator iter = result.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            LOG.debug("Token {}", (Object)token.getKind());
            if (!filter.contains(token.getKind())) continue;
            LOG.debug("Filtering token {}", (Object)token.getKind());
            iter.remove();
        }
        return result;
    }

    public static String dumpTokens(Credentials credentials, String separator) {
        ArrayList sorted = new ArrayList(credentials.getAllTokens());
        Collections.sort(sorted, new TokenComparator());
        StringBuilder buffer = new StringBuilder(sorted.size() * 128);
        for (Token token : sorted) {
            buffer.append(CredentialUtils.tokenToString((Token<? extends TokenIdentifier>)token)).append(separator);
        }
        return buffer.toString();
    }

    public static String tokenToString(Token<? extends TokenIdentifier> token) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(token.toString());
        try {
            TokenIdentifier ti = token.decodeIdentifier();
            buffer.append("; ").append(ti);
            if (ti instanceof AbstractDelegationTokenIdentifier) {
                AbstractDelegationTokenIdentifier dt = (AbstractDelegationTokenIdentifier)ti;
                buffer.append("; Renewer: ").append(dt.getRenewer());
                buffer.append("; Issued: ").append(df.format(new Date(dt.getIssueDate())));
                buffer.append("; Max Date: ").append(df.format(new Date(dt.getMaxDate())));
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to decode {}: {}", new Object[]{token, e, e});
        }
        return buffer.toString();
    }

    public static long getTokenExpiryTime(Token token) throws IOException {
        TokenIdentifier identifier = token.decodeIdentifier();
        Preconditions.checkState((boolean)(identifier instanceof AbstractDelegationTokenIdentifier), (String)"Token %s of type: %s has an identifier which cannot be examined: %s", (Object[])new Object[]{token, token.getClass(), identifier});
        AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)identifier;
        return id.getMaxDate();
    }

    private static class TokenComparator
    implements Comparator<Token<? extends TokenIdentifier>>,
    Serializable {
        private TokenComparator() {
        }

        @Override
        public int compare(Token<? extends TokenIdentifier> left, Token<? extends TokenIdentifier> right) {
            return left.getKind().toString().compareTo(right.getKind().toString());
        }
    }
}

