/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.launch.ClasspathConstructor;
import org.apache.slider.core.launch.CommandLineBuilder;
import org.apache.slider.core.launch.CredentialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLauncher
extends Configured {
    private static final Logger log = LoggerFactory.getLogger(AbstractLauncher.class);
    public static final String CLASSPATH = "CLASSPATH";
    protected final CoreFileSystem coreFileSystem;
    protected final Map<String, String> envVars = new HashMap<String, String>();
    protected final MapOperations env = new MapOperations("env", this.envVars);
    protected final ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
    protected final List<String> commands = new ArrayList<String>(20);
    protected final Map<String, LocalResource> localResources = new HashMap<String, LocalResource>();
    protected final Map<String, String> mountPaths = new HashMap<String, String>();
    private final Map<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
    protected final Credentials credentials;
    protected LogAggregationContext logAggregationContext;
    protected boolean yarnDockerMode = false;
    protected String dockerImage;
    protected String yarnContainerMountPoints;
    protected String runPrivilegedContainer;

    protected AbstractLauncher(Configuration conf, CoreFileSystem coreFileSystem, Credentials credentials) {
        super(conf);
        this.coreFileSystem = coreFileSystem;
        this.credentials = credentials != null ? credentials : new Credentials();
    }

    public ContainerLaunchContext getContainerLaunchContext() {
        return this.containerLaunchContext;
    }

    public void setYarnDockerMode(boolean yarnDockerMode) {
        this.yarnDockerMode = yarnDockerMode;
    }

    public MapOperations getEnv() {
        return this.env;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public Map<String, LocalResource> getLocalResources() {
        return this.localResources;
    }

    public void addLocalResource(String subPath, LocalResource resource) {
        this.localResources.put(subPath, resource);
    }

    public void addLocalResource(String subPath, LocalResource resource, String mountPath) {
        this.localResources.put(subPath, resource);
        this.mountPaths.put(subPath, mountPath);
    }

    public void addLocalResources(Map<String, LocalResource> resourceMap) {
        this.localResources.putAll(resourceMap);
    }

    public Map<String, ByteBuffer> getServiceData() {
        return this.serviceData;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void addCommandLine(CommandLineBuilder cmd) {
        this.commands.add(cmd.build());
    }

    public void addCommand(String cmd) {
        this.commands.add(cmd);
    }

    public void addCommands(List<String> commandList) {
        this.commands.addAll(commandList);
    }

    public String getCommandsAsString() {
        return SliderUtils.join(this.getCommands(), "; ");
    }

    public ContainerLaunchContext completeContainerLaunch() throws IOException {
        String cmdStr = SliderUtils.join(this.commands, " ", false);
        log.debug("Completed setting up container command {}", (Object)cmdStr);
        this.containerLaunchContext.setCommands(this.commands);
        if (log.isDebugEnabled()) {
            log.debug("Environment variables");
            for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
                log.debug("    \"{}\"=\"{}\"", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.containerLaunchContext.setEnvironment((Map)this.env);
        if (log.isDebugEnabled()) {
            log.debug("Service Data size");
            for (Map.Entry<String, Object> entry : this.serviceData.entrySet()) {
                log.debug("\"{}\"=> {} bytes of data", (Object)entry.getKey(), (Object)((ByteBuffer)entry.getValue()).array().length);
            }
        }
        this.containerLaunchContext.setServiceData(this.serviceData);
        this.dumpLocalResources();
        this.containerLaunchContext.setLocalResources(this.localResources);
        log.debug("{} tokens", (Object)this.credentials.numberOfTokens());
        this.containerLaunchContext.setTokens(CredentialUtils.marshallCredentials(this.credentials));
        if (this.yarnDockerMode) {
            Map map = this.containerLaunchContext.getEnvironment();
            map.put("YARN_CONTAINER_RUNTIME_TYPE", "docker");
            map.put("YARN_CONTAINER_RUNTIME_DOCKER_IMAGE", this.dockerImage);
            map.put("YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINER", this.runPrivilegedContainer);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> mount : this.mountPaths.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(mount.getKey());
                sb.append(":");
                sb.append(mount.getValue());
            }
            map.put("YARN_CONTAINER_RUNTIME_DOCKER_LOCAL_RESOURCE_MOUNTS", sb.toString());
            log.info("yarn docker env var has been set {}", (Object)this.containerLaunchContext.getEnvironment().toString());
        }
        return this.containerLaunchContext;
    }

    private void dumpLocalResources() {
        if (log.isDebugEnabled()) {
            log.debug("{} resources: ", (Object)this.localResources.size());
            for (Map.Entry<String, LocalResource> entry : this.localResources.entrySet()) {
                String key = entry.getKey();
                LocalResource val = entry.getValue();
                log.debug(String.valueOf(key) + "=" + SliderUtils.stringify(val.getResource()));
            }
        }
    }

    protected void propagateUsernameInInsecureCluster() throws IOException {
        String userName = UserGroupInformation.getCurrentUser().getUserName();
        this.env.put("HADOOP_USER_NAME", userName);
    }

    public void extractResourceRequirements(Resource resource, Map<String, String> map) {
        if (map != null) {
            MapOperations options = new MapOperations("", map);
            resource.setMemory(options.getOptionInt("yarn.memory", resource.getMemory()));
            resource.setVirtualCores(options.getOptionInt("yarn.vcores", resource.getVirtualCores()));
        }
    }

    public void extractAmRetryCount(ApplicationSubmissionContext submissionContext, Map<String, String> map) {
        if (map != null) {
            MapOperations options = new MapOperations("", map);
            long amRetryCountWindow = options.getOptionLong("yarn.resourcemanager.am.retry-count-window-ms", 300000L);
            log.info("Setting {} to {}", (Object)"yarn.resourcemanager.am.retry-count-window-ms", (Object)amRetryCountWindow);
            submissionContext.setAttemptFailuresValidityInterval(amRetryCountWindow);
        }
    }

    public void extractLogAggregationContext(Map<String, String> map) {
        if (map != null) {
            String logPatternSepStr = "\\|";
            String logPatternJoinStr = "|";
            MapOperations options = new MapOperations("", map);
            ArrayList<String> logIncludePatterns = new ArrayList<String>();
            String includePatternExpression = options.getOption("yarn.log.include.patterns", "").trim();
            if (!includePatternExpression.isEmpty()) {
                String[] includePatterns;
                String[] stringArray = includePatterns = includePatternExpression.split(logPatternSepStr);
                int n = includePatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String includePattern = stringArray[n2];
                    String trimmedIncludePattern = includePattern.trim();
                    if (!trimmedIncludePattern.isEmpty()) {
                        logIncludePatterns.add(trimmedIncludePattern);
                    }
                    ++n2;
                }
            }
            String logIncludePattern = StringUtils.join(logIncludePatterns, (String)logPatternJoinStr);
            log.info("Log include patterns: {}", (Object)logIncludePattern);
            ArrayList<String> logExcludePatterns = new ArrayList<String>();
            String excludePatternExpression = options.getOption("yarn.log.exclude.patterns", "").trim();
            if (!excludePatternExpression.isEmpty()) {
                String[] excludePatterns;
                String[] stringArray = excludePatterns = excludePatternExpression.split(logPatternSepStr);
                int n = excludePatterns.length;
                int n3 = 0;
                while (n3 < n) {
                    String excludePattern = stringArray[n3];
                    String trimmedExcludePattern = excludePattern.trim();
                    if (!trimmedExcludePattern.isEmpty()) {
                        logExcludePatterns.add(trimmedExcludePattern);
                    }
                    ++n3;
                }
            }
            String logExcludePattern = StringUtils.join(logExcludePatterns, (String)logPatternJoinStr);
            log.info("Log exclude patterns: {}", (Object)logExcludePattern);
            try {
                Method logAggregationContextMethod = LogAggregationContext.class.getMethod("newInstance", String.class, String.class, String.class, String.class);
                if (StringUtils.isEmpty((String)logIncludePattern) && StringUtils.isEmpty((String)logExcludePattern)) {
                    logIncludePattern = ".*";
                    logExcludePattern = "";
                } else if (StringUtils.isEmpty((String)logIncludePattern) && StringUtils.isNotEmpty((String)logExcludePattern)) {
                    logIncludePattern = ".*";
                } else if (StringUtils.isNotEmpty((String)logIncludePattern) && StringUtils.isEmpty((String)logExcludePattern)) {
                    logExcludePattern = "";
                }
                log.debug("LogAggregationContext newInstance method for rolled logs include/exclude patterns is available");
                log.info("Modified log include patterns: {}", (Object)logIncludePattern);
                log.info("Modified log exclude patterns: {}", (Object)logExcludePattern);
                this.logAggregationContext = (LogAggregationContext)logAggregationContextMethod.invoke(null, null, null, logIncludePattern, logExcludePattern);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.debug("LogAggregationContext newInstance method for rolled logs include/exclude patterns is not available - fallback to old one");
                log.debug(e.toString());
                this.logAggregationContext = LogAggregationContext.newInstance((String)logIncludePattern, (String)logExcludePattern);
            }
        }
    }

    public void setClasspath(ClasspathConstructor classpath) {
        this.setEnv(CLASSPATH, classpath.buildClasspath());
    }

    public void setEnv(String var, String value) {
        Preconditions.checkArgument((var != null ? 1 : 0) != 0, (Object)"null variable name");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        this.env.put(var, value);
    }

    public void maybeSetEnv(String var, String value) {
        if (value != null) {
            this.setEnv(var, value);
        }
    }

    public void putEnv(Map<String, String> map) {
        this.env.putAll((Map<? extends String, ? extends String>)map);
    }

    public boolean copyEnvVars(MapOperations options) {
        if (options == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("env.")) continue;
            key = key.substring("env.".length());
            this.env.put(key, entry.getValue());
        }
        return true;
    }

    public String[] dumpEnvToString() {
        ArrayList<String> nodeEnv = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.env.entrySet()) {
            String envElt = String.format("%s=\"%s\"", entry.getKey(), entry.getValue());
            log.debug(envElt);
            nodeEnv.add(envElt);
        }
        String[] envDescription = nodeEnv.toArray(new String[nodeEnv.size()]);
        return envDescription;
    }

    public void submitDirectory(Path srcDir, String destRelativeDir) throws IOException {
        Map<String, LocalResource> confResources = this.coreFileSystem.submitDirectory(srcDir, destRelativeDir);
        this.addLocalResources(confResources);
    }

    public String extractLabelExpression(Map<String, String> map) {
        if (map != null) {
            MapOperations options = new MapOperations("", map);
            return options.getOption("yarn.label.expression", null);
        }
        return null;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void setYarnContainerMountPoints(String yarnContainerMountPoints) {
        this.yarnContainerMountPoints = yarnContainerMountPoints;
    }

    public void setRunPrivilegedContainer(String runPrivilegedContainer) {
        this.runPrivilegedContainer = runPrivilegedContainer;
    }
}

