/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.params;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.params.AbstractActionArgs;
import org.apache.slider.common.params.AddonArgsDelegate;
import org.apache.slider.common.params.AppAndResouceOptionArgsDelegate;
import org.apache.slider.common.params.ComponentArgsDelegate;
import org.apache.slider.common.params.PathArgumentConverter;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;

public abstract class AbstractClusterBuildingActionArgs
extends AbstractActionArgs {
    @Parameter(names={"--appconf"}, description="Path to cluster configuration directory in HDFS", converter=PathArgumentConverter.class)
    public Path confdir;
    @Parameter(names={"--zkpath"}, description="Zookeeper path for the application")
    public String appZKPath;
    @Parameter(names={"--zkhosts"}, description="comma separated list of the Zookeeper hosts")
    public String zkhosts;
    @Parameter(names={"--image"}, description="The full path to a .tar or .tar.gz path containing the application", converter=PathArgumentConverter.class)
    public Path image;
    @Parameter(names={"--apphome"}, description="Home directory of a pre-installed application")
    public String appHomeDir;
    @Parameter(names={"--provider"}, description="Provider of the specific cluster application")
    public String provider = "agent";
    @Parameter(names={"--package"}, description="URI to a slider package")
    public String packageURI;
    @Parameter(names={"--resources"}, description="File defining the resources of this instance")
    public File resources;
    @Parameter(names={"--template"}, description="Template application configuration")
    public File template;
    @Parameter(names={"--metainfo"}, description="Application meta info file")
    public File appMetaInfo;
    @Parameter(names={"--metainfojson"}, description="Application meta info JSON blob")
    public String appMetaInfoJson;
    @Parameter(names={"--appdef"}, description="Application def (folder or a zip package)")
    public File appDef;
    @Parameter(names={"--queue"}, description="Queue to submit the application")
    public String queue;
    @ParametersDelegate
    public ComponentArgsDelegate componentDelegate = new ComponentArgsDelegate();
    @ParametersDelegate
    public AddonArgsDelegate addonDelegate = new AddonArgsDelegate();
    @ParametersDelegate
    public AppAndResouceOptionArgsDelegate optionsDelegate = new AppAndResouceOptionArgsDelegate();

    public Map<String, String> getOptionsMap() throws BadCommandArgumentsException {
        return this.optionsDelegate.getOptionsMap();
    }

    public Map<String, Map<String, String>> getCompOptionMap() throws BadCommandArgumentsException {
        return this.optionsDelegate.getCompOptionMap();
    }

    public Map<String, String> getResourceOptionsMap() throws BadCommandArgumentsException {
        return this.optionsDelegate.getResourceOptionsMap();
    }

    public Map<String, Map<String, String>> getResourceCompOptionMap() throws BadCommandArgumentsException {
        return this.optionsDelegate.getResourceCompOptionMap();
    }

    @VisibleForTesting
    public List<String> getComponentTuples() {
        return this.componentDelegate.getComponentTuples();
    }

    public Map<String, String> getComponentMap() throws BadCommandArgumentsException {
        return this.componentDelegate.getComponentMap();
    }

    @VisibleForTesting
    public List<String> getAddonTuples() {
        return this.addonDelegate.getAddonTuples();
    }

    public Map<String, String> getAddonMap() throws BadCommandArgumentsException {
        return this.addonDelegate.getAddonMap();
    }

    public Path getConfdir() {
        return this.confdir;
    }

    public String getAppZKPath() {
        return this.appZKPath;
    }

    public String getZKhosts() {
        return this.zkhosts;
    }

    public Path getImage() {
        return this.image;
    }

    public String getAppHomeDir() {
        return this.appHomeDir;
    }

    public String getProvider() {
        return this.provider;
    }

    public ConfTree buildAppOptionsConfTree() throws BadCommandArgumentsException {
        return this.buildConfTree(this.getOptionsMap());
    }

    public ConfTree buildResourceOptionsConfTree() throws BadCommandArgumentsException {
        return this.buildConfTree(this.getResourceOptionsMap());
    }

    protected ConfTree buildConfTree(Map<String, String> optionsMap) throws BadCommandArgumentsException {
        ConfTree confTree = new ConfTree();
        new ConfTreeOperations(confTree);
        confTree.global.putAll(optionsMap);
        return confTree;
    }
}

