/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.NotFoundException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.registry.docstore.ConfigFormat;
import org.apache.slider.core.registry.docstore.PublishedConfigSet;
import org.apache.slider.core.registry.docstore.PublishedConfiguration;
import org.apache.slider.core.registry.docstore.PublishedConfigurationOutputter;
import org.apache.slider.core.registry.retrieve.RegistryRetriever;

public class ClientUtils {
    public static ServiceRecord lookupServiceRecord(RegistryOperations rops, String user, String name) throws IOException, SliderException {
        return ClientUtils.lookupServiceRecord(rops, user, null, name);
    }

    public static ServiceRecord lookupServiceRecord(RegistryOperations rops, String user, String type, String name) throws IOException, SliderException {
        user = StringUtils.isEmpty((String)user) ? RegistryUtils.currentUser() : RegistryPathUtils.encodeForRegistry((String)user);
        if (StringUtils.isEmpty((String)type)) {
            type = "org-apache-slider";
        }
        String path = RegistryUtils.servicePath((String)user, (String)type, (String)name);
        return ClientUtils.resolve(rops, path);
    }

    public static ServiceRecord resolve(RegistryOperations rops, String path) throws IOException, SliderException {
        try {
            return rops.resolve(path);
        }
        catch (PathNotFoundException | NoRecordException e) {
            throw new NotFoundException(e.getPath().toString(), new Object[]{e});
        }
    }

    public static PublishedConfiguration getConfigFromRegistry(RegistryOperations rops, Configuration configuration, String configName, String appName, String user, boolean external) throws IOException, SliderException {
        ServiceRecord instance = ClientUtils.lookupServiceRecord(rops, user, appName);
        RegistryRetriever retriever = new RegistryRetriever(configuration, instance);
        PublishedConfigSet configurations = retriever.getConfigurations(external);
        PublishedConfiguration published = retriever.retrieveConfiguration(configurations, configName, external);
        return published;
    }

    public static String saveOrReturnConfig(PublishedConfiguration published, String format, File destPath, String fileName) throws BadCommandArgumentsException, IOException {
        boolean print;
        ConfigFormat configFormat = ConfigFormat.resolve(format);
        if (configFormat == null) {
            throw new BadCommandArgumentsException("Unknown/Unsupported format %s ", format);
        }
        PublishedConfigurationOutputter outputter = PublishedConfigurationOutputter.createOutputter(configFormat, published);
        boolean bl = print = destPath == null;
        if (!print) {
            if (destPath.isDirectory()) {
                destPath = new File(destPath, fileName);
            }
            outputter.save(destPath);
            return null;
        }
        return outputter.asString();
    }
}

