/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import io.druid.data.input.InputRow;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.ShardSpecLookup;
import io.druid.timeline.partition.SingleElementPartitionChunk;
import java.util.List;
import java.util.Map;

public class NoneShardSpec
implements ShardSpec {
    private static final NoneShardSpec INSTANCE = new NoneShardSpec();

    @JsonCreator
    public static NoneShardSpec instance() {
        return INSTANCE;
    }

    @Deprecated
    public NoneShardSpec() {
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new SingleElementPartitionChunk<T>(obj);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return true;
    }

    @Override
    public int getPartitionNum() {
        return 0;
    }

    @Override
    public ShardSpecLookup getLookup(final List<ShardSpec> shardSpecs) {
        return new ShardSpecLookup(){

            @Override
            public ShardSpec getShardSpec(long timestamp, InputRow row) {
                return (ShardSpec)shardSpecs.get(0);
            }
        };
    }

    @Override
    public Map<String, Range<String>> getDomain() {
        return ImmutableMap.of();
    }

    public boolean equals(Object obj) {
        return obj instanceof NoneShardSpec;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "NoneShardSpec";
    }
}

