/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.types;

import java.io.Serializable;
import java.util.Date;
import org.ojai.annotation.API;
import org.ojai.exceptions.ParseException;
import org.ojai.joda.DateTime;
import org.ojai.joda.LocalDate;
import org.ojai.joda.LocalTime;

@API.Public
public final class OTime
implements Comparable<OTime>,
Serializable {
    private static final long serialVersionUID = -5766126644406257565L;
    private static final DateTime EPOCH_DATE = new LocalDate(1970, 1, 1).toDateTimeAtStartOfDay();
    private volatile transient LocalTime time;
    private final int millisOfDay;

    public static OTime parse(String timeStr) {
        try {
            return new OTime(LocalTime.parse(timeStr));
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e);
        }
    }

    public static OTime fromMillisOfDay(int millisOfDay) {
        return new OTime(millisOfDay);
    }

    public OTime(long epoh) {
        this(new LocalTime(epoh));
    }

    public OTime(int hourOfDay, int minutes, int seconds) {
        this(hourOfDay, minutes, seconds, 0);
    }

    public OTime(int hourOfDay, int minutes, int seconds, int ms) {
        this(new LocalTime(hourOfDay, minutes, seconds, ms));
    }

    public OTime(Date date) {
        this(LocalTime.fromDateFields(date));
    }

    private OTime(LocalTime localTime) {
        this.time = localTime;
        this.millisOfDay = localTime.getMillisOfDay();
    }

    private OTime(int millisOfDay) {
        this.millisOfDay = millisOfDay;
    }

    public int getHour() {
        return this.getTime().getHourOfDay();
    }

    public int getMinute() {
        return this.getTime().getMinuteOfHour();
    }

    public int getSecond() {
        return this.getTime().getSecondOfMinute();
    }

    public int getMilliSecond() {
        return this.getTime().getMillisOfSecond();
    }

    public Date toDate() {
        return this.getTime().toDateTime(EPOCH_DATE).toDate();
    }

    public int toTimeInMillis() {
        return this.millisOfDay;
    }

    public String toShortTimeStr() {
        return this.toString("HH:mm");
    }

    public String toFullTimeStr() {
        return this.toString();
    }

    public String toTimeStr() {
        return this.millisOfDay % 1000 == 0 ? this.toString("HH:mm:ss") : this.toString("HH:mm:ss.SSS");
    }

    public String toString(String pattern) {
        return this.getTime().toString(pattern);
    }

    public String toString() {
        return this.getTime().toString();
    }

    public int hashCode() {
        return this.millisOfDay;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OTime other = (OTime)obj;
        return this.millisOfDay == other.millisOfDay;
    }

    @Override
    public int compareTo(OTime o) {
        return this.millisOfDay - o.millisOfDay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalTime getTime() {
        if (this.time == null) {
            OTime oTime = this;
            synchronized (oTime) {
                if (this.time == null) {
                    this.time = LocalTime.fromMillisOfDay(this.millisOfDay);
                }
            }
        }
        return this.time;
    }
}

