/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.beans.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Stack;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.annotation.API;
import org.ojai.beans.jackson.JacksonHelper;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Internal
public class DocumentGenerator
extends JsonGenerator {
    protected final DocumentBuilder b;
    protected final Stack<Boolean> mapCtxts;
    protected boolean closed = false;
    protected String currFieldName;
    protected ObjectCodec objectCodec;

    public DocumentGenerator(DocumentBuilder db) {
        this.b = db;
        this.mapCtxts = new Stack();
    }

    public Document getDocument() {
        return this.b.getDocument();
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public JsonGenerator disable(JsonGenerator.Feature feature) {
        return this;
    }

    public JsonGenerator enable(JsonGenerator.Feature feature) {
        return this;
    }

    public ObjectCodec getCodec() {
        return this.objectCodec;
    }

    public JsonGenerator setCodec(ObjectCodec c) {
        this.objectCodec = c;
        return this;
    }

    public JsonStreamContext getOutputContext() {
        return null;
    }

    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public Version version() {
        return JacksonHelper.VERSION;
    }

    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
        ByteBuffer buff = ByteBuffer.wrap(data, offset, len);
        if (this.inMap()) {
            this.b.put(this.currFieldName, buff);
        } else {
            this.b.add(buff);
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, value);
        } else {
            this.b.add(value);
        }
    }

    public void writeEndArray() throws IOException {
        this.b.endArray();
        this.mapCtxts.pop();
    }

    public void writeEndObject() throws IOException {
        this.b.endMap();
        this.mapCtxts.pop();
    }

    public void writeFieldName(String fieldName) throws IOException {
        this.currFieldName = fieldName;
    }

    public void writeFieldName(SerializableString fieldName) throws IOException {
        this.currFieldName = fieldName.getValue();
    }

    public void writeNull() throws IOException {
        if (this.inMap()) {
            this.b.putNull(this.currFieldName);
        } else {
            this.b.addNull();
        }
    }

    public void writeNumber(short value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, value);
        } else {
            this.b.add(value);
        }
    }

    public void writeNumber(int value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, value);
        } else {
            this.b.add(value);
        }
    }

    public void writeNumber(long value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, value);
        } else {
            this.b.add(value);
        }
    }

    public void writeNumber(BigInteger value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, new BigDecimal(value));
        } else {
            this.b.add(new BigDecimal(value));
        }
    }

    public void writeNumber(double value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, value);
        } else {
            this.b.add(value);
        }
    }

    public void writeNumber(float value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, value);
        } else {
            this.b.add(value);
        }
    }

    public void writeNumber(BigDecimal value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, value);
        } else {
            this.b.add(value);
        }
    }

    public void writeNumber(String value) throws IOException {
        if (value.contains(".")) {
            this.writeNumber(Double.valueOf(value));
        } else {
            this.writeNumber(Long.valueOf(value));
        }
    }

    public void writeObject(Object value) throws IOException {
        if (value instanceof Byte) {
            if (this.inMap()) {
                this.b.put(this.currFieldName, (Byte)value);
            } else {
                this.b.add((Byte)value);
            }
        } else if (value instanceof OInterval) {
            if (this.inMap()) {
                this.b.put(this.currFieldName, (OInterval)value);
            } else {
                this.b.add((OInterval)value);
            }
        } else if (value instanceof ODate) {
            if (this.inMap()) {
                this.b.put(this.currFieldName, (ODate)value);
            } else {
                this.b.add((ODate)value);
            }
        } else if (value instanceof OTime) {
            if (this.inMap()) {
                this.b.put(this.currFieldName, (OTime)value);
            } else {
                this.b.add((OTime)value);
            }
        } else if (value instanceof OTimestamp) {
            if (this.inMap()) {
                this.b.put(this.currFieldName, (OTimestamp)value);
            } else {
                this.b.add((OTimestamp)value);
            }
        } else {
            throw new IllegalStateException("writeObject() called for type " + value.getClass());
        }
    }

    public void writeStartArray() throws IOException {
        if (this.inMap()) {
            this.b.putNewArray(this.currFieldName);
        } else {
            this.b.addNewArray();
        }
        this.mapCtxts.push(false);
    }

    public void writeStartObject() throws IOException {
        if (this.inMap()) {
            this.b.putNewMap(this.currFieldName);
        } else {
            this.b.addNewMap();
        }
        this.mapCtxts.push(true);
    }

    public void writeString(String value) throws IOException {
        if (this.inMap()) {
            this.b.put(this.currFieldName, value);
        } else {
            this.b.add(value);
        }
    }

    public void writeString(SerializableString value) throws IOException {
        this.writeString(value.getValue());
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.writeString(new String(text, offset, length, "UTF-8"));
    }

    public void writeTree(TreeNode rootNode) throws IOException {
        if (rootNode == null) {
            this.writeNull();
        } else {
            if (this.objectCodec == null) {
                throw new IllegalStateException("No ObjectCodec defined");
            }
            this.objectCodec.writeValue((JsonGenerator)this, (Object)rootNode);
        }
    }

    public int getFeatureMask() {
        this.notImplemented();
        return 0;
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        this.notImplemented();
        return false;
    }

    public JsonGenerator setFeatureMask(int featureMask) {
        this.notImplemented();
        return this;
    }

    public int writeBinary(Base64Variant bv, InputStream data, int dataLength) throws IOException {
        this.notImplemented();
        return 0;
    }

    public void writeRaw(String value) throws IOException {
        this.notImplemented();
    }

    public void writeRaw(char value) throws IOException {
        this.notImplemented();
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        this.notImplemented();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this.notImplemented();
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        this.notImplemented();
    }

    public void writeRawValue(String value) throws IOException {
        this.notImplemented();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        this.notImplemented();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this.notImplemented();
    }

    private void notImplemented() {
        throw new RuntimeException("Called operation not implemented for DocumentGenerator.");
    }

    private boolean inMap() {
        return !this.mapCtxts.isEmpty() && this.mapCtxts.peek() != false;
    }
}

