/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.router;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import io.druid.query.BaseQuery;
import io.druid.query.Query;
import io.druid.server.router.TieredBrokerConfig;
import io.druid.server.router.TieredBrokerSelectorStrategy;

public class PriorityTieredBrokerSelectorStrategy
implements TieredBrokerSelectorStrategy {
    private final int minPriority;
    private final int maxPriority;

    @JsonCreator
    public PriorityTieredBrokerSelectorStrategy(@JsonProperty(value="minPriority") Integer minPriority, @JsonProperty(value="maxPriority") Integer maxPriority) {
        this.minPriority = minPriority == null ? 0 : minPriority;
        this.maxPriority = maxPriority == null ? 1 : maxPriority;
    }

    @Override
    public Optional<String> getBrokerServiceName(TieredBrokerConfig tierConfig, Query query) {
        int priority = BaseQuery.getContextPriority((Query)query, (int)0);
        if (priority < this.minPriority) {
            return Optional.of((Object)Iterables.getLast(tierConfig.getTierToBrokerMap().values(), (Object)tierConfig.getDefaultBrokerServiceName()));
        }
        if (priority >= this.maxPriority) {
            return Optional.of((Object)Iterables.getFirst(tierConfig.getTierToBrokerMap().values(), (Object)tierConfig.getDefaultBrokerServiceName()));
        }
        return Optional.absent();
    }
}

