/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.listener.resource;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.metamx.common.logger.Logger;
import io.druid.common.utils.ServletResourceUtils;
import io.druid.server.listener.resource.ListenerHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public abstract class AbstractListenerHandler<ObjType>
implements ListenerHandler {
    private static final Logger LOG = new Logger(AbstractListenerHandler.class);
    private final TypeReference<ObjType> inObjTypeRef;

    public AbstractListenerHandler(TypeReference<ObjType> inObjTypeRef) {
        this.inObjTypeRef = inObjTypeRef;
    }

    @Override
    public final Response handlePOST(InputStream inputStream, ObjectMapper mapper, String id) {
        try {
            Object o = this.post((Map<String, ObjType>)ImmutableMap.of((Object)id, (Object)mapper.readValue(inputStream, this.inObjTypeRef)));
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity(o).build();
        }
        catch (JsonParseException | JsonMappingException e) {
            LOG.debug(e, "Bad request", new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error handling request", new Object[0]);
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @Override
    public final Response handlePOSTAll(InputStream inputStream, final ObjectMapper mapper) {
        Object returnObj;
        ImmutableMap inObjMap;
        try {
            Map tempMap = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
            inObjMap = ImmutableMap.copyOf((Map)Maps.transformValues((Map)tempMap, (Function)new Function<Object, ObjType>(){

                public ObjType apply(Object input) {
                    return mapper.convertValue(input, AbstractListenerHandler.this.inObjTypeRef);
                }
            }));
        }
        catch (IOException ex) {
            LOG.debug((Throwable)ex, "Bad request", new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)ex)).build();
        }
        try {
            returnObj = this.post((Map<String, ObjType>)inObjMap);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error handling request", new Object[0]);
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
        if (returnObj == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity(returnObj).build();
    }

    @Override
    public final Response handleGET(String id) {
        try {
            Object returnObj = this.get(id);
            if (returnObj == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)returnObj).build();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error handling get request for [%s]", new Object[]{id});
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @Override
    public final Response handleGETAll() {
        try {
            Map<String, ObjType> all = this.getAll();
            if (all == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok(all).build();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error getting all", new Object[0]);
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @Override
    public final Response handleDELETE(String id) {
        try {
            Object returnObj = this.delete(id);
            if (returnObj == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity(returnObj).build();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error in processing delete request for [%s]", new Object[]{id});
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @Override
    public final void use_AbstractListenerHandler_instead() {
    }

    @Nullable
    protected abstract Object delete(String var1);

    @Nullable
    protected abstract Object get(String var1);

    @Nullable
    protected abstract Map<String, ObjType> getAll();

    @Nullable
    public abstract Object post(Map<String, ObjType> var1) throws Exception;
}

