/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization.jetty;

import com.google.common.base.Joiner;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.metamx.common.ISE;
import io.druid.server.initialization.jetty.JettyRequestLog;
import io.druid.server.initialization.jetty.ServletFilterHolder;
import java.util.Set;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlets.AsyncGzipFilter;
import org.eclipse.jetty.servlets.GzipFilter;

public class JettyServerInitUtils {
    public static final String GZIP_METHODS = Joiner.on((String)",").join((Object)"GET", (Object)"POST", new Object[0]);

    public static FilterHolder defaultGzipFilterHolder() {
        FilterHolder gzipFilterHolder = new FilterHolder(GzipFilter.class);
        JettyServerInitUtils.setDefaultGzipFilterHolderParameters(gzipFilterHolder);
        return gzipFilterHolder;
    }

    public static FilterHolder defaultAsyncGzipFilterHolder() {
        FilterHolder gzipFilterHolder = new FilterHolder(AsyncGzipFilter.class);
        JettyServerInitUtils.setDefaultGzipFilterHolderParameters(gzipFilterHolder);
        return gzipFilterHolder;
    }

    private static void setDefaultGzipFilterHolderParameters(FilterHolder filterHolder) {
        filterHolder.setInitParameter("minGzipSize", "0");
        filterHolder.setInitParameter("methods", GZIP_METHODS);
        filterHolder.setInitParameter("checkGzExists", String.valueOf(false));
    }

    public static void addExtensionFilters(ServletContextHandler handler, Injector injector) {
        Set extensionFilters = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServletFilterHolder>>(){}));
        for (ServletFilterHolder servletFilterHolder : extensionFilters) {
            FilterHolder holder = null;
            if (servletFilterHolder.getFilter() != null) {
                holder = new FilterHolder(servletFilterHolder.getFilter());
            } else if (servletFilterHolder.getFilterClass() != null) {
                holder = new FilterHolder(servletFilterHolder.getFilterClass());
            } else {
                throw new ISE("Filter[%s] for path[%s] didn't have a Filter!?", new Object[]{servletFilterHolder, servletFilterHolder.getPath()});
            }
            if (servletFilterHolder.getInitParameters() != null) {
                holder.setInitParameters(servletFilterHolder.getInitParameters());
            }
            handler.addFilter(holder, servletFilterHolder.getPath(), servletFilterHolder.getDispatcherType());
        }
    }

    public static Handler getJettyRequestLogHandler() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)new JettyRequestLog());
        return requestLogHandler;
    }
}

