/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import io.druid.server.http.security.AbstractResourceFilter;
import io.druid.server.security.Access;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizationInfo;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;

public class DatasourceResourceFilter
extends AbstractResourceFilter {
    @Inject
    public DatasourceResourceFilter(AuthConfig authConfig) {
        super(authConfig);
    }

    public ContainerRequest filter(ContainerRequest request) {
        if (this.getAuthConfig().isEnabled()) {
            String dataSourceName = ((PathSegment)request.getPathSegments().get(Iterables.indexOf((Iterable)request.getPathSegments(), (Predicate)new Predicate<PathSegment>(){

                public boolean apply(PathSegment input) {
                    return input.getPath().equals("datasources");
                }
            }) + 1)).getPath();
            Preconditions.checkNotNull((Object)dataSourceName);
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)this.getReq().getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull((Object)authorizationInfo, (Object)"Security is enabled but no authorization info found in the request");
            Access authResult = authorizationInfo.isAuthorized(new Resource(dataSourceName, ResourceType.DATASOURCE), this.getAction(request));
            if (!authResult.isAllowed()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("Access-Check-Result: %s", authResult.toString())).build());
            }
        }
        return request;
    }

    @Override
    public boolean isApplicable(String requestPath) {
        ImmutableList applicablePaths = ImmutableList.of((Object)"druid/coordinator/v1/datasources/", (Object)"druid/coordinator/v1/metadata/datasources/", (Object)"druid/v2/datasources/");
        for (String path : applicablePaths) {
            if (!requestPath.startsWith(path) || requestPath.equals(path)) continue;
            return true;
        }
        return false;
    }
}

