/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.http.RedirectInfo;
import java.net.URL;

public class CoordinatorRedirectInfo
implements RedirectInfo {
    private final DruidCoordinator coordinator;

    @Inject
    public CoordinatorRedirectInfo(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public boolean doLocal() {
        return this.coordinator.isLeader();
    }

    @Override
    public URL getRedirectURL(String queryString, String requestURI) {
        try {
            String leader = this.coordinator.getCurrentLeader();
            if (leader == null) {
                return null;
            }
            String location = String.format("http://%s%s", leader, requestURI);
            if (queryString != null) {
                location = String.format("%s?%s", location, queryString);
            }
            return new URL(location);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

