/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.collect.Maps;
import io.druid.collections.CountingMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CoordinatorStats {
    private final Map<String, CountingMap<String>> perTierStats = Maps.newHashMap();
    private final CountingMap<String> globalStats = new CountingMap();

    public Map<String, CountingMap<String>> getPerTierStats() {
        return this.perTierStats;
    }

    public CountingMap<String> getGlobalStats() {
        return this.globalStats;
    }

    public void addToTieredStat(String statName, String tier, long value) {
        CountingMap theStat = this.perTierStats.get(statName);
        if (theStat == null) {
            theStat = new CountingMap();
            this.perTierStats.put(statName, (CountingMap<String>)theStat);
        }
        theStat.add((Object)tier, value);
    }

    public void addToGlobalStat(String statName, long value) {
        this.globalStats.add((Object)statName, value);
    }

    public CoordinatorStats accumulate(CoordinatorStats stats) {
        for (Map.Entry<String, CountingMap<String>> entry : stats.perTierStats.entrySet()) {
            CountingMap theStat = this.perTierStats.get(entry.getKey());
            if (theStat == null) {
                theStat = new CountingMap();
                this.perTierStats.put(entry.getKey(), (CountingMap<String>)theStat);
            }
            for (Map.Entry tiers : entry.getValue().entrySet()) {
                theStat.add(tiers.getKey(), ((AtomicLong)tiers.getValue()).get());
            }
        }
        for (Map.Entry<String, Object> entry : stats.globalStats.entrySet()) {
            this.globalStats.add((Object)entry.getKey(), ((AtomicLong)entry.getValue()).get());
        }
        return this;
    }
}

