/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.druid.server.coordination.DataSegmentChangeCallback;
import io.druid.server.coordination.DataSegmentChangeHandler;
import io.druid.server.coordination.DataSegmentChangeRequest;
import io.druid.timeline.DataSegment;

public class SegmentChangeRequestLoad
implements DataSegmentChangeRequest {
    private final DataSegment segment;

    @JsonCreator
    public SegmentChangeRequestLoad(@JsonUnwrapped DataSegment segment) {
        this.segment = segment;
    }

    @Override
    public void go(DataSegmentChangeHandler handler, DataSegmentChangeCallback callback) {
        handler.addSegment(this.segment, callback);
    }

    @JsonProperty
    @JsonUnwrapped
    public DataSegment getSegment() {
        return this.segment;
    }

    @Override
    public String asString() {
        return String.format("LOAD: %s", this.segment.getIdentifier());
    }

    public String toString() {
        return "SegmentChangeRequestLoad{segment=" + this.segment + '}';
    }
}

