/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.query.DruidMetrics;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.server.QueryManager;
import io.druid.server.QueryStats;
import io.druid.server.RequestLogLine;
import io.druid.server.initialization.ServerConfig;
import io.druid.server.log.RequestLogger;
import io.druid.server.security.Access;
import io.druid.server.security.Action;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizationInfo;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.joda.time.DateTime;

@Path(value="/druid/v2/")
public class QueryResource {
    protected static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    @Deprecated
    protected static final String APPLICATION_SMILE = "application/smile";
    protected static final int RESPONSE_CTX_HEADER_LEN_LIMIT = 7168;
    protected final QueryToolChestWarehouse warehouse;
    protected final ServerConfig config;
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final QuerySegmentWalker texasRanger;
    protected final ServiceEmitter emitter;
    protected final RequestLogger requestLogger;
    protected final QueryManager queryManager;
    protected final AuthConfig authConfig;

    @Inject
    public QueryResource(QueryToolChestWarehouse warehouse, ServerConfig config, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QuerySegmentWalker texasRanger, ServiceEmitter emitter, RequestLogger requestLogger, QueryManager queryManager, AuthConfig authConfig) {
        this.warehouse = warehouse;
        this.config = config;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.texasRanger = texasRanger;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.queryManager = queryManager;
        this.authConfig = authConfig;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getServer(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        if (log.isDebugEnabled()) {
            log.debug("Received cancel request for query [%s]", new Object[]{queryId});
        }
        if (this.authConfig.isEnabled()) {
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull((Object)authorizationInfo, (Object)"Security is enabled but no authorization info found in the request");
            Set<String> datasources = this.queryManager.getQueryDatasources(queryId);
            if (datasources == null) {
                log.warn("QueryId [%s] not registered with QueryManager, cannot cancel", new Object[]{queryId});
            } else {
                for (String dataSource : datasources) {
                    Access authResult = authorizationInfo.isAuthorized(new Resource(dataSource, ResourceType.DATASOURCE), Action.WRITE);
                    if (authResult.isAllowed()) continue;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).header("Access-Check-Result", (Object)authResult).build();
                }
            }
        }
        this.queryManager.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    public Response doPost(InputStream in, @QueryParam(value="pretty") String pretty, final @Context HttpServletRequest req) throws IOException {
        final long start = System.currentTimeMillis();
        Query query = null;
        QueryToolChest toolChest = null;
        String queryId = null;
        ResponseContext context = this.createContext(req.getContentType(), pretty != null);
        String currThreadName = Thread.currentThread().getName();
        try {
            ConcurrentMap responseContext;
            Sequence res;
            query = (Query)context.getObjectMapper().readValue(in, Query.class);
            queryId = query.getId();
            if (queryId == null) {
                queryId = UUID.randomUUID().toString();
                query = query.withId(queryId);
            }
            if (query.getContextValue("timeout") == null) {
                query = query.withOverriddenContext((Map)ImmutableMap.of((Object)"timeout", (Object)this.config.getMaxIdleTime().toStandardDuration().getMillis()));
            }
            toolChest = this.warehouse.getToolChest(query);
            Thread.currentThread().setName(String.format("%s[%s_%s_%s]", currThreadName, query.getType(), query.getDataSource(), queryId));
            if (log.isDebugEnabled()) {
                log.debug("Got query [%s]", new Object[]{query});
            }
            if (this.authConfig.isEnabled()) {
                AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
                if (authorizationInfo != null) {
                    for (String dataSource : query.getDataSource().getNames()) {
                        Access authResult = authorizationInfo.isAuthorized(new Resource(dataSource, ResourceType.DATASOURCE), Action.READ);
                        if (authResult.isAllowed()) continue;
                        Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).header("Access-Check-Result", (Object)authResult).build();
                        return response;
                    }
                } else {
                    throw new ISE("WTF?! Security is enabled but no authorization info found in the request", new Object[0]);
                }
            }
            Sequence results = (res = query.run(this.texasRanger, (Map)(responseContext = new MapMaker().makeMap()))) == null ? Sequences.empty() : res;
            final Yielder yielder = results.toYielder(null, new YieldingAccumulator(){

                public Object accumulate(Object accumulated, Object in) {
                    this.yield();
                    return in;
                }
            });
            try {
                final Query theQuery = query;
                final QueryToolChest theToolChest = toolChest;
                final ObjectWriter jsonWriter = context.newOutputWriter();
                Response.ResponseBuilder builder = Response.ok((Object)new StreamingOutput(){

                    public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                        CountingOutputStream os = new CountingOutputStream(outputStream);
                        jsonWriter.writeValue((OutputStream)os, (Object)yielder);
                        os.flush();
                        os.close();
                        long queryTime = System.currentTimeMillis() - start;
                        QueryResource.this.emitter.emit(DruidMetrics.makeQueryTimeMetric((QueryToolChest)theToolChest, (ObjectMapper)QueryResource.this.jsonMapper, (Query)theQuery, (String)req.getRemoteAddr()).setDimension("success", "true").build("query/time", (Number)queryTime));
                        QueryResource.this.emitter.emit(DruidMetrics.makeQueryTimeMetric((QueryToolChest)theToolChest, (ObjectMapper)QueryResource.this.jsonMapper, (Query)theQuery, (String)req.getRemoteAddr()).build("query/bytes", (Number)os.getCount()));
                        QueryResource.this.requestLogger.log(new RequestLogLine(new DateTime(start), req.getRemoteAddr(), theQuery, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"query/time", (Object)queryTime, (Object)"query/bytes", (Object)os.getCount(), (Object)"success", (Object)true))));
                    }
                }, (String)context.getContentType()).header("X-Druid-Query-Id", (Object)queryId);
                String responseCtxString = this.jsonMapper.writeValueAsString((Object)responseContext);
                if (responseCtxString.length() > 7168) {
                    log.warn("Response Context truncated for id [%s] . Full context is [%s].", new Object[]{queryId, responseCtxString});
                    responseCtxString = responseCtxString.substring(0, 7168);
                }
                Response response = builder.header("X-Druid-Response-Context", (Object)responseCtxString).build();
                return response;
            }
            catch (Exception e) {
                try {
                    yielder.close();
                    throw Throwables.propagate((Throwable)e);
                }
                catch (QueryInterruptedException e2) {
                    try {
                        log.info("%s [%s]", new Object[]{e2.getMessage(), queryId});
                        long queryTime = System.currentTimeMillis() - start;
                        this.emitter.emit(DruidMetrics.makeQueryTimeMetric((QueryToolChest)toolChest, (ObjectMapper)this.jsonMapper, (Query)query, (String)req.getRemoteAddr()).setDimension("success", "false").build("query/time", (Number)queryTime));
                        this.requestLogger.log(new RequestLogLine(new DateTime(start), req.getRemoteAddr(), query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"query/time", (Object)queryTime, (Object)"success", (Object)false, (Object)"interrupted", (Object)true, (Object)"reason", (Object)e2.toString()))));
                    }
                    catch (Exception e22) {
                        log.error((Throwable)e22, "Unable to log query [%s]!", new Object[]{query});
                    }
                    Response e22 = context.gotError((Exception)((Object)e2));
                    return e22;
                }
                catch (Exception e3) {
                    String queryString = query == null ? "unparsable query" : query.toString();
                    log.warn((Throwable)e3, "Exception occurred on request [%s]", new Object[]{queryString});
                    try {
                        long queryTime = System.currentTimeMillis() - start;
                        this.emitter.emit(DruidMetrics.makeQueryTimeMetric((QueryToolChest)toolChest, (ObjectMapper)this.jsonMapper, (Query)query, (String)req.getRemoteAddr()).setDimension("success", "false").build("query/time", (Number)queryTime));
                        this.requestLogger.log(new RequestLogLine(new DateTime(start), req.getRemoteAddr(), query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"query/time", (Object)queryTime, (Object)"success", (Object)false, (Object)"exception", (Object)e3.toString()))));
                    }
                    catch (Exception e2) {
                        log.error((Throwable)e2, "Unable to log query [%s]!", new Object[]{queryString});
                    }
                    log.makeAlert((Throwable)e3, "Exception handling request", new Object[0]).addData("exception", (Object)e3.toString()).addData("query", (Object)queryString).addData("peer", (Object)req.getRemoteAddr()).emit();
                    Response response = context.gotError(e3);
                    return response;
                }
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    protected ResponseContext createContext(String requestType, boolean pretty) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType) || APPLICATION_SMILE.equals(requestType);
        String contentType = isSmile ? "application/x-jackson-smile" : "application/json";
        return new ResponseContext(contentType, isSmile ? this.smileMapper : this.jsonMapper, pretty);
    }

    protected static class ResponseContext {
        private final String contentType;
        private final ObjectMapper inputMapper;
        private final boolean isPretty;

        ResponseContext(String contentType, ObjectMapper inputMapper, boolean isPretty) {
            this.contentType = contentType;
            this.inputMapper = inputMapper;
            this.isPretty = isPretty;
        }

        String getContentType() {
            return this.contentType;
        }

        public ObjectMapper getObjectMapper() {
            return this.inputMapper;
        }

        ObjectWriter newOutputWriter() {
            return this.isPretty ? this.inputMapper.writerWithDefaultPrettyPrinter() : this.inputMapper.writer();
        }

        Response ok(Object object) throws IOException {
            return Response.ok((Object)this.newOutputWriter().writeValueAsString(object), (String)this.contentType).build();
        }

        Response gotError(Exception e) throws IOException {
            return Response.serverError().type(this.contentType).entity((Object)this.newOutputWriter().writeValueAsBytes((Object)QueryInterruptedException.wrapIfNeeded((Throwable)e))).build();
        }
    }
}

