/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.metamx.common.Granularity;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.common.guava.ThreadRenamingCallable;
import io.druid.common.guava.ThreadRenamingRunnable;
import io.druid.common.utils.VMUtils;
import io.druid.concurrent.Execs;
import io.druid.concurrent.TaskThreadPriority;
import io.druid.data.input.Committer;
import io.druid.data.input.InputRow;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.SegmentDescriptor;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.Metadata;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.FireHydrant;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.appenderator.SinkQuerySegmentWalker;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.RejectionPolicy;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifier;
import io.druid.segment.realtime.plumber.Sink;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.SingleElementPartitionChunk;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class RealtimePlumber
implements Plumber {
    private static final EmittingLogger log = new EmittingLogger(RealtimePlumber.class);
    private static final int WARN_DELAY = 1000;
    private final DataSchema schema;
    private final RealtimeTuningConfig config;
    private final RejectionPolicy rejectionPolicy;
    private final FireDepartmentMetrics metrics;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentPusher dataSegmentPusher;
    private final SegmentPublisher segmentPublisher;
    private final SegmentHandoffNotifier handoffNotifier;
    private final Object handoffCondition = new Object();
    private final Map<Long, Sink> sinks = Maps.newConcurrentMap();
    private final VersionedIntervalTimeline<String, Sink> sinkTimeline = new VersionedIntervalTimeline(String.CASE_INSENSITIVE_ORDER);
    private final QuerySegmentWalker texasRanger;
    private final Cache cache;
    private volatile long nextFlush = 0L;
    private volatile boolean shuttingDown = false;
    private volatile boolean stopped = false;
    private volatile boolean cleanShutdown = true;
    private volatile ExecutorService persistExecutor = null;
    private volatile ExecutorService mergeExecutor = null;
    private volatile ScheduledExecutorService scheduledExecutor = null;
    private volatile IndexMerger indexMerger;
    private volatile IndexIO indexIO;
    private static final String COMMIT_METADATA_KEY = "%commitMetadata%";
    private static final String COMMIT_METADATA_TIMESTAMP_KEY = "%commitMetadataTimestamp%";

    public RealtimePlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics, ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ExecutorService queryExecutorService, DataSegmentPusher dataSegmentPusher, SegmentPublisher segmentPublisher, SegmentHandoffNotifier handoffNotifier, IndexMerger indexMerger, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, ObjectMapper objectMapper) {
        this.schema = schema;
        this.config = config;
        this.rejectionPolicy = config.getRejectionPolicyFactory().create(config.getWindowPeriod());
        this.metrics = metrics;
        this.segmentAnnouncer = segmentAnnouncer;
        this.dataSegmentPusher = dataSegmentPusher;
        this.segmentPublisher = segmentPublisher;
        this.handoffNotifier = handoffNotifier;
        this.indexMerger = (IndexMerger)Preconditions.checkNotNull((Object)indexMerger, (Object)"Null IndexMerger");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.texasRanger = new SinkQuerySegmentWalker(schema.getDataSource(), this.sinkTimeline, objectMapper, emitter, conglomerate, queryExecutorService, cache, cacheConfig);
        log.info("Creating plumber using rejectionPolicy[%s]", new Object[]{this.getRejectionPolicy()});
    }

    public DataSchema getSchema() {
        return this.schema;
    }

    public RealtimeTuningConfig getConfig() {
        return this.config;
    }

    public RejectionPolicy getRejectionPolicy() {
        return this.rejectionPolicy;
    }

    public Map<Long, Sink> getSinks() {
        return this.sinks;
    }

    @Override
    public Object startJob() {
        this.computeBaseDir(this.schema).mkdirs();
        this.initializeExecutors();
        this.handoffNotifier.start();
        Object retVal = this.bootstrapSinksFromDisk();
        this.startPersistThread();
        this.mergeAndPush();
        this.resetNextFlush();
        return retVal;
    }

    @Override
    public int add(InputRow row, Supplier<Committer> committerSupplier) throws IndexSizeExceededException {
        Sink sink = this.getSink(row.getTimestampFromEpoch());
        if (sink == null) {
            return -1;
        }
        int numRows = sink.add(row);
        if (!sink.canAppendRow() || System.currentTimeMillis() > this.nextFlush) {
            this.persist((Committer)committerSupplier.get());
        }
        return numRows;
    }

    private Sink getSink(long timestamp) {
        if (!this.rejectionPolicy.accept(timestamp)) {
            return null;
        }
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        VersioningPolicy versioningPolicy = this.config.getVersioningPolicy();
        long truncatedTime = segmentGranularity.truncate(new DateTime(timestamp)).getMillis();
        Sink retVal = this.sinks.get(truncatedTime);
        if (retVal == null) {
            Interval sinkInterval = new Interval((ReadableInstant)new DateTime(truncatedTime), (ReadableInstant)segmentGranularity.increment(new DateTime(truncatedTime)));
            retVal = new Sink(sinkInterval, this.schema, this.config.getShardSpec(), versioningPolicy.getVersion(sinkInterval), this.config.getMaxRowsInMemory(), this.config.isReportParseExceptions());
            this.addSink(retVal);
        }
        return retVal;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        return this.texasRanger.getQueryRunnerForIntervals(query, (Iterable)query.getIntervals());
    }

    @Override
    public void persist(Committer committer) {
        final ArrayList indexesToPersist = Lists.newArrayList();
        for (Sink sink : this.sinks.values()) {
            if (!sink.swappable()) continue;
            indexesToPersist.add(Pair.of((Object)sink.swap(), (Object)sink.getInterval()));
        }
        log.info("Submitting persist runnable for dataSource[%s]", new Object[]{this.schema.getDataSource()});
        Stopwatch runExecStopwatch = Stopwatch.createStarted();
        Stopwatch persistStopwatch = Stopwatch.createStarted();
        ImmutableMap metadataElems = committer.getMetadata() == null ? null : ImmutableMap.of((Object)COMMIT_METADATA_KEY, (Object)committer.getMetadata(), (Object)COMMIT_METADATA_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
        this.persistExecutor.execute((Runnable)new ThreadRenamingRunnable(String.format("%s-incremental-persist", this.schema.getDataSource()), (Map)metadataElems, committer, persistStopwatch){
            final /* synthetic */ Map val$metadataElems;
            final /* synthetic */ Committer val$committer;
            final /* synthetic */ Stopwatch val$persistStopwatch;
            {
                this.val$metadataElems = map;
                this.val$committer = committer;
                this.val$persistStopwatch = stopwatch;
                super(x0);
            }

            public void doRun() {
                long persistThreadCpuTime = VMUtils.safeGetThreadCpuTime();
                try {
                    for (Pair pair : indexesToPersist) {
                        RealtimePlumber.this.metrics.incrementRowOutputCount(RealtimePlumber.this.persistHydrant((FireHydrant)pair.lhs, RealtimePlumber.this.schema, (Interval)pair.rhs, this.val$metadataElems));
                    }
                    this.val$committer.run();
                }
                catch (Exception e) {
                    RealtimePlumber.this.metrics.incrementFailedPersists();
                    throw e;
                }
                finally {
                    RealtimePlumber.this.metrics.incrementPersistCpuTime(VMUtils.safeGetThreadCpuTime() - persistThreadCpuTime);
                    RealtimePlumber.this.metrics.incrementNumPersists();
                    RealtimePlumber.this.metrics.incrementPersistTimeMillis(this.val$persistStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    this.val$persistStopwatch.stop();
                }
            }
        });
        long startDelay = runExecStopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.metrics.incrementPersistBackPressureMillis(startDelay);
        if (startDelay > 1000L) {
            log.warn("Ingestion was throttled for [%,d] millis because persists were pending.", new Object[]{startDelay});
        }
        runExecStopwatch.stop();
        this.resetNextFlush();
    }

    private void persistAndMerge(final long truncatedTime, final Sink sink) {
        String threadName = String.format("%s-%s-persist-n-merge", this.schema.getDataSource(), new DateTime(truncatedTime));
        this.mergeExecutor.execute((Runnable)new ThreadRenamingRunnable(threadName){
            final Interval interval;
            Stopwatch mergeStopwatch;
            {
                super(x0);
                this.interval = sink.getInterval();
                this.mergeStopwatch = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doRun() {
                try {
                    Segment segment;
                    if (RealtimePlumber.this.sinks.get(truncatedTime) != sink) {
                        log.info("Sink[%s] was abandoned, bailing out of persist-n-merge.", new Object[]{sink});
                        return;
                    }
                    File persistDir = RealtimePlumber.this.computePersistDir(RealtimePlumber.this.schema, this.interval);
                    File mergedTarget = new File(persistDir, "merged");
                    File isPushedMarker = new File(persistDir, "isPushedMarker");
                    if (!isPushedMarker.exists()) {
                        RealtimePlumber.this.removeSegment(sink, mergedTarget);
                        if (mergedTarget.exists()) {
                            log.wtf("Merged target[%s] exists?!", new Object[]{mergedTarget});
                            return;
                        }
                    } else {
                        log.info("Already pushed sink[%s]", new Object[]{sink});
                        return;
                    }
                    Iterator<FireHydrant> iterator = sink.iterator();
                    while (iterator.hasNext()) {
                        FireHydrant hydrant;
                        FireHydrant fireHydrant = hydrant = iterator.next();
                        synchronized (fireHydrant) {
                            if (!hydrant.hasSwapped()) {
                                log.info("Hydrant[%s] hasn't swapped yet, swapping. Sink[%s]", new Object[]{hydrant, sink});
                                int rowCount = RealtimePlumber.this.persistHydrant(hydrant, RealtimePlumber.this.schema, this.interval, null);
                                RealtimePlumber.this.metrics.incrementRowOutputCount(rowCount);
                            }
                        }
                    }
                    long mergeThreadCpuTime = VMUtils.safeGetThreadCpuTime();
                    this.mergeStopwatch = Stopwatch.createStarted();
                    ArrayList indexes = Lists.newArrayList();
                    for (FireHydrant fireHydrant : sink) {
                        segment = fireHydrant.getSegment();
                        QueryableIndex queryableIndex = segment.asQueryableIndex();
                        log.info("Adding hydrant[%s]", new Object[]{fireHydrant});
                        indexes.add(queryableIndex);
                    }
                    File mergedFile = RealtimePlumber.this.indexMerger.mergeQueryableIndex((List)indexes, RealtimePlumber.this.schema.getGranularitySpec().isRollup(), RealtimePlumber.this.schema.getAggregators(), mergedTarget, RealtimePlumber.this.config.getIndexSpec());
                    RealtimePlumber.this.metrics.incrementMergeCpuTime(VMUtils.safeGetThreadCpuTime() - mergeThreadCpuTime);
                    RealtimePlumber.this.metrics.incrementMergeTimeMillis(this.mergeStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    QueryableIndex index = RealtimePlumber.this.indexIO.loadIndex(mergedFile);
                    log.info("Pushing [%s] to deep storage", new Object[]{sink.getSegment().getIdentifier()});
                    segment = RealtimePlumber.this.dataSegmentPusher.push(mergedFile, sink.getSegment().withDimensions((List)Lists.newArrayList((Iterable)index.getAvailableDimensions())));
                    log.info("Inserting [%s] to the metadata store", new Object[]{sink.getSegment().getIdentifier()});
                    RealtimePlumber.this.segmentPublisher.publishSegment((DataSegment)segment);
                    if (!isPushedMarker.createNewFile()) {
                        log.makeAlert("Failed to create marker file for [%s]", new Object[]{RealtimePlumber.this.schema.getDataSource()}).addData("interval", (Object)sink.getInterval()).addData("partitionNum", (Object)segment.getShardSpec().getPartitionNum()).addData("marker", (Object)isPushedMarker).emit();
                    }
                }
                catch (Exception e) {
                    RealtimePlumber.this.metrics.incrementFailedHandoffs();
                    log.makeAlert((Throwable)e, "Failed to persist merged index[%s]", new Object[]{RealtimePlumber.this.schema.getDataSource()}).addData("interval", (Object)this.interval).emit();
                    if (RealtimePlumber.this.shuttingDown) {
                        RealtimePlumber.this.cleanShutdown = false;
                        RealtimePlumber.this.abandonSegment(truncatedTime, sink);
                    }
                }
                finally {
                    if (this.mergeStopwatch != null) {
                        this.mergeStopwatch.stop();
                    }
                }
            }
        });
        this.handoffNotifier.registerSegmentHandoffCallback(new SegmentDescriptor(sink.getInterval(), sink.getVersion(), this.config.getShardSpec().getPartitionNum()), this.mergeExecutor, new Runnable(){

            @Override
            public void run() {
                RealtimePlumber.this.abandonSegment(sink.getInterval().getStartMillis(), sink);
                RealtimePlumber.this.metrics.incrementHandOffCount();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJob() {
        log.info("Shutting down...", new Object[0]);
        this.shuttingDown = true;
        for (Map.Entry<Long, Sink> entry : this.sinks.entrySet()) {
            this.persistAndMerge(entry.getKey(), entry.getValue());
        }
        long forceEndWaitTime = System.currentTimeMillis() + this.config.getHandoffConditionTimeout();
        while (!this.sinks.isEmpty()) {
            try {
                log.info("Cannot shut down yet! Sinks remaining: %s", new Object[]{Joiner.on((String)", ").join(Iterables.transform(this.sinks.values(), (Function)new Function<Sink, String>(){

                    public String apply(Sink input) {
                        return input.getSegment().getIdentifier();
                    }
                }))});
                Object object = this.handoffCondition;
                synchronized (object) {
                    while (!this.sinks.isEmpty()) {
                        if (this.config.getHandoffConditionTimeout() == 0L) {
                            this.handoffCondition.wait();
                            continue;
                        }
                        long curr = System.currentTimeMillis();
                        if (forceEndWaitTime - curr > 0L) {
                            this.handoffCondition.wait(forceEndWaitTime - curr);
                            continue;
                        }
                        throw new ISE("Segment handoff wait timeout. [%s] segments might not have completed handoff.", new Object[]{this.sinks.size()});
                    }
                }
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.handoffNotifier.close();
        this.shutdownExecutors();
        this.stopped = true;
        if (!this.cleanShutdown) {
            throw new ISE("Exception occurred during persist and merge.", new Object[0]);
        }
    }

    private void resetNextFlush() {
        this.nextFlush = new DateTime().plus((ReadablePeriod)this.config.getIntermediatePersistPeriod()).getMillis();
    }

    protected void initializeExecutors() {
        int maxPendingPersists = this.config.getMaxPendingPersists();
        if (this.persistExecutor == null) {
            this.persistExecutor = Execs.newBlockingSingleThreaded((String)"plumber_persist_%d", (int)maxPendingPersists, (Integer)TaskThreadPriority.getThreadPriorityFromTaskPriority((int)this.config.getPersistThreadPriority()));
        }
        if (this.mergeExecutor == null) {
            this.mergeExecutor = Execs.newBlockingSingleThreaded((String)"plumber_merge_%d", (int)1, (Integer)TaskThreadPriority.getThreadPriorityFromTaskPriority((int)this.config.getMergeThreadPriority()));
        }
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Execs.scheduledSingleThreaded((String)"plumber_scheduled_%d");
        }
    }

    protected void shutdownExecutors() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            this.persistExecutor.shutdown();
            this.mergeExecutor.shutdown();
        }
    }

    protected Object bootstrapSinksFromDisk() {
        VersioningPolicy versioningPolicy = this.config.getVersioningPolicy();
        File baseDir = this.computeBaseDir(this.schema);
        if (baseDir == null || !baseDir.exists()) {
            return null;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            return null;
        }
        Object metadata = null;
        long latestCommitTime = 0L;
        for (File sinkDir : files) {
            Interval sinkInterval = new Interval((Object)sinkDir.getName().replace("_", "/"));
            File[] sinkFiles = sinkDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return Ints.tryParse((String)fileName) != null;
                }
            });
            Arrays.sort(sinkFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    try {
                        return Ints.compare((int)Integer.parseInt(o1.getName()), (int)Integer.parseInt(o2.getName()));
                    }
                    catch (NumberFormatException e) {
                        log.error((Throwable)e, "Couldn't compare as numbers? [%s][%s]", new Object[]{o1, o2});
                        return o1.compareTo(o2);
                    }
                }
            });
            boolean isCorrupted = false;
            ArrayList hydrants = Lists.newArrayList();
            for (File segmentDir : sinkFiles) {
                long timestamp;
                Object timestampObj;
                log.info("Loading previously persisted segment at [%s]", new Object[]{segmentDir});
                if (Ints.tryParse((String)segmentDir.getName()) == null) continue;
                QueryableIndex queryableIndex = null;
                try {
                    queryableIndex = this.indexIO.loadIndex(segmentDir);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Problem loading segmentDir from disk.", new Object[0]);
                    isCorrupted = true;
                }
                if (isCorrupted) {
                    try {
                        File corruptSegmentDir = this.computeCorruptedFileDumpDir(segmentDir, this.schema);
                        log.info("Renaming %s to %s", new Object[]{segmentDir.getAbsolutePath(), corruptSegmentDir.getAbsolutePath()});
                        FileUtils.copyDirectory((File)segmentDir, (File)corruptSegmentDir);
                        FileUtils.deleteDirectory((File)segmentDir);
                    }
                    catch (Exception e1) {
                        log.error((Throwable)e1, "Failed to rename %s", new Object[]{segmentDir.getAbsolutePath()});
                    }
                    continue;
                }
                Metadata segmentMetadata = queryableIndex.getMetadata();
                if (segmentMetadata != null && (timestampObj = segmentMetadata.get(COMMIT_METADATA_TIMESTAMP_KEY)) != null && (timestamp = ((Long)timestampObj).longValue()) > latestCommitTime) {
                    log.info("Found metaData [%s] with latestCommitTime [%s] greater than previous recorded [%s]", new Object[]{queryableIndex.getMetadata(), timestamp, latestCommitTime});
                    latestCommitTime = timestamp;
                    metadata = queryableIndex.getMetadata().get(COMMIT_METADATA_KEY);
                }
                hydrants.add(new FireHydrant((Segment)new QueryableIndexSegment(DataSegment.makeDataSegmentIdentifier((String)this.schema.getDataSource(), (DateTime)sinkInterval.getStart(), (DateTime)sinkInterval.getEnd(), (String)versioningPolicy.getVersion(sinkInterval), (ShardSpec)this.config.getShardSpec()), queryableIndex), Integer.parseInt(segmentDir.getName())));
            }
            if (hydrants.isEmpty()) {
                log.warn("Found persisted segment directory with no intermediate segments present at %s, skipping sink creation.", new Object[]{sinkDir.getAbsolutePath()});
                continue;
            }
            Sink currSink = new Sink(sinkInterval, this.schema, this.config.getShardSpec(), versioningPolicy.getVersion(sinkInterval), this.config.getMaxRowsInMemory(), this.config.isReportParseExceptions(), hydrants);
            this.addSink(currSink);
        }
        return metadata;
    }

    private void addSink(Sink sink) {
        this.sinks.put(sink.getInterval().getStartMillis(), sink);
        this.sinkTimeline.add(sink.getInterval(), (Object)sink.getVersion(), (PartitionChunk)new SingleElementPartitionChunk((Object)sink));
        try {
            this.segmentAnnouncer.announceSegment(sink.getSegment());
        }
        catch (IOException e) {
            log.makeAlert((Throwable)e, "Failed to announce new segment[%s]", new Object[]{this.schema.getDataSource()}).addData("interval", (Object)sink.getInterval()).emit();
        }
    }

    protected void startPersistThread() {
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        Period windowPeriod = this.config.getWindowPeriod();
        DateTime truncatedNow = segmentGranularity.truncate(new DateTime());
        long windowMillis = windowPeriod.toStandardDuration().getMillis();
        log.info("Expect to run at [%s]", new Object[]{new DateTime().plus((ReadableDuration)new Duration(System.currentTimeMillis(), segmentGranularity.increment(truncatedNow).getMillis() + windowMillis))});
        ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.scheduledExecutor, (Duration)new Duration(System.currentTimeMillis(), segmentGranularity.increment(truncatedNow).getMillis() + windowMillis), (Duration)new Duration((ReadableInstant)truncatedNow, (ReadableInstant)segmentGranularity.increment(truncatedNow)), (Callable)new ThreadRenamingCallable<ScheduledExecutors.Signal>(String.format("%s-overseer-%d", this.schema.getDataSource(), this.config.getShardSpec().getPartitionNum())){

            public ScheduledExecutors.Signal doCall() {
                if (RealtimePlumber.this.stopped) {
                    log.info("Stopping merge-n-push overseer thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                RealtimePlumber.this.mergeAndPush();
                if (RealtimePlumber.this.stopped) {
                    log.info("Stopping merge-n-push overseer thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                return ScheduledExecutors.Signal.REPEAT;
            }
        });
    }

    private void mergeAndPush() {
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        Period windowPeriod = this.config.getWindowPeriod();
        long windowMillis = windowPeriod.toStandardDuration().getMillis();
        log.info("Starting merge and push.", new Object[0]);
        DateTime minTimestampAsDate = segmentGranularity.truncate(new DateTime(Math.max(windowMillis, this.rejectionPolicy.getCurrMaxTime().getMillis()) - windowMillis));
        long minTimestamp = minTimestampAsDate.getMillis();
        log.info("Found [%,d] segments. Attempting to hand off segments that start before [%s].", new Object[]{this.sinks.size(), minTimestampAsDate});
        ArrayList sinksToPush = Lists.newArrayList();
        for (Map.Entry<Long, Sink> entry : this.sinks.entrySet()) {
            Long intervalStart = entry.getKey();
            if (intervalStart < minTimestamp) {
                log.info("Adding entry [%s] for merge and push.", new Object[]{entry});
                sinksToPush.add(entry);
                continue;
            }
            log.info("Skipping persist and merge for entry [%s] : Start time [%s] >= [%s] min timestamp required in this run. Segment will be picked up in a future run.", new Object[]{entry, new DateTime((Object)intervalStart), minTimestampAsDate});
        }
        log.info("Found [%,d] sinks to persist and merge", new Object[]{sinksToPush.size()});
        for (Map.Entry<Long, Sink> entry : sinksToPush) {
            this.persistAndMerge(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandonSegment(long truncatedTime, Sink sink) {
        if (this.sinks.containsKey(truncatedTime)) {
            try {
                this.segmentAnnouncer.unannounceSegment(sink.getSegment());
                this.removeSegment(sink, this.computePersistDir(this.schema, sink.getInterval()));
                log.info("Removing sinkKey %d for segment %s", new Object[]{truncatedTime, sink.getSegment().getIdentifier()});
                this.sinks.remove(truncatedTime);
                this.sinkTimeline.remove(sink.getInterval(), (Object)sink.getVersion(), (PartitionChunk)new SingleElementPartitionChunk((Object)sink));
                for (FireHydrant hydrant : sink) {
                    this.cache.close(SinkQuerySegmentWalker.makeHydrantCacheIdentifier(hydrant));
                }
                Object object = this.handoffCondition;
                synchronized (object) {
                    this.handoffCondition.notifyAll();
                }
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to abandon old segment for dataSource[%s]", new Object[]{this.schema.getDataSource()}).addData("interval", (Object)sink.getInterval()).emit();
            }
        }
    }

    protected File computeBaseDir(DataSchema schema) {
        return new File(this.config.getBasePersistDirectory(), schema.getDataSource());
    }

    protected File computeCorruptedFileDumpDir(File persistDir, DataSchema schema) {
        return new File(persistDir.getAbsolutePath().replace(schema.getDataSource(), "corrupted" + File.pathSeparator + schema.getDataSource()));
    }

    protected File computePersistDir(DataSchema schema, Interval interval) {
        return new File(this.computeBaseDir(schema), interval.toString().replace("/", "_"));
    }

    protected int persistHydrant(FireHydrant indexToPersist, DataSchema schema, Interval interval, Map<String, Object> metadataElems) {
        FireHydrant fireHydrant = indexToPersist;
        synchronized (fireHydrant) {
            if (indexToPersist.hasSwapped()) {
                log.info("DataSource[%s], Interval[%s], Hydrant[%s] already swapped. Ignoring request to persist.", new Object[]{schema.getDataSource(), interval, indexToPersist});
                return 0;
            }
            log.info("DataSource[%s], Interval[%s], Metadata [%s] persisting Hydrant[%s]", new Object[]{schema.getDataSource(), interval, metadataElems, indexToPersist});
            try {
                int numRows = indexToPersist.getIndex().size();
                IndexSpec indexSpec = this.config.getIndexSpec();
                indexToPersist.getIndex().getMetadata().putAll(metadataElems);
                File persistedFile = this.indexMerger.persist(indexToPersist.getIndex(), interval, new File(this.computePersistDir(schema, interval), String.valueOf(indexToPersist.getCount())), indexSpec);
                indexToPersist.swapSegment((Segment)new QueryableIndexSegment(indexToPersist.getSegment().getIdentifier(), this.indexIO.loadIndex(persistedFile)));
                return numRows;
            }
            catch (IOException e) {
                log.makeAlert("dataSource[%s] -- incremental persist failed", new Object[]{schema.getDataSource()}).addData("interval", (Object)interval).addData("count", (Object)indexToPersist.getCount()).emit();
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private void removeSegment(Sink sink, File target) {
        if (target.exists()) {
            try {
                log.info("Deleting Index File[%s]", new Object[]{target});
                FileUtils.deleteDirectory((File)target);
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to remove file for dataSource[%s]", new Object[]{this.schema.getDataSource()}).addData("file", (Object)target).addData("interval", (Object)sink.getInterval()).emit();
            }
        }
    }
}

