/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.metamx.common.Pair;
import com.metamx.common.logger.Logger;
import io.druid.client.ImmutableSegmentLoadInfo;
import io.druid.client.coordinator.CoordinatorClient;
import io.druid.concurrent.Execs;
import io.druid.query.SegmentDescriptor;
import io.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierConfig;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifier;
import io.druid.server.coordination.DruidServerMetadata;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.joda.time.ReadableInterval;

public class CoordinatorBasedSegmentHandoffNotifier
implements SegmentHandoffNotifier {
    private static final Logger log = new Logger(CoordinatorBasedSegmentHandoffNotifier.class);
    private final ConcurrentMap<SegmentDescriptor, Pair<Executor, Runnable>> handOffCallbacks = Maps.newConcurrentMap();
    private final CoordinatorClient coordinatorClient;
    private volatile ScheduledExecutorService scheduledExecutor;
    private final long pollDurationMillis;
    private final String dataSource;

    public CoordinatorBasedSegmentHandoffNotifier(String dataSource, CoordinatorClient coordinatorClient, CoordinatorBasedSegmentHandoffNotifierConfig config) {
        this.dataSource = dataSource;
        this.coordinatorClient = coordinatorClient;
        this.pollDurationMillis = config.getPollDuration().getMillis();
    }

    @Override
    public boolean registerSegmentHandoffCallback(SegmentDescriptor descriptor, Executor exec, Runnable handOffRunnable) {
        log.info("Adding SegmentHandoffCallback for dataSource[%s] Segment[%s]", new Object[]{this.dataSource, descriptor});
        Pair<Executor, Runnable> prev = this.handOffCallbacks.putIfAbsent(descriptor, (Pair<Executor, Runnable>)new Pair((Object)exec, (Object)handOffRunnable));
        return prev == null;
    }

    @Override
    public void start() {
        this.scheduledExecutor = Execs.scheduledSingleThreaded((String)"coordinator_handoff_scheduled_%d");
        this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CoordinatorBasedSegmentHandoffNotifier.this.checkForSegmentHandoffs();
            }
        }, 0L, this.pollDurationMillis, TimeUnit.MILLISECONDS);
    }

    void checkForSegmentHandoffs() {
        try {
            Iterator itr = this.handOffCallbacks.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                SegmentDescriptor descriptor = (SegmentDescriptor)entry.getKey();
                try {
                    List<ImmutableSegmentLoadInfo> loadedSegments = this.coordinatorClient.fetchServerView(this.dataSource, descriptor.getInterval(), true);
                    if (!CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(loadedSegments, (SegmentDescriptor)entry.getKey())) continue;
                    log.info("Segment Handoff complete for dataSource[%s] Segment[%s]", new Object[]{this.dataSource, descriptor});
                    ((Executor)((Pair)entry.getValue()).lhs).execute((Runnable)((Pair)entry.getValue()).rhs);
                    itr.remove();
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Exception while checking handoff for dataSource[%s] Segment[%s], Will try again after [%d]secs", new Object[]{this.dataSource, descriptor, this.pollDurationMillis});
                }
            }
            if (!this.handOffCallbacks.isEmpty()) {
                log.info("Still waiting for Handoff for Segments : [%s]", new Object[]{this.handOffCallbacks.keySet()});
            }
        }
        catch (Throwable t) {
            log.error(t, "Exception while checking handoff for dataSource[%s] Segment[%s], Will try again after [%d]secs", new Object[]{this.dataSource, this.pollDurationMillis});
        }
    }

    static boolean isHandOffComplete(List<ImmutableSegmentLoadInfo> serverView, SegmentDescriptor descriptor) {
        for (ImmutableSegmentLoadInfo segmentLoadInfo : serverView) {
            if (!segmentLoadInfo.getSegment().getInterval().contains((ReadableInterval)descriptor.getInterval()) || segmentLoadInfo.getSegment().getShardSpec().getPartitionNum() != descriptor.getPartitionNumber() || segmentLoadInfo.getSegment().getVersion().compareTo(descriptor.getVersion()) < 0 || !Iterables.any(segmentLoadInfo.getServers(), (Predicate)new Predicate<DruidServerMetadata>(){

                public boolean apply(DruidServerMetadata input) {
                    return input.isAssignable();
                }
            })) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.scheduledExecutor.shutdown();
    }

    Map<SegmentDescriptor, Pair<Executor, Runnable>> getHandOffCallbacks() {
        return this.handOffCallbacks;
    }
}

