/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.data.input.Committer;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseV2;
import io.druid.data.input.InputRow;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.NoopQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChest;
import io.druid.query.SegmentDescriptor;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.spec.SpecificSegmentSpec;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.plumber.Committers;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.Plumbers;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.joda.time.Interval;

public class RealtimeManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(RealtimeManager.class);
    private final List<FireDepartment> fireDepartments;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final Map<String, Map<Integer, FireChief>> chiefs;

    @Inject
    public RealtimeManager(List<FireDepartment> fireDepartments, QueryRunnerFactoryConglomerate conglomerate) {
        this.fireDepartments = fireDepartments;
        this.conglomerate = conglomerate;
        this.chiefs = Maps.newHashMap();
    }

    RealtimeManager(List<FireDepartment> fireDepartments, QueryRunnerFactoryConglomerate conglomerate, Map<String, Map<Integer, FireChief>> chiefs) {
        this.fireDepartments = fireDepartments;
        this.conglomerate = conglomerate;
        this.chiefs = chiefs;
    }

    @LifecycleStart
    public void start() throws IOException {
        for (FireDepartment fireDepartment : this.fireDepartments) {
            DataSchema schema = fireDepartment.getDataSchema();
            FireChief chief = new FireChief(fireDepartment, this.conglomerate);
            Map<Integer, FireChief> partitionChiefs = this.chiefs.get(schema.getDataSource());
            if (partitionChiefs == null) {
                partitionChiefs = new HashMap<Integer, FireChief>();
                this.chiefs.put(schema.getDataSource(), partitionChiefs);
            }
            partitionChiefs.put(fireDepartment.getTuningConfig().getShardSpec().getPartitionNum(), chief);
            chief.setName(String.format("chief-%s[%s]", schema.getDataSource(), fireDepartment.getTuningConfig().getShardSpec().getPartitionNum()));
            chief.setDaemon(true);
            chief.start();
        }
    }

    @LifecycleStop
    public void stop() {
        for (Map<Integer, FireChief> chiefs : this.chiefs.values()) {
            for (FireChief chief : chiefs.values()) {
                CloseQuietly.close((Closeable)chief);
            }
        }
    }

    public FireDepartmentMetrics getMetrics(String datasource) {
        Map<Integer, FireChief> chiefs = this.chiefs.get(datasource);
        if (chiefs == null) {
            return null;
        }
        FireDepartmentMetrics snapshot = null;
        for (FireChief chief : chiefs.values()) {
            if (snapshot == null) {
                snapshot = chief.getMetrics().snapshot();
                continue;
            }
            snapshot.merge(chief.getMetrics());
        }
        return snapshot;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(final Query<T> query, Iterable<Interval> intervals) {
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        Map<Integer, FireChief> partitionChiefs = this.chiefs.get(Iterables.getOnlyElement((Iterable)query.getDataSource().getNames()));
        return partitionChiefs == null ? new NoopQueryRunner() : factory.getToolchest().mergeResults(factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), Iterables.transform(partitionChiefs.values(), (Function)new Function<FireChief, QueryRunner<T>>(){

            public QueryRunner<T> apply(FireChief fireChief) {
                return fireChief.getQueryRunner(query);
            }
        })));
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(final Query<T> query, Iterable<SegmentDescriptor> specs) {
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        final Map<Integer, FireChief> partitionChiefs = this.chiefs.get(Iterables.getOnlyElement((Iterable)query.getDataSource().getNames()));
        return partitionChiefs == null ? new NoopQueryRunner() : factory.getToolchest().mergeResults(factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), Iterables.transform(specs, (Function)new Function<SegmentDescriptor, QueryRunner<T>>(){

            public QueryRunner<T> apply(SegmentDescriptor spec) {
                FireChief retVal = (FireChief)partitionChiefs.get(spec.getPartitionNumber());
                return retVal == null ? new QueryRunner() : retVal.getQueryRunner(query.withQuerySegmentSpec((QuerySegmentSpec)new SpecificSegmentSpec(spec)));
            }
        })));
    }

    static class FireChief
    extends Thread
    implements Closeable {
        private final FireDepartment fireDepartment;
        private final FireDepartmentMetrics metrics;
        private final RealtimeTuningConfig config;
        private final QueryRunnerFactoryConglomerate conglomerate;
        private volatile Firehose firehose = null;
        private volatile FirehoseV2 firehoseV2 = null;
        private volatile Plumber plumber = null;
        private volatile boolean normalExit = true;

        public FireChief(FireDepartment fireDepartment, QueryRunnerFactoryConglomerate conglomerate) {
            this.fireDepartment = fireDepartment;
            this.conglomerate = conglomerate;
            this.config = fireDepartment.getTuningConfig();
            this.metrics = fireDepartment.getMetrics();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Firehose initFirehose() {
            FireChief fireChief = this;
            synchronized (fireChief) {
                if (this.firehose == null) {
                    try {
                        log.info("Calling the FireDepartment and getting a Firehose.", new Object[0]);
                        this.firehose = this.fireDepartment.connect();
                        log.info("Firehose acquired!", new Object[0]);
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                } else {
                    log.warn("Firehose already connected, skipping initFirehose().", new Object[0]);
                }
                return this.firehose;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FirehoseV2 initFirehoseV2(Object metaData) {
            FireChief fireChief = this;
            synchronized (fireChief) {
                if (this.firehoseV2 == null) {
                    try {
                        log.info("Calling the FireDepartment and getting a FirehoseV2.", new Object[0]);
                        this.firehoseV2 = this.fireDepartment.connect(metaData);
                        log.info("FirehoseV2 acquired!", new Object[0]);
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                } else {
                    log.warn("FirehoseV2 already connected, skipping initFirehoseV2().", new Object[0]);
                }
                return this.firehoseV2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Plumber initPlumber() {
            FireChief fireChief = this;
            synchronized (fireChief) {
                if (this.plumber == null) {
                    log.info("Someone get us a plumber!", new Object[0]);
                    this.plumber = this.fireDepartment.findPlumber();
                    log.info("We have our plumber!", new Object[0]);
                } else {
                    log.warn("Plumber already trained, skipping initPlumber().", new Object[0]);
                }
                return this.plumber;
            }
        }

        public FireDepartmentMetrics getMetrics() {
            return this.metrics;
        }

        @Override
        public void run() {
            this.plumber = this.initPlumber();
            try {
                Object metadata = this.plumber.startJob();
                if (this.fireDepartment.checkFirehoseV2()) {
                    this.firehoseV2 = this.initFirehoseV2(metadata);
                    this.runFirehoseV2(this.firehoseV2);
                } else {
                    this.firehose = this.initFirehose();
                    this.runFirehose(this.firehose);
                }
            }
            catch (RuntimeException e) {
                log.makeAlert((Throwable)e, "RuntimeException aborted realtime processing[%s]", new Object[]{this.fireDepartment.getDataSchema().getDataSource()}).emit();
                this.normalExit = false;
                throw e;
            }
            catch (Error e) {
                log.makeAlert((Throwable)e, "Exception aborted realtime processing[%s]", new Object[]{this.fireDepartment.getDataSchema().getDataSource()}).emit();
                this.normalExit = false;
                throw e;
            }
            finally {
                CloseQuietly.close((Closeable)this.firehose);
                if (this.normalExit) {
                    this.plumber.finishJob();
                    this.plumber = null;
                    this.firehose = null;
                }
            }
        }

        private void runFirehoseV2(FirehoseV2 firehose) {
            try {
                firehose.start();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to start firehoseV2", new Object[0]);
                return;
            }
            log.info("FirehoseV2 started", new Object[0]);
            Supplier<Committer> committerSupplier = Committers.supplierFromFirehoseV2(firehose);
            boolean haveRow = true;
            while (haveRow) {
                InputRow inputRow = null;
                int numRows = 0;
                try {
                    inputRow = firehose.currRow();
                    if (inputRow != null) {
                        numRows = this.plumber.add(inputRow, committerSupplier);
                        if (numRows < 0) {
                            this.metrics.incrementThrownAway();
                            log.debug("Throwing away event[%s]", new Object[]{inputRow});
                        } else {
                            this.metrics.incrementProcessed();
                        }
                    } else {
                        log.debug("thrown away null input row, considering unparseable", new Object[0]);
                        this.metrics.incrementUnparseable();
                    }
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Unknown exception, Ignoring and continuing.", new Object[0]).addData("inputRow", (Object)inputRow);
                }
                try {
                    haveRow = firehose.advance();
                }
                catch (Exception e) {
                    log.debug((Throwable)e, "exception in firehose.advance(), considering unparseable row", new Object[0]);
                    this.metrics.incrementUnparseable();
                }
            }
        }

        private void runFirehose(Firehose firehose) {
            Supplier<Committer> committerSupplier = Committers.supplierFromFirehose(firehose);
            while (firehose.hasMore()) {
                Plumbers.addNextRow(committerSupplier, firehose, this.plumber, this.config.isReportParseExceptions(), this.metrics);
            }
        }

        public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
            QueryRunnerFactory factory = this.conglomerate.findFactory(query);
            QueryToolChest toolChest = factory.getToolchest();
            return new FinalizeResultsQueryRunner(this.plumber.getQueryRunner(query), toolChest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            FireChief fireChief = this;
            synchronized (fireChief) {
                if (this.firehose != null) {
                    this.normalExit = false;
                    this.firehose.close();
                }
            }
        }
    }
}

