/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import java.util.Map;

public class OmniDataSegmentArchiver
implements DataSegmentArchiver {
    private final Map<String, DataSegmentArchiver> archivers;

    @Inject
    public OmniDataSegmentArchiver(Map<String, DataSegmentArchiver> archivers) {
        this.archivers = archivers;
    }

    public DataSegment archive(DataSegment segment) throws SegmentLoadingException {
        return this.getArchiver(segment).archive(segment);
    }

    public DataSegment restore(DataSegment segment) throws SegmentLoadingException {
        return this.getArchiver(segment).restore(segment);
    }

    private DataSegmentArchiver getArchiver(DataSegment segment) throws SegmentLoadingException {
        String type = MapUtils.getString((Map)segment.getLoadSpec(), (String)"type");
        DataSegmentArchiver archiver = this.archivers.get(type);
        if (archiver == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", new Object[]{type, this.archivers.keySet()});
        }
        return archiver;
    }
}

