/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.indexing.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.Granularity;
import io.druid.granularity.QueryGranularities;
import io.druid.granularity.QueryGranularity;
import io.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import io.druid.segment.indexing.granularity.GranularitySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class UniformGranularitySpec
implements GranularitySpec {
    private static final Granularity DEFAULT_SEGMENT_GRANULARITY = Granularity.DAY;
    private static final QueryGranularity DEFAULT_QUERY_GRANULARITY = QueryGranularities.NONE;
    private final Granularity segmentGranularity;
    private final QueryGranularity queryGranularity;
    private final Boolean rollup;
    private final List<Interval> inputIntervals;
    private final ArbitraryGranularitySpec wrappedSpec;

    @JsonCreator
    public UniformGranularitySpec(@JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="queryGranularity") QueryGranularity queryGranularity, @JsonProperty(value="rollup") Boolean rollup, @JsonProperty(value="intervals") List<Interval> inputIntervals) {
        this.segmentGranularity = segmentGranularity == null ? DEFAULT_SEGMENT_GRANULARITY : segmentGranularity;
        this.queryGranularity = queryGranularity == null ? DEFAULT_QUERY_GRANULARITY : queryGranularity;
        Boolean bl = this.rollup = rollup == null ? Boolean.TRUE : rollup;
        if (inputIntervals != null) {
            ArrayList granularIntervals = Lists.newArrayList();
            for (Interval inputInterval : inputIntervals) {
                Iterables.addAll((Collection)granularIntervals, (Iterable)this.segmentGranularity.getIterable(inputInterval));
            }
            this.inputIntervals = ImmutableList.copyOf(inputIntervals);
            this.wrappedSpec = new ArbitraryGranularitySpec(queryGranularity, rollup, granularIntervals);
        } else {
            this.inputIntervals = null;
            this.wrappedSpec = null;
        }
    }

    public UniformGranularitySpec(Granularity segmentGranularity, QueryGranularity queryGranularity, List<Interval> inputIntervals) {
        this(segmentGranularity, queryGranularity, true, inputIntervals);
    }

    @Override
    public Optional<SortedSet<Interval>> bucketIntervals() {
        if (this.wrappedSpec == null) {
            return Optional.absent();
        }
        return this.wrappedSpec.bucketIntervals();
    }

    @Override
    public Optional<Interval> bucketInterval(DateTime dt) {
        return this.wrappedSpec.bucketInterval(dt);
    }

    @Override
    @JsonProperty(value="segmentGranularity")
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @Override
    @JsonProperty(value="rollup")
    public boolean isRollup() {
        return this.rollup;
    }

    @Override
    @JsonProperty(value="queryGranularity")
    public QueryGranularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty(value="intervals")
    public Optional<List<Interval>> getIntervals() {
        return Optional.fromNullable(this.inputIntervals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniformGranularitySpec that = (UniformGranularitySpec)o;
        if (this.segmentGranularity != that.segmentGranularity) {
            return false;
        }
        if (!this.queryGranularity.equals(that.queryGranularity)) {
            return false;
        }
        if (!this.rollup.equals(that.rollup)) {
            return false;
        }
        if (this.inputIntervals != null ? !this.inputIntervals.equals(that.inputIntervals) : that.inputIntervals != null) {
            return false;
        }
        return !(this.wrappedSpec == null ? that.wrappedSpec != null : !this.wrappedSpec.equals(that.wrappedSpec));
    }

    public int hashCode() {
        int result = this.segmentGranularity.hashCode();
        result = 31 * result + this.queryGranularity.hashCode();
        result = 31 * result + this.rollup.hashCode();
        result = 31 * result + (this.inputIntervals != null ? this.inputIntervals.hashCode() : 0);
        result = 31 * result + (this.wrappedSpec != null ? this.wrappedSpec.hashCode() : 0);
        return result;
    }
}

