/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.indexer.MetadataStorageUpdaterJobHandler;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.NoneShardSpec;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataStorageUpdaterJobHandler
implements MetadataStorageUpdaterJobHandler {
    private static final Logger log = new Logger(SQLMetadataStorageUpdaterJobHandler.class);
    private final IDBI dbi;

    @Inject
    public SQLMetadataStorageUpdaterJobHandler(SQLMetadataConnector connector) {
        this.dbi = connector.getDBI();
    }

    public void publishSegments(final String tableName, final List<DataSegment> segments, final ObjectMapper mapper) {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                PreparedBatch batch = handle.prepareBatch(String.format("INSERT INTO %s (id, dataSource, created_date, start, \"end\", partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", tableName));
                for (DataSegment segment : segments) {
                    batch.add((Map)new ImmutableMap.Builder().put((Object)"id", (Object)segment.getIdentifier()).put((Object)"dataSource", (Object)segment.getDataSource()).put((Object)"created_date", (Object)new DateTime().toString()).put((Object)"start", (Object)segment.getInterval().getStart().toString()).put((Object)"end", (Object)segment.getInterval().getEnd().toString()).put((Object)"partitioned", (Object)(!(segment.getShardSpec() instanceof NoneShardSpec) ? 1 : 0)).put((Object)"version", (Object)segment.getVersion()).put((Object)"used", (Object)true).put((Object)"payload", (Object)mapper.writeValueAsBytes((Object)segment)).build());
                    log.info("Published %s", new Object[]{segment.getIdentifier()});
                }
                batch.execute();
                return null;
            }
        });
    }
}

