/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.maxminddb;

import com.fasterxml.jackson.databind.JsonNode;
import com.maxmind.maxminddb.Decoder;
import com.maxmind.maxminddb.InvalidDatabaseException;
import com.maxmind.maxminddb.Log;
import com.maxmind.maxminddb.Metadata;
import com.maxmind.maxminddb.ThreadBuffer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public final class MaxMindDbReader
implements Closeable {
    private static final int DATA_SECTION_SEPARATOR_SIZE = 16;
    private static final byte[] METADATA_START_MARKER = new byte[]{-85, -51, -17, 77, 97, 120, 77, 105, 110, 100, 46, 99, 111, 109};
    private static final boolean DEBUG = System.getenv().get("MAXMIND_DB_READER_DEBUG") != null;
    private final Decoder decoder;
    private final Metadata metadata;
    private final ThreadBuffer threadBuffer;

    public MaxMindDbReader(File database) throws IOException {
        this(database, FileMode.MEMORY_MAPPED);
    }

    public MaxMindDbReader(File database, FileMode fileMode) throws IOException {
        this.threadBuffer = new ThreadBuffer(database, fileMode);
        int start = this.findMetadataStart();
        if (start < 0) {
            throw new InvalidDatabaseException("Could not find a MaxMind DB metadata marker in this file (" + database.getName() + "). Is this a valid MaxMind DB file?");
        }
        Decoder metadataDecoder = new Decoder(this.threadBuffer, 0L);
        this.metadata = new Metadata(metadataDecoder.decode(start).getNode());
        this.decoder = new Decoder(this.threadBuffer, this.metadata.searchTreeSize + 16);
        if (DEBUG) {
            Log.debug(this.metadata.toString());
        }
    }

    public JsonNode get(InetAddress ipAddress) throws IOException {
        int pointer = this.findAddressInTree(ipAddress);
        if (pointer == 0) {
            return null;
        }
        ((ByteBuffer)this.threadBuffer.get()).position(pointer);
        return this.resolveDataPointer(pointer);
    }

    private int findAddressInTree(InetAddress address) throws InvalidDatabaseException {
        byte[] rawAddress = address.getAddress();
        if (DEBUG) {
            Log.debugNewLine();
            Log.debug("IP address", address);
            Log.debug("IP address", rawAddress);
            Log.debugNewLine();
        }
        boolean isIp4AddressInIp6Db = rawAddress.length == 4 && this.metadata.ipVersion == 6;
        int ipStartBit = isIp4AddressInIp6Db ? 96 : 0;
        int nodeNum = 0;
        for (int i = 0; i < rawAddress.length * 8 + ipStartBit; ++i) {
            int bit = 0;
            if (i >= ipStartBit) {
                int b = 0xFF & rawAddress[(i - ipStartBit) / 8];
                bit = 1 & b >> 7 - i % 8;
            }
            int record = this.readNode(nodeNum, bit);
            if (DEBUG) {
                Log.debug("Bit #", i);
                Log.debug("Bit value", bit);
                Log.debug("Record", bit == 1 ? "right" : "left");
                Log.debug("Record value", record);
            }
            if (record == this.metadata.nodeCount) {
                if (DEBUG) {
                    Log.debug("Record is empty");
                }
                return 0;
            }
            if (record > this.metadata.nodeCount) {
                if (DEBUG) {
                    Log.debug("Record is a data pointer");
                }
                return record;
            }
            if (DEBUG) {
                Log.debug("Record is a node number");
            }
            nodeNum = record;
        }
        throw new InvalidDatabaseException("Something bad happened");
    }

    private int readNode(int nodeNumber, int index) throws InvalidDatabaseException {
        ByteBuffer buffer = (ByteBuffer)this.threadBuffer.get();
        int baseOffset = nodeNumber * this.metadata.nodeByteSize;
        buffer.position(baseOffset);
        switch (this.metadata.recordSize) {
            case 24: {
                buffer.position(baseOffset + index * 3);
                return Decoder.decodeInteger(buffer, 0, 3);
            }
            case 28: {
                int middle = buffer.get(baseOffset + 3);
                middle = index == 0 ? (0xF0 & middle) >>> 4 : 0xF & middle;
                buffer.position(baseOffset + index * 4);
                return Decoder.decodeInteger(buffer, middle, 3);
            }
            case 32: {
                buffer.position(baseOffset + index * 4);
                return Decoder.decodeInteger(buffer, 0, 4);
            }
        }
        throw new InvalidDatabaseException("Unknown record size: " + this.metadata.recordSize);
    }

    private JsonNode resolveDataPointer(int pointer) throws IOException {
        int resolved = pointer - this.metadata.nodeCount + this.metadata.searchTreeSize;
        if (DEBUG) {
            int treeSize = this.metadata.searchTreeSize;
            Log.debug("Resolved data pointer", "( " + pointer + " - " + this.metadata.nodeCount + " ) + " + treeSize + " = " + resolved);
        }
        return this.decoder.decode(resolved).getNode();
    }

    private int findMetadataStart() {
        ByteBuffer buffer = (ByteBuffer)this.threadBuffer.get();
        int fileSize = buffer.capacity();
        block0: for (int i = 0; i < fileSize - METADATA_START_MARKER.length + 1; ++i) {
            for (int j = 0; j < METADATA_START_MARKER.length; ++j) {
                byte b = buffer.get(fileSize - i - j - 1);
                if (b != METADATA_START_MARKER[METADATA_START_MARKER.length - j - 1]) continue block0;
            }
            return fileSize - i;
        }
        return -1;
    }

    Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() throws IOException {
        this.threadBuffer.close();
    }

    public static enum FileMode {
        MEMORY_MAPPED,
        MEMORY;

    }
}

