/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client.response;

import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.response.ClientResponse;
import com.metamx.http.client.response.HttpResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class SequenceInputStreamResponseHandler
implements HttpResponseHandler<InputStream, InputStream> {
    private static final Logger log = new Logger(SequenceInputStreamResponseHandler.class);
    private final AtomicLong byteCount = new AtomicLong(0L);
    private final BlockingQueue<InputStream> queue = new LinkedBlockingQueue<InputStream>();
    private final AtomicBoolean done = new AtomicBoolean(false);

    @Override
    public ClientResponse<InputStream> handleResponse(HttpResponse response) {
        try {
            this.queue.put((InputStream)new ChannelBufferInputStream(response.getContent()));
        }
        catch (InterruptedException e) {
            log.error((Throwable)e, "Queue appending interrupted", new Object[0]);
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        this.byteCount.addAndGet(response.getContent().readableBytes());
        return ClientResponse.finished(new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                AtomicBoolean atomicBoolean = SequenceInputStreamResponseHandler.this.done;
                synchronized (atomicBoolean) {
                    return !SequenceInputStreamResponseHandler.this.done.get() || !SequenceInputStreamResponseHandler.this.queue.isEmpty();
                }
            }

            @Override
            public InputStream nextElement() {
                try {
                    return (InputStream)SequenceInputStreamResponseHandler.this.queue.take();
                }
                catch (InterruptedException e) {
                    log.warn((Throwable)e, "Thread interrupted while taking from queue", new Object[0]);
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }));
    }

    @Override
    public ClientResponse<InputStream> handleChunk(ClientResponse<InputStream> clientResponse, HttpChunk chunk) {
        ChannelBuffer channelBuffer = chunk.getContent();
        int bytes = channelBuffer.readableBytes();
        if (bytes > 0) {
            try {
                this.queue.put((InputStream)new ChannelBufferInputStream(channelBuffer));
                log.debug("Added stream. Queue length %d", new Object[]{this.queue.size()});
            }
            catch (InterruptedException e) {
                log.warn((Throwable)e, "Thread interrupted while adding to queue", new Object[0]);
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            this.byteCount.addAndGet(bytes);
        } else {
            log.debug("Skipping zero length chunk", new Object[0]);
        }
        return clientResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClientResponse<InputStream> done(ClientResponse<InputStream> clientResponse) {
        AtomicBoolean atomicBoolean = this.done;
        synchronized (atomicBoolean) {
            try {
                this.queue.put(ByteSource.empty().openStream());
                log.debug("Added terminal empty stream", new Object[0]);
            }
            catch (InterruptedException e) {
                try {
                    log.warn((Throwable)e, "Thread interrupted while adding to queue", new Object[0]);
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                    catch (IOException e2) {
                        log.wtf((Throwable)e2, "The empty stream threw an IOException", new Object[0]);
                        throw Throwables.propagate((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    log.debug("Done after adding %d bytes of streams", new Object[]{this.byteCount.get()});
                    this.done.set(true);
                    throw throwable;
                }
            }
            log.debug("Done after adding %d bytes of streams", new Object[]{this.byteCount.get()});
            this.done.set(true);
            return ClientResponse.finished(clientResponse.getObj());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ClientResponse<InputStream> clientResponse, final Throwable e) {
        AtomicBoolean atomicBoolean = this.done;
        synchronized (atomicBoolean) {
            this.done.set(true);
            boolean accepted = this.queue.offer(new InputStream(){

                @Override
                public int read() throws IOException {
                    throw new IOException(e);
                }
            });
            if (!accepted) {
                log.warn("Unable to place final IOException offer in queue", new Object[0]);
            } else {
                log.debug("Placed IOException in queue", new Object[0]);
            }
            log.debug(e, "Exception with queue length of %d and %d bytes available", new Object[]{this.queue.size(), this.byteCount.get()});
        }
    }

    public final long getByteCount() {
        return this.byteCount.get();
    }
}

