/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.listener.announcer;

import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.curator.announcement.Announcer;
import io.druid.server.listener.announcer.ListeningAnnouncerConfig;
import java.nio.ByteBuffer;
import org.apache.curator.utils.ZKPaths;
import org.joda.time.DateTime;

public abstract class ListenerResourceAnnouncer {
    private static final byte[] ANNOUNCE_BYTES = ByteBuffer.allocate(8).putLong(DateTime.now().getMillis()).array();
    private static final Logger LOG = new Logger(ListenerResourceAnnouncer.class);
    private final Object startStopSync = new Object();
    private volatile boolean started = false;
    private final Announcer announcer;
    private final String announcePath;

    public ListenerResourceAnnouncer(Announcer announcer, ListeningAnnouncerConfig listeningAnnouncerConfig, String listener_key, HostAndPort node) {
        this(announcer, ZKPaths.makePath((String)listeningAnnouncerConfig.getListenersPath(), (String)listener_key), node);
    }

    ListenerResourceAnnouncer(Announcer announcer, String announceBasePath, HostAndPort node) {
        this.announcePath = ZKPaths.makePath((String)announceBasePath, (String)node.toString());
        this.announcer = announcer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.startStopSync;
        synchronized (object) {
            if (this.started) {
                LOG.debug("Already started, ignoring", new Object[0]);
                return;
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            this.announcer.announce(this.announcePath, ANNOUNCE_BYTES);
            LOG.info("Announcing start time on [%s]", new Object[]{this.announcePath});
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.startStopSync;
        synchronized (object) {
            if (!this.started) {
                LOG.debug("Already stopped, ignoring", new Object[0]);
                return;
            }
            this.announcer.unannounce(this.announcePath);
            LOG.info("Unannouncing start time on [%s]", new Object[]{this.announcePath});
            this.started = false;
        }
    }

    public byte[] getAnnounceBytes() {
        return ByteBuffer.allocate(ANNOUNCE_BYTES.length).put(ANNOUNCE_BYTES).array();
    }
}

