/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http.security;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import io.druid.server.security.Action;
import io.druid.server.security.AuthConfig;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;

public abstract class AbstractResourceFilter
implements ResourceFilter,
ContainerRequestFilter {
    @Context
    private HttpServletRequest req;
    private final AuthConfig authConfig;

    @Inject
    public AbstractResourceFilter(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    public HttpServletRequest getReq() {
        return this.req;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public AbstractResourceFilter setReq(HttpServletRequest req) {
        this.req = req;
        return this;
    }

    protected Action getAction(ContainerRequest request) {
        Action action;
        switch (request.getMethod()) {
            case "GET": 
            case "HEAD": {
                action = Action.READ;
                break;
            }
            default: {
                action = Action.WRITE;
            }
        }
        return action;
    }

    public abstract boolean isApplicable(String var1);
}

