/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import io.druid.client.indexing.IndexingService;
import io.druid.client.selector.Server;
import io.druid.curator.discovery.ServerDiscoverySelector;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.proxy.ProxyServlet;

public class OverlordProxyServlet
extends ProxyServlet {
    private final ServerDiscoverySelector selector;

    @Inject
    OverlordProxyServlet(@IndexingService ServerDiscoverySelector selector) {
        this.selector = selector;
    }

    protected URI rewriteURI(HttpServletRequest request) {
        try {
            Server indexer = this.selector.pick();
            if (indexer == null) {
                throw new ISE("Can't find indexingService, did you configure druid.selectors.indexing.serviceName same as druid.service at overlord?", new Object[0]);
            }
            return new URI(request.getScheme(), indexer.getHost(), request.getRequestURI(), request.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

