/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import io.druid.server.coordinator.BalancerSegmentHolder;
import io.druid.server.coordinator.BalancerStrategy;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.ReservoirSegmentSampler;
import io.druid.server.coordinator.ServerHolder;
import io.druid.timeline.DataSegment;
import java.util.List;
import java.util.Random;

public class RandomBalancerStrategy
implements BalancerStrategy {
    private final ReservoirSegmentSampler sampler = new ReservoirSegmentSampler();

    @Override
    public ServerHolder findNewSegmentHomeReplicator(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        if (serverHolders.size() == 1) {
            return null;
        }
        ServerHolder holder = serverHolders.get(new Random().nextInt(serverHolders.size()));
        while (holder.isServingSegment(proposalSegment)) {
            holder = serverHolders.get(new Random().nextInt(serverHolders.size()));
        }
        return holder;
    }

    @Override
    public ServerHolder findNewSegmentHomeBalancer(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        return null;
    }

    @Override
    public BalancerSegmentHolder pickSegmentToMove(List<ServerHolder> serverHolders) {
        return this.sampler.getRandomBalancerSegmentHolder(serverHolders);
    }

    @Override
    public void emitStats(String tier, CoordinatorStats stats, List<ServerHolder> serverHolderList) {
    }
}

