/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.guice.http.DruidHttpClientConfig;
import io.druid.query.DruidMetrics;
import io.druid.query.Query;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.server.QueryStats;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import io.druid.server.router.QueryHostFinder;
import io.druid.server.router.Router;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.joda.time.DateTime;

public class AsyncQueryForwardingServlet
extends AsyncProxyServlet {
    private static final EmittingLogger log = new EmittingLogger(AsyncQueryForwardingServlet.class);
    @Deprecated
    private static final String APPLICATION_SMILE = "application/smile";
    private static final String HOST_ATTRIBUTE = "io.druid.proxy.to.host";
    private static final String QUERY_ATTRIBUTE = "io.druid.proxy.query";
    private static final String OBJECTMAPPER_ATTRIBUTE = "io.druid.proxy.objectMapper";
    private static final int CANCELLATION_TIMEOUT_MILLIS = 500;
    private static final int MAX_QUEUED_CANCELLATIONS = 64;
    private final QueryToolChestWarehouse warehouse;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final QueryHostFinder hostFinder;
    private final Provider<HttpClient> httpClientProvider;
    private final DruidHttpClientConfig httpClientConfig;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private HttpClient broadcastClient;

    private static void handleException(HttpServletResponse response, ObjectMapper objectMapper, Exception exception) throws IOException {
        if (!response.isCommitted()) {
            String errorMessage = exception.getMessage() == null ? "null exception" : exception.getMessage();
            response.resetBuffer();
            response.setStatus(500);
            objectMapper.writeValue((OutputStream)response.getOutputStream(), (Object)ImmutableMap.of((Object)"error", (Object)errorMessage));
        }
        response.flushBuffer();
    }

    public AsyncQueryForwardingServlet(QueryToolChestWarehouse warehouse, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryHostFinder hostFinder, @Router Provider<HttpClient> httpClientProvider, DruidHttpClientConfig httpClientConfig, ServiceEmitter emitter, RequestLogger requestLogger) {
        this.warehouse = warehouse;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.hostFinder = hostFinder;
        this.httpClientProvider = httpClientProvider;
        this.httpClientConfig = httpClientConfig;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
    }

    public void init() throws ServletException {
        super.init();
        this.broadcastClient = (HttpClient)this.httpClientProvider.get();
        this.broadcastClient.setConnectTimeout(500L);
        this.broadcastClient.setMaxRequestsQueuedPerDestination(64);
        try {
            this.broadcastClient.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        try {
            this.broadcastClient.stop();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error stopping servlet", new Object[0]);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isSmile = "application/x-jackson-smile".equals(request.getContentType()) || APPLICATION_SMILE.equals(request.getContentType());
        ObjectMapper objectMapper = isSmile ? this.smileMapper : this.jsonMapper;
        request.setAttribute(OBJECTMAPPER_ATTRIBUTE, (Object)objectMapper);
        String defaultHost = this.hostFinder.getDefaultHost();
        request.setAttribute(HOST_ATTRIBUTE, (Object)defaultHost);
        boolean isQueryEndpoint = request.getRequestURI().startsWith("/druid/v2");
        if (isQueryEndpoint && HttpMethod.DELETE.is(request.getMethod())) {
            for (final String host : this.hostFinder.getAllHosts()) {
                if (host.equals(defaultHost)) continue;
                this.broadcastClient.newRequest(this.rewriteURI(request, host)).method(HttpMethod.DELETE).timeout(500L, TimeUnit.MILLISECONDS).send(new Response.CompleteListener(){

                    public void onComplete(Result result) {
                        if (result.isFailed()) {
                            log.warn(result.getFailure(), "Failed to forward cancellation request to [%s]", new Object[]{host});
                        }
                    }
                });
            }
        } else if (isQueryEndpoint && HttpMethod.POST.is(request.getMethod())) {
            try {
                Query inputQuery = (Query)objectMapper.readValue((InputStream)request.getInputStream(), Query.class);
                if (inputQuery != null) {
                    request.setAttribute(HOST_ATTRIBUTE, (Object)this.hostFinder.getHost(inputQuery));
                    if (inputQuery.getId() == null) {
                        inputQuery = inputQuery.withId(UUID.randomUUID().toString());
                    }
                }
                request.setAttribute(QUERY_ATTRIBUTE, (Object)inputQuery);
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Exception parsing query", new Object[0]);
                String errorMessage = e.getMessage() == null ? "no error message" : e.getMessage();
                this.requestLogger.log(new RequestLogLine(new DateTime(), request.getRemoteAddr(), null, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)errorMessage))));
                response.setStatus(400);
                response.setContentType("application/json");
                objectMapper.writeValue((OutputStream)response.getOutputStream(), (Object)ImmutableMap.of((Object)"error", (Object)errorMessage));
                return;
            }
            catch (Exception e) {
                AsyncQueryForwardingServlet.handleException(response, objectMapper, e);
                return;
            }
        }
        super.service(request, response);
    }

    protected void customizeProxyRequest(Request proxyRequest, HttpServletRequest request) {
        proxyRequest.timeout(this.httpClientConfig.getReadTimeout().getMillis(), TimeUnit.MILLISECONDS);
        proxyRequest.idleTimeout(this.httpClientConfig.getReadTimeout().getMillis(), TimeUnit.MILLISECONDS);
        Query query = (Query)request.getAttribute(QUERY_ATTRIBUTE);
        if (query != null) {
            ObjectMapper objectMapper = (ObjectMapper)request.getAttribute(OBJECTMAPPER_ATTRIBUTE);
            try {
                proxyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{objectMapper.writeValueAsBytes((Object)query)}));
            }
            catch (JsonProcessingException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    protected Response.Listener newProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
        Query query = (Query)request.getAttribute(QUERY_ATTRIBUTE);
        if (query != null) {
            return this.newMetricsEmittingProxyResponseListener(request, response, query, System.currentTimeMillis());
        }
        return super.newProxyResponseListener(request, response);
    }

    protected URI rewriteURI(HttpServletRequest request) {
        return this.rewriteURI(request, (String)request.getAttribute(HOST_ATTRIBUTE));
    }

    protected URI rewriteURI(HttpServletRequest request, String host) {
        return AsyncQueryForwardingServlet.makeURI(host, request.getRequestURI(), request.getQueryString());
    }

    protected static URI makeURI(String host, String requestURI, String rawQueryString) {
        try {
            return new URI("http", host, requestURI, rawQueryString == null ? null : URLDecoder.decode(rawQueryString, "UTF-8"), null);
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            log.error((Throwable)e, "Unable to rewrite URI [%s]", new Object[]{e.getMessage()});
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected HttpClient newHttpClient() {
        return (HttpClient)this.httpClientProvider.get();
    }

    protected HttpClient createHttpClient() throws ServletException {
        HttpClient client = super.createHttpClient();
        this.setTimeout(this.httpClientConfig.getReadTimeout().getMillis());
        return client;
    }

    private Response.Listener newMetricsEmittingProxyResponseListener(HttpServletRequest request, HttpServletResponse response, Query query, long start) {
        return new MetricsEmittingProxyResponseListener(request, response, query, start);
    }

    private class MetricsEmittingProxyResponseListener
    extends ProxyServlet.ProxyResponseListener {
        private final HttpServletRequest req;
        private final HttpServletResponse res;
        private final Query query;
        private final long start;

        public MetricsEmittingProxyResponseListener(HttpServletRequest request, HttpServletResponse response, Query query, long start) {
            super((ProxyServlet)AsyncQueryForwardingServlet.this, request, response);
            this.req = request;
            this.res = response;
            this.query = query;
            this.start = start;
        }

        public void onComplete(Result result) {
            long requestTime = System.currentTimeMillis() - this.start;
            try {
                AsyncQueryForwardingServlet.this.emitter.emit(DruidMetrics.makeQueryTimeMetric((QueryToolChest)AsyncQueryForwardingServlet.this.warehouse.getToolChest(this.query), (ObjectMapper)AsyncQueryForwardingServlet.this.jsonMapper, (Query)this.query, (String)this.req.getRemoteAddr()).build("query/time", (Number)requestTime));
                AsyncQueryForwardingServlet.this.requestLogger.log(new RequestLogLine(new DateTime(), this.req.getRemoteAddr(), this.query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"query/time", (Object)requestTime, (Object)"success", (Object)(result.isSucceeded() && result.getResponse().getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0)))));
            }
            catch (Exception e) {
                log.error((Throwable)e, "Unable to log query [%s]!", new Object[]{this.query});
            }
            super.onComplete(result);
        }

        public void onFailure(Response response, Throwable failure) {
            try {
                String errorMessage = failure.getMessage();
                AsyncQueryForwardingServlet.this.requestLogger.log(new RequestLogLine(new DateTime(), this.req.getRemoteAddr(), this.query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)(errorMessage == null ? "no message" : errorMessage)))));
            }
            catch (IOException logError) {
                log.error((Throwable)logError, "Unable to log query [%s]!", new Object[]{this.query});
            }
            log.makeAlert(failure, "Exception handling request", new Object[0]).addData("exception", (Object)failure.toString()).addData("query", (Object)this.query).addData("peer", (Object)this.req.getRemoteAddr()).emit();
            super.onFailure(response, failure);
        }
    }
}

