/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.data.input.Committer;
import io.druid.data.input.InputRow;
import io.druid.query.SegmentDescriptor;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.FiniteAppenderatorDriverMetadata;
import io.druid.segment.realtime.appenderator.SegmentAllocator;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.segment.realtime.appenderator.SegmentNotWritableException;
import io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import io.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import io.druid.segment.realtime.appenderator.UsedSegmentChecker;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifier;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import io.druid.timeline.DataSegment;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class FiniteAppenderatorDriver
implements Closeable {
    private static final Logger log = new Logger(FiniteAppenderatorDriver.class);
    private final Appenderator appenderator;
    private final SegmentAllocator segmentAllocator;
    private final SegmentHandoffNotifier handoffNotifier;
    private final UsedSegmentChecker usedSegmentChecker;
    private final ObjectMapper objectMapper;
    private final int maxRowsPerSegment;
    private final long handoffConditionTimeout;
    private final Map<String, NavigableMap<Long, SegmentIdentifier>> activeSegments = new TreeMap<String, NavigableMap<Long, SegmentIdentifier>>();
    private final Map<String, String> lastSegmentIds = Maps.newHashMap();
    private final Object handoffMonitor = new Object();

    public FiniteAppenderatorDriver(Appenderator appenderator, SegmentAllocator segmentAllocator, SegmentHandoffNotifierFactory handoffNotifierFactory, UsedSegmentChecker usedSegmentChecker, ObjectMapper objectMapper, int maxRowsPerSegment, long handoffConditionTimeout) {
        this.appenderator = (Appenderator)Preconditions.checkNotNull((Object)appenderator, (Object)"appenderator");
        this.segmentAllocator = (SegmentAllocator)Preconditions.checkNotNull((Object)segmentAllocator, (Object)"segmentAllocator");
        this.handoffNotifier = ((SegmentHandoffNotifierFactory)Preconditions.checkNotNull((Object)handoffNotifierFactory, (Object)"handoffNotifierFactory")).createSegmentHandoffNotifier(appenderator.getDataSource());
        this.usedSegmentChecker = (UsedSegmentChecker)Preconditions.checkNotNull((Object)usedSegmentChecker, (Object)"usedSegmentChecker");
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper, (Object)"objectMapper");
        this.maxRowsPerSegment = maxRowsPerSegment;
        this.handoffConditionTimeout = handoffConditionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startJob() {
        this.handoffNotifier.start();
        FiniteAppenderatorDriverMetadata metadata = (FiniteAppenderatorDriverMetadata)this.objectMapper.convertValue(this.appenderator.startJob(), FiniteAppenderatorDriverMetadata.class);
        log.info("Restored metadata[%s].", new Object[]{metadata});
        if (metadata != null) {
            Map<String, NavigableMap<Long, SegmentIdentifier>> map = this.activeSegments;
            synchronized (map) {
                for (Map.Entry<String, List<SegmentIdentifier>> entry : metadata.getActiveSegments().entrySet()) {
                    String sequenceName = entry.getKey();
                    TreeMap segmentMap = Maps.newTreeMap();
                    this.lastSegmentIds.put(sequenceName, metadata.getLastSegmentIds().get(sequenceName));
                    this.activeSegments.put(sequenceName, segmentMap);
                    for (SegmentIdentifier identifier : entry.getValue()) {
                        segmentMap.put(identifier.getInterval().getStartMillis(), identifier);
                    }
                }
            }
            return metadata.getCallerMetadata();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws InterruptedException {
        Map<String, NavigableMap<Long, SegmentIdentifier>> map = this.activeSegments;
        synchronized (map) {
            this.activeSegments.clear();
        }
        this.appenderator.clear();
    }

    public SegmentIdentifier add(InputRow row, String sequenceName, Supplier<Committer> committerSupplier) throws IOException {
        Preconditions.checkNotNull((Object)row, (Object)"row");
        Preconditions.checkNotNull((Object)sequenceName, (Object)"sequenceName");
        Preconditions.checkNotNull(committerSupplier, (Object)"committerSupplier");
        SegmentIdentifier identifier = this.getSegment(row.getTimestamp(), sequenceName);
        if (identifier != null) {
            try {
                int numRows = this.appenderator.add(identifier, row, this.wrapCommitterSupplier(committerSupplier));
                if (numRows >= this.maxRowsPerSegment) {
                    this.moveSegmentOut(sequenceName, (List<SegmentIdentifier>)ImmutableList.of((Object)identifier));
                }
            }
            catch (SegmentNotWritableException e) {
                throw new ISE((Throwable)e, "WTF?! Segment[%s] not writable when it should have been.", new Object[]{identifier});
            }
        }
        return identifier;
    }

    public Object persist(Committer committer) throws InterruptedException {
        try {
            log.info("Persisting data.", new Object[0]);
            long start = System.currentTimeMillis();
            Object commitMetadata = this.appenderator.persistAll(this.wrapCommitter(committer)).get();
            log.info("Persisted pending data in %,dms.", new Object[]{System.currentTimeMillis() - start});
            return commitMetadata;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentsAndMetadata finish(TransactionalSegmentPublisher publisher, Committer committer) throws InterruptedException {
        SegmentsAndMetadata segmentsAndMetadata = this.publishAll(publisher, this.wrapCommitter(committer));
        if (segmentsAndMetadata != null) {
            long giveUpAt = this.handoffConditionTimeout > 0L ? System.currentTimeMillis() + this.handoffConditionTimeout : 0L;
            log.info("Awaiting handoff of segments: [%s]", new Object[]{Joiner.on((String)", ").join(this.appenderator.getSegments())});
            Object object = this.handoffMonitor;
            synchronized (object) {
                while (!this.appenderator.getSegments().isEmpty()) {
                    if (giveUpAt == 0L) {
                        this.handoffMonitor.wait();
                        continue;
                    }
                    long remaining = giveUpAt - System.currentTimeMillis();
                    if (remaining > 0L) {
                        this.handoffMonitor.wait(remaining);
                        continue;
                    }
                    throw new ISE("Segment handoff wait timeout. Segments not yet handed off: [%s]", new Object[]{Joiner.on((String)", ").join(this.appenderator.getSegments())});
                }
            }
            log.info("All segments handed off.", new Object[0]);
            return new SegmentsAndMetadata(segmentsAndMetadata.getSegments(), ((FiniteAppenderatorDriverMetadata)segmentsAndMetadata.getCommitMetadata()).getCallerMetadata());
        }
        return null;
    }

    @Override
    public void close() {
        this.handoffNotifier.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentIdentifier getActiveSegment(DateTime timestamp, String sequenceName) {
        Map<String, NavigableMap<Long, SegmentIdentifier>> map = this.activeSegments;
        synchronized (map) {
            NavigableMap<Long, SegmentIdentifier> activeSegmentsForSequence = this.activeSegments.get(sequenceName);
            if (activeSegmentsForSequence == null) {
                return null;
            }
            Map.Entry<Long, SegmentIdentifier> candidateEntry = activeSegmentsForSequence.floorEntry(timestamp.getMillis());
            if (candidateEntry != null && candidateEntry.getValue().getInterval().contains((ReadableInstant)timestamp)) {
                return candidateEntry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentIdentifier getSegment(DateTime timestamp, String sequenceName) throws IOException {
        Map<String, NavigableMap<Long, SegmentIdentifier>> map = this.activeSegments;
        synchronized (map) {
            SegmentIdentifier existing = this.getActiveSegment(timestamp, sequenceName);
            if (existing != null) {
                return existing;
            }
            NavigableMap<Long, SegmentIdentifier> activeSegmentsForSequence = this.activeSegments.get(sequenceName);
            SegmentIdentifier newSegment = this.segmentAllocator.allocate(timestamp, sequenceName, this.lastSegmentIds.get(sequenceName));
            if (newSegment != null) {
                Long key = newSegment.getInterval().getStartMillis();
                for (SegmentIdentifier identifier : this.appenderator.getSegments()) {
                    if (!identifier.equals(newSegment)) continue;
                    throw new ISE("WTF?! Allocated segment[%s] which conflicts with existing segment[%s].", new Object[]{newSegment, identifier});
                }
                log.info("New segment[%s] for sequenceName[%s].", new Object[]{newSegment, sequenceName});
                if (activeSegmentsForSequence == null) {
                    this.activeSegments.put(sequenceName, Maps.newTreeMap());
                }
                this.activeSegments.get(sequenceName).put(key, newSegment);
                this.lastSegmentIds.put(sequenceName, newSegment.getIdentifierAsString());
            } else {
                log.warn("Cannot allocate segment for timestamp[%s], sequenceName[%s]. ", new Object[]{timestamp, sequenceName});
            }
            return newSegment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSegmentOut(String sequenceName, List<SegmentIdentifier> identifiers) {
        Map<String, NavigableMap<Long, SegmentIdentifier>> map = this.activeSegments;
        synchronized (map) {
            NavigableMap<Long, SegmentIdentifier> activeSegmentsForSequence = this.activeSegments.get(sequenceName);
            if (activeSegmentsForSequence == null) {
                throw new ISE("WTF?! Asked to remove segments for sequenceName[%s] which doesn't exist...", new Object[]{sequenceName});
            }
            for (SegmentIdentifier identifier : identifiers) {
                log.info("Moving segment[%s] out of active list.", new Object[]{identifier});
                long key = identifier.getInterval().getStartMillis();
                if (activeSegmentsForSequence.remove(key) == identifier) continue;
                throw new ISE("WTF?! Asked to remove segment[%s] that didn't exist...", new Object[]{identifier});
            }
        }
    }

    private SegmentsAndMetadata publishAll(TransactionalSegmentPublisher publisher, Committer wrappedCommitter) throws InterruptedException {
        ImmutableList theSegments = ImmutableList.copyOf(this.appenderator.getSegments());
        long nTry = 0L;
        while (true) {
            try {
                log.info("Pushing segments: [%s]", new Object[]{Joiner.on((String)", ").join((Iterable)theSegments)});
                SegmentsAndMetadata segmentsAndMetadata = (SegmentsAndMetadata)this.appenderator.push((List<SegmentIdentifier>)theSegments, wrappedCommitter).get();
                if (!FiniteAppenderatorDriver.segmentsToIdentifiers(segmentsAndMetadata.getSegments()).equals(Sets.newHashSet((Iterable)theSegments))) {
                    throw new ISE("WTF?! Pushed different segments than requested. Pushed[%s], requested[%s].", new Object[]{Joiner.on((String)", ").join(FiniteAppenderatorDriver.identifiersToStrings(FiniteAppenderatorDriver.segmentsToIdentifiers(segmentsAndMetadata.getSegments()))), Joiner.on((String)", ").join(FiniteAppenderatorDriver.identifiersToStrings((Iterable<SegmentIdentifier>)theSegments))});
                }
                log.info("Publishing segments with commitMetadata[%s]: [%s]", new Object[]{segmentsAndMetadata.getCommitMetadata(), Joiner.on((String)", ").join(segmentsAndMetadata.getSegments())});
                if (segmentsAndMetadata.getSegments().isEmpty()) {
                    log.info("Nothing to publish, skipping publish step.", new Object[0]);
                } else {
                    boolean published = publisher.publishSegments((Set<DataSegment>)ImmutableSet.copyOf(segmentsAndMetadata.getSegments()), ((FiniteAppenderatorDriverMetadata)segmentsAndMetadata.getCommitMetadata()).getCallerMetadata());
                    if (published) {
                        log.info("Published segments, awaiting handoff.", new Object[0]);
                    } else {
                        log.info("Transaction failure while publishing segments, checking if someone else beat us to it.", new Object[0]);
                        if (this.usedSegmentChecker.findUsedSegments(FiniteAppenderatorDriver.segmentsToIdentifiers(segmentsAndMetadata.getSegments())).equals(Sets.newHashSet(segmentsAndMetadata.getSegments()))) {
                            log.info("Our segments really do exist, awaiting handoff.", new Object[0]);
                        } else {
                            log.warn("Our segments don't exist, giving up.", new Object[0]);
                            return null;
                        }
                    }
                }
                for (final DataSegment dataSegment : segmentsAndMetadata.getSegments()) {
                    this.handoffNotifier.registerSegmentHandoffCallback(new SegmentDescriptor(dataSegment.getInterval(), dataSegment.getVersion(), dataSegment.getShardSpec().getPartitionNum()), (Executor)MoreExecutors.sameThreadExecutor(), new Runnable(){

                        @Override
                        public void run() {
                            SegmentIdentifier identifier = SegmentIdentifier.fromDataSegment(dataSegment);
                            log.info("Segment[%s] successfully handed off, dropping.", new Object[]{identifier});
                            ListenableFuture<?> dropFuture = FiniteAppenderatorDriver.this.appenderator.drop(identifier);
                            Futures.addCallback(dropFuture, (FutureCallback)new FutureCallback<Object>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void onSuccess(Object result) {
                                    Object object = FiniteAppenderatorDriver.this.handoffMonitor;
                                    synchronized (object) {
                                        FiniteAppenderatorDriver.this.handoffMonitor.notifyAll();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void onFailure(Throwable e) {
                                    log.warn(e, "Failed to drop segment[%s]?!", new Object[0]);
                                    Object object = FiniteAppenderatorDriver.this.handoffMonitor;
                                    synchronized (object) {
                                        FiniteAppenderatorDriver.this.handoffMonitor.notifyAll();
                                    }
                                }
                            });
                        }
                    });
                }
                return segmentsAndMetadata;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                long sleepMillis = FiniteAppenderatorDriver.computeNextRetrySleep(++nTry);
                log.warn((Throwable)e, "Failed publishAll (try %d), retrying in %,dms.", new Object[]{nTry, sleepMillis});
                Thread.sleep(sleepMillis);
                continue;
            }
            break;
        }
    }

    private Supplier<Committer> wrapCommitterSupplier(final Supplier<Committer> committerSupplier) {
        return new Supplier<Committer>(){

            public Committer get() {
                return FiniteAppenderatorDriver.this.wrapCommitter((Committer)committerSupplier.get());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Committer wrapCommitter(final Committer committer) {
        Map<String, NavigableMap<Long, SegmentIdentifier>> map = this.activeSegments;
        synchronized (map) {
            final FiniteAppenderatorDriverMetadata wrappedMetadata = new FiniteAppenderatorDriverMetadata((Map<String, List<SegmentIdentifier>>)ImmutableMap.copyOf((Map)Maps.transformValues(this.activeSegments, (Function)new Function<NavigableMap<Long, SegmentIdentifier>, List<SegmentIdentifier>>(){

                public List<SegmentIdentifier> apply(NavigableMap<Long, SegmentIdentifier> input) {
                    return ImmutableList.copyOf(input.values());
                }
            })), (Map<String, String>)ImmutableMap.copyOf(this.lastSegmentIds), committer.getMetadata());
            return new Committer(){

                public Object getMetadata() {
                    return wrappedMetadata;
                }

                public void run() {
                    committer.run();
                }
            };
        }
    }

    private static long computeNextRetrySleep(long nTry) {
        long baseSleepMillis = 1000L;
        long maxSleepMillis = 60000L;
        double fuzzyMultiplier = Math.min(Math.max(1.0 + 0.2 * new Random().nextGaussian(), 0.0), 2.0);
        return (long)(Math.min(60000.0, 1000.0 * Math.pow(2.0, nTry)) * fuzzyMultiplier);
    }

    private static Set<SegmentIdentifier> segmentsToIdentifiers(Iterable<DataSegment> segments) {
        return FluentIterable.from(segments).transform((Function)new Function<DataSegment, SegmentIdentifier>(){

            public SegmentIdentifier apply(DataSegment segment) {
                return SegmentIdentifier.fromDataSegment(segment);
            }
        }).toSet();
    }

    private static Iterable<String> identifiersToStrings(Iterable<SegmentIdentifier> identifiers) {
        return FluentIterable.from(identifiers).transform((Function)new Function<SegmentIdentifier, String>(){

            public String apply(SegmentIdentifier input) {
                return input.getIdentifierAsString();
            }
        });
    }
}

