/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.guice.annotations.Processing;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.AppenderatorFactory;
import io.druid.segment.realtime.appenderator.Appenderators;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.partition.ShardSpec;
import java.io.File;
import java.util.concurrent.ExecutorService;

public class DefaultAppenderatorFactory
implements AppenderatorFactory {
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ExecutorService queryExecutorService;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final IndexIO indexIO;
    private final IndexMerger indexMerger;
    private final Cache cache;
    private final CacheConfig cacheConfig;

    public DefaultAppenderatorFactory(@JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject @Processing ExecutorService queryExecutorService, @JacksonInject DataSegmentPusher dataSegmentPusher, @JacksonInject ObjectMapper objectMapper, @JacksonInject IndexIO indexIO, @JacksonInject IndexMerger indexMerger, @JacksonInject Cache cache, @JacksonInject CacheConfig cacheConfig) {
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.queryExecutorService = queryExecutorService;
        this.dataSegmentPusher = dataSegmentPusher;
        this.objectMapper = objectMapper;
        this.indexIO = indexIO;
        this.indexMerger = indexMerger;
        this.cache = cache;
        this.cacheConfig = cacheConfig;
    }

    @Override
    public Appenderator build(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        return Appenderators.createRealtime(schema, config.withBasePersistDirectory(DefaultAppenderatorFactory.makeBasePersistSubdirectory(config.getBasePersistDirectory(), schema.getDataSource(), config.getShardSpec())), metrics, this.dataSegmentPusher, this.objectMapper, this.indexIO, this.indexMerger, this.conglomerate, this.segmentAnnouncer, this.emitter, this.queryExecutorService, this.cache, this.cacheConfig);
    }

    private static File makeBasePersistSubdirectory(File basePersistDirectory, String dataSource, ShardSpec shardSpec) {
        File dataSourceDirectory = new File(basePersistDirectory, dataSource);
        return new File(dataSourceDirectory, String.valueOf(shardSpec.getPartitionNum()));
    }
}

