/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.metamx.common.IAE;
import com.metamx.common.logger.Logger;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.indexing.granularity.UniformGranularitySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DataSchema {
    private static final Logger log = new Logger(DataSchema.class);
    private final String dataSource;
    private final Map<String, Object> parser;
    private final AggregatorFactory[] aggregators;
    private final GranularitySpec granularitySpec;
    private final ObjectMapper jsonMapper;

    @JsonCreator
    public DataSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="parser") Map<String, Object> parser, @JsonProperty(value="metricsSpec") AggregatorFactory[] aggregators, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JacksonInject ObjectMapper jsonMapper) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"null ObjectMapper.");
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource cannot be null. Please provide a dataSource.");
        this.parser = parser;
        if (aggregators.length == 0) {
            log.warn("No metricsSpec has been specified. Are you sure this is what you want?", new Object[0]);
        }
        this.aggregators = aggregators;
        if (granularitySpec == null) {
            log.warn("No granularitySpec has been specified. Using UniformGranularitySpec as default.", new Object[0]);
            this.granularitySpec = new UniformGranularitySpec(null, null, null);
        } else {
            this.granularitySpec = granularitySpec;
        }
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="parser")
    public Map<String, Object> getParserMap() {
        return this.parser;
    }

    @JsonIgnore
    public InputRowParser getParser() {
        if (this.parser == null) {
            log.warn("No parser has been specified", new Object[0]);
            return null;
        }
        InputRowParser inputRowParser = (InputRowParser)this.jsonMapper.convertValue(this.parser, InputRowParser.class);
        HashSet dimensionExclusions = Sets.newHashSet();
        for (AggregatorFactory aggregatorFactory : this.aggregators) {
            dimensionExclusions.addAll(aggregatorFactory.requiredFields());
            dimensionExclusions.add(aggregatorFactory.getName());
        }
        if (inputRowParser.getParseSpec() != null) {
            DimensionsSpec dimensionsSpec = inputRowParser.getParseSpec().getDimensionsSpec();
            TimestampSpec timestampSpec = inputRowParser.getParseSpec().getTimestampSpec();
            if (timestampSpec != null) {
                String timestampColumn = timestampSpec.getTimestampColumn();
                if (!dimensionsSpec.hasCustomDimensions() || !dimensionsSpec.getDimensionNames().contains(timestampColumn)) {
                    dimensionExclusions.add(timestampColumn);
                }
            }
            if (dimensionsSpec != null) {
                HashSet metSet = Sets.newHashSet();
                for (AggregatorFactory aggregator : this.aggregators) {
                    metSet.add(aggregator.getName());
                }
                HashSet hashSet = Sets.newHashSet((Iterable)dimensionsSpec.getDimensionNames());
                Sets.SetView overlap = Sets.intersection((Set)metSet, (Set)hashSet);
                if (!overlap.isEmpty()) {
                    throw new IAE("Cannot have overlapping dimensions and metrics of the same name. Please change the name of the metric. Overlap: %s", new Object[]{overlap});
                }
                return inputRowParser.withParseSpec(inputRowParser.getParseSpec().withDimensionsSpec(dimensionsSpec.withDimensionExclusions((Set)Sets.difference((Set)dimensionExclusions, (Set)hashSet))));
            }
            return inputRowParser;
        }
        log.warn("No parseSpec in parser has been specified.", new Object[0]);
        return inputRowParser;
    }

    @JsonProperty(value="metricsSpec")
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    public DataSchema withGranularitySpec(GranularitySpec granularitySpec) {
        return new DataSchema(this.dataSource, this.parser, this.aggregators, granularitySpec, this.jsonMapper);
    }

    public String toString() {
        return "DataSchema{dataSource='" + this.dataSource + '\'' + ", parser=" + this.parser + ", aggregators=" + Arrays.toString(this.aggregators) + ", granularitySpec=" + this.granularitySpec + '}';
    }
}

