/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata.storage.derby;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

public class DerbyConnector
extends SQLMetadataConnector {
    private static final Logger log = new Logger(DerbyConnector.class);
    private static final String SERIAL_TYPE = "BIGINT GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)";
    private final DBI dbi;

    @Inject
    public DerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables) {
        super(config, dbTables);
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(this.getClass().getClassLoader());
        datasource.setDriverClassName("org.apache.derby.jdbc.ClientDriver");
        this.dbi = new DBI((DataSource)datasource);
        log.info("Configured Derby as metadata storage", new Object[0]);
    }

    public DerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, DBI dbi) {
        super(config, dbTables);
        this.dbi = dbi;
    }

    @Override
    public boolean tableExists(Handle handle, String tableName) {
        return !((Query)handle.createQuery("select * from SYS.SYSTABLES where tablename = :tableName").bind("tableName", tableName.toUpperCase())).list().isEmpty();
    }

    @Override
    protected String getSerialType() {
        return SERIAL_TYPE;
    }

    @Override
    public DBI getDBI() {
        return this.dbi;
    }

    @Override
    protected int getStreamingFetchSize() {
        return 1;
    }

    @Override
    public String getValidationQuery() {
        return "VALUES 1";
    }
}

