/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.timeline.DataSegment;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class DruidDataSource {
    private final Object lock = new Object();
    private final String name;
    private final Map<String, String> properties;
    private final Map<String, DataSegment> partitionNames;
    private final ConcurrentSkipListSet<DataSegment> segmentsHolder;

    public DruidDataSource(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
        this.partitionNames = Maps.newHashMap();
        this.segmentsHolder = new ConcurrentSkipListSet();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return Collections.unmodifiableSet(this.segmentsHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidDataSource addSegment(String partitionName, DataSegment dataSegment) {
        Object object = this.lock;
        synchronized (object) {
            this.partitionNames.put(partitionName, dataSegment);
            this.segmentsHolder.add(dataSegment);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidDataSource addSegments(Map<String, DataSegment> partitionMap) {
        Object object = this.lock;
        synchronized (object) {
            this.partitionNames.putAll(partitionMap);
            this.segmentsHolder.addAll(partitionMap.values());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidDataSource removePartition(String partitionName) {
        Object object = this.lock;
        synchronized (object) {
            DataSegment dataPart = this.partitionNames.remove(partitionName);
            if (dataPart == null) {
                return this;
            }
            this.segmentsHolder.remove(dataPart);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.segmentsHolder.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return "DruidDataSource{properties=" + this.properties + ", partitions=" + this.segmentsHolder.toString() + '}';
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableDruidDataSource toImmutableDruidDataSource() {
        Object object = this.lock;
        synchronized (object) {
            return new ImmutableDruidDataSource(this.name, (ImmutableMap<String, String>)ImmutableMap.copyOf(this.properties), (ImmutableMap<String, DataSegment>)ImmutableMap.copyOf(this.partitionNames), (ImmutableSet<DataSegment>)ImmutableSet.copyOf(this.segmentsHolder));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidDataSource that = (DruidDataSource)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.partitionNames != null ? !this.partitionNames.equals(that.partitionNames) : that.partitionNames != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.segmentsHolder != null ? !this.segmentsHolder.equals(that.segmentsHolder) : that.segmentsHolder != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.partitionNames != null ? this.partitionNames.hashCode() : 0);
        result = 31 * result + (this.segmentsHolder != null ? this.segmentsHolder.hashCode() : 0);
        return result;
    }
}

