/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.granularity.QueryGranularity;
import io.druid.query.QueryInterruptedException;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BooleanFilter;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.RowOffsetMatcherFactory;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.BitmapOffset;
import io.druid.segment.Capabilities;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorBitmapIndexSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionHandler;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.Metadata;
import io.druid.segment.NullDimensionSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.QueryableIndex;
import io.druid.segment.SingleScanTimeDimSelector;
import io.druid.segment.StorageAdapter;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ComplexColumn;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.Offset;
import io.druid.segment.filter.AndFilter;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.filter.Filters;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.roaringbitmap.IntIterator;

public class QueryableIndexStorageAdapter
implements StorageAdapter {
    private static final NullDimensionSelector NULL_DIMENSION_SELECTOR = new NullDimensionSelector();
    private final QueryableIndex index;

    public QueryableIndexStorageAdapter(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.index.getAvailableDimensions();
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return Sets.difference((Set)Sets.newHashSet(this.index.getColumnNames()), (Set)Sets.newHashSet(this.index.getAvailableDimensions()));
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        if (dimension == null) {
            return 0;
        }
        Column column = this.index.getColumn(dimension);
        if (column == null) {
            return 0;
        }
        if (!column.getCapabilities().isDictionaryEncoded()) {
            return Integer.MAX_VALUE;
        }
        return column.getDictionaryEncoding().getCardinality();
    }

    @Override
    public int getNumRows() {
        return this.index.getNumRows();
    }

    @Override
    public DateTime getMinTime() {
        try (GenericColumn column = this.index.getColumn("__time").getGenericColumn();){
            DateTime dateTime = new DateTime(column.getLongSingleValueRow(0));
            return dateTime;
        }
    }

    @Override
    public DateTime getMaxTime() {
        try (GenericColumn column = this.index.getColumn("__time").getGenericColumn();){
            DateTime dateTime = new DateTime(column.getLongSingleValueRow(column.length() - 1));
            return dateTime;
        }
    }

    @Override
    public Comparable getMinValue(String dimension) {
        Column column = this.index.getColumn(dimension);
        if (column != null && column.getCapabilities().hasBitmapIndexes()) {
            BitmapIndex bitmap = column.getBitmapIndex();
            return bitmap.getCardinality() > 0 ? bitmap.getValue(0) : null;
        }
        return null;
    }

    @Override
    public Comparable getMaxValue(String dimension) {
        Column column = this.index.getColumn(dimension);
        if (column != null && column.getCapabilities().hasBitmapIndexes()) {
            BitmapIndex bitmap = column.getBitmapIndex();
            return bitmap.getCardinality() > 0 ? bitmap.getValue(bitmap.getCardinality() - 1) : null;
        }
        return null;
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(true).build();
    }

    @Override
    public ColumnCapabilities getColumnCapabilities(String column) {
        return QueryableIndexStorageAdapter.getColumnCapabilites(this.index, column);
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return this.index.getDimensionHandlers();
    }

    @Override
    public String getColumnTypeName(String columnName) {
        Column column = this.index.getColumn(columnName);
        try (ComplexColumn complexColumn = column.getComplexColumn();){
            String string = complexColumn != null ? complexColumn.getTypeName() : column.getCapabilities().getType().toString();
            return string;
        }
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.getMaxTime();
    }

    @Override
    public Sequence<Cursor> makeCursors(Filter filter, Interval interval, QueryGranularity gran, boolean descending) {
        Offset offset;
        long maxDataTimestamp;
        Interval actualInterval = interval;
        long minDataTimestamp = this.getMinTime().getMillis();
        Interval dataInterval = new Interval(minDataTimestamp, gran.next(gran.truncate(maxDataTimestamp = this.getMaxTime().getMillis())));
        if (!actualInterval.overlaps((ReadableInterval)dataInterval)) {
            return Sequences.empty();
        }
        if (actualInterval.getStart().isBefore((ReadableInstant)dataInterval.getStart())) {
            actualInterval = actualInterval.withStart((ReadableInstant)dataInterval.getStart());
        }
        if (actualInterval.getEnd().isAfter((ReadableInstant)dataInterval.getEnd())) {
            actualInterval = actualInterval.withEnd((ReadableInstant)dataInterval.getEnd());
        }
        ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(this.index.getBitmapFactoryForDimensions(), this.index);
        ArrayList<Filter> postFilters = new ArrayList<Filter>();
        if (filter == null) {
            offset = new NoFilterOffset(0, this.index.getNumRows(), descending);
        } else {
            ArrayList<Filter> preFilters = new ArrayList<Filter>();
            if (filter instanceof AndFilter) {
                for (Filter subfilter : ((AndFilter)filter).getFilters()) {
                    if (subfilter.supportsBitmapIndex(selector)) {
                        preFilters.add(subfilter);
                        continue;
                    }
                    postFilters.add(subfilter);
                }
            } else if (filter.supportsBitmapIndex(selector)) {
                preFilters.add(filter);
            } else {
                postFilters.add(filter);
            }
            if (preFilters.size() == 0) {
                offset = new NoFilterOffset(0, this.index.getNumRows(), descending);
            } else {
                ArrayList bitmaps = Lists.newArrayList();
                for (Filter prefilter : preFilters) {
                    bitmaps.add(prefilter.getBitmapIndex(selector));
                }
                offset = new BitmapOffset(selector.getBitmapFactory(), selector.getBitmapFactory().intersection((Iterable)bitmaps), descending);
            }
        }
        Filter postFilter = postFilters.size() == 0 ? null : (postFilters.size() == 1 ? (Filter)postFilters.get(0) : new AndFilter(postFilters));
        return Sequences.filter(new CursorSequenceBuilder(this.index, actualInterval, gran, offset, minDataTimestamp, maxDataTimestamp, descending, postFilter, selector).build(), (Predicate)Predicates.notNull());
    }

    private static ColumnCapabilities getColumnCapabilites(ColumnSelector index, String columnName) {
        Column columnObj = index.getColumn(columnName);
        if (columnObj == null) {
            return null;
        }
        return columnObj.getCapabilities();
    }

    private static boolean isComparableNullOrEmpty(Comparable value) {
        if (value instanceof String) {
            return Strings.isNullOrEmpty((String)((String)((Object)value)));
        }
        return value == null;
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    private static class NoFilterOffset
    implements Offset {
        private final int rowCount;
        private final boolean descending;
        private volatile int currentOffset;

        NoFilterOffset(int currentOffset, int rowCount, boolean descending) {
            this.currentOffset = currentOffset;
            this.rowCount = rowCount;
            this.descending = descending;
        }

        @Override
        public void increment() {
            ++this.currentOffset;
        }

        @Override
        public boolean withinBounds() {
            return this.currentOffset < this.rowCount;
        }

        @Override
        public Offset clone() {
            return new NoFilterOffset(this.currentOffset, this.rowCount, this.descending);
        }

        @Override
        public int getOffset() {
            return this.descending ? this.rowCount - this.currentOffset - 1 : this.currentOffset;
        }

        public String toString() {
            return this.currentOffset + "/" + this.rowCount + (this.descending ? "(DSC)" : "");
        }
    }

    private static class DescendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        public DescendingTimestampCheckingOffset(Offset baseOffset, GenericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current >= this.timeLimit;
        }

        public String toString() {
            return this.timeLimit + ">=" + (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new DescendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    private static class AscendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        public AscendingTimestampCheckingOffset(Offset baseOffset, GenericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current < this.timeLimit;
        }

        public String toString() {
            return (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "<" + this.timeLimit + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new AscendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    private static abstract class TimestampCheckingOffset
    implements Offset {
        protected final Offset baseOffset;
        protected final GenericColumn timestamps;
        protected final long timeLimit;
        protected final boolean allWithinThreshold;

        public TimestampCheckingOffset(Offset baseOffset, GenericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            this.baseOffset = baseOffset;
            this.timestamps = timestamps;
            this.timeLimit = timeLimit;
            this.allWithinThreshold = allWithinThreshold;
        }

        @Override
        public int getOffset() {
            return this.baseOffset.getOffset();
        }

        @Override
        public boolean withinBounds() {
            if (!this.baseOffset.withinBounds()) {
                return false;
            }
            if (this.allWithinThreshold) {
                return true;
            }
            return this.timeInRange(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset()));
        }

        protected abstract boolean timeInRange(long var1);

        @Override
        public void increment() {
            this.baseOffset.increment();
        }

        @Override
        public Offset clone() {
            throw new IllegalStateException("clone");
        }
    }

    private static class CursorOffsetHolderRowOffsetMatcherFactory
    implements RowOffsetMatcherFactory {
        private final CursorOffsetHolder holder;
        private final boolean descending;

        public CursorOffsetHolderRowOffsetMatcherFactory(CursorOffsetHolder holder, boolean descending) {
            this.holder = holder;
            this.descending = descending;
        }

        @Override
        public ValueMatcher makeRowOffsetMatcher(ImmutableBitmap rowBitmap) {
            IntIterator iter;
            IntIterator intIterator = iter = this.descending ? BitmapOffset.getReverseBitmapOffsetIterator(rowBitmap) : rowBitmap.iterator();
            if (!iter.hasNext()) {
                return new BooleanValueMatcher(false);
            }
            if (this.descending) {
                return new ValueMatcher(){
                    int iterOffset = Integer.MAX_VALUE;

                    @Override
                    public boolean matches() {
                        int currentOffset = CursorOffsetHolderRowOffsetMatcherFactory.this.holder.get().getOffset();
                        while (this.iterOffset > currentOffset && iter.hasNext()) {
                            this.iterOffset = iter.next();
                        }
                        return this.iterOffset == currentOffset;
                    }
                };
            }
            return new ValueMatcher(){
                int iterOffset = -1;

                @Override
                public boolean matches() {
                    int currentOffset = CursorOffsetHolderRowOffsetMatcherFactory.this.holder.get().getOffset();
                    while (this.iterOffset < currentOffset && iter.hasNext()) {
                        this.iterOffset = iter.next();
                    }
                    return this.iterOffset == currentOffset;
                }
            };
        }
    }

    private static class CursorOffsetHolderValueMatcherFactory
    implements ValueMatcherFactory {
        private final ColumnSelector index;
        private final ColumnSelectorFactory cursor;

        public CursorOffsetHolderValueMatcherFactory(ColumnSelector index, ColumnSelectorFactory cursor) {
            this.index = index;
            this.cursor = cursor;
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, Comparable value) {
            if (this.getTypeForDimension(dimension) == ValueType.LONG) {
                return Filters.getLongValueMatcher(this.cursor.makeLongColumnSelector(dimension), value);
            }
            final DimensionSelector selector = this.cursor.makeDimensionSelector(new DefaultDimensionSpec(dimension, dimension));
            final boolean matchNull = QueryableIndexStorageAdapter.isComparableNullOrEmpty(value);
            final int id = selector.lookupId((String)((Object)value));
            if (id < 0) {
                return new BooleanValueMatcher(false);
            }
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    IndexedInts row = selector.getRow();
                    if (row.size() == 0) {
                        return matchNull;
                    }
                    for (int i = 0; i < row.size(); ++i) {
                        if (row.get(i) != id) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, DruidPredicateFactory predicateFactory) {
            ValueType type = this.getTypeForDimension(dimension);
            switch (type) {
                case LONG: {
                    return this.makeLongValueMatcher(dimension, predicateFactory.makeLongPredicate());
                }
                case STRING: {
                    return this.makeStringValueMatcher(dimension, predicateFactory.makeStringPredicate());
                }
            }
            return new BooleanValueMatcher(predicateFactory.makeStringPredicate().apply(null));
        }

        private ValueMatcher makeStringValueMatcher(String dimension, final Predicate<String> predicate) {
            final DimensionSelector selector = this.cursor.makeDimensionSelector(new DefaultDimensionSpec(dimension, dimension));
            return new ValueMatcher(){
                final boolean matchNull;
                {
                    this.matchNull = predicate.apply(null);
                }

                @Override
                public boolean matches() {
                    IndexedInts row = selector.getRow();
                    if (row.size() == 0) {
                        return this.matchNull;
                    }
                    for (int i = 0; i < row.size(); ++i) {
                        if (!predicate.apply((Object)selector.lookupName(row.get(i)))) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        private ValueMatcher makeLongValueMatcher(String dimension, DruidLongPredicate predicate) {
            return Filters.getLongPredicateMatcher(this.cursor.makeLongColumnSelector(dimension), predicate);
        }

        private ValueType getTypeForDimension(String dimension) {
            ColumnCapabilities capabilities = QueryableIndexStorageAdapter.getColumnCapabilites(this.index, dimension);
            return capabilities == null ? ValueType.STRING : capabilities.getType();
        }
    }

    public static class CursorOffsetHolder {
        Offset currOffset = null;

        public Offset get() {
            return this.currOffset;
        }

        public void set(Offset currOffset) {
            this.currOffset = currOffset;
        }
    }

    private static class CursorSequenceBuilder {
        private final ColumnSelector index;
        private final Interval interval;
        private final QueryGranularity gran;
        private final Offset offset;
        private final long minDataTimestamp;
        private final long maxDataTimestamp;
        private final boolean descending;
        private final Filter postFilter;
        private final ColumnSelectorBitmapIndexSelector bitmapIndexSelector;

        public CursorSequenceBuilder(ColumnSelector index, Interval interval, QueryGranularity gran, Offset offset, long minDataTimestamp, long maxDataTimestamp, boolean descending, Filter postFilter, ColumnSelectorBitmapIndexSelector bitmapIndexSelector) {
            this.index = index;
            this.interval = interval;
            this.gran = gran;
            this.offset = offset;
            this.minDataTimestamp = minDataTimestamp;
            this.maxDataTimestamp = maxDataTimestamp;
            this.descending = descending;
            this.postFilter = postFilter;
            this.bitmapIndexSelector = bitmapIndexSelector;
        }

        public Sequence<Cursor> build() {
            final Offset baseOffset = this.offset.clone();
            final HashMap dictionaryColumnCache = Maps.newHashMap();
            final HashMap genericColumnCache = Maps.newHashMap();
            final HashMap objectColumnCache = Maps.newHashMap();
            final GenericColumn timestamps = this.index.getColumn("__time").getGenericColumn();
            final Closer closer = Closer.create();
            closer.register((Closeable)timestamps);
            List iterable = this.gran.iterable(this.interval.getStartMillis(), this.interval.getEndMillis());
            if (this.descending) {
                iterable = Lists.reverse((List)ImmutableList.copyOf(iterable));
            }
            return Sequences.withBaggage((Sequence)Sequences.map((Sequence)Sequences.simple(iterable), (Function)new Function<Long, Cursor>(){

                public Cursor apply(Long input) {
                    abstract class QueryableIndexBaseCursor
                    implements Cursor {
                        Offset cursorOffset;

                        QueryableIndexBaseCursor() {
                        }

                        @Override
                        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                            return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
                        }

                        private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
                            DictionaryEncodedColumn column;
                            String dimension = dimensionSpec.getDimension();
                            final ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
                            Column columnDesc = CursorSequenceBuilder.this.index.getColumn(dimension);
                            if (columnDesc == null) {
                                return NULL_DIMENSION_SELECTOR;
                            }
                            if (dimension.equals("__time")) {
                                return new SingleScanTimeDimSelector(this.makeLongColumnSelector(dimension), extractionFn, CursorSequenceBuilder.this.descending);
                            }
                            DictionaryEncodedColumn cachedColumn = (DictionaryEncodedColumn)dictionaryColumnCache.get(dimension);
                            if (cachedColumn == null) {
                                cachedColumn = columnDesc.getDictionaryEncoding();
                                closer.register((Closeable)cachedColumn);
                                dictionaryColumnCache.put(dimension, cachedColumn);
                            }
                            if ((column = cachedColumn) == null) {
                                return NULL_DIMENSION_SELECTOR;
                            }
                            if (columnDesc.getCapabilities().hasMultipleValues()) {
                                return new DimensionSelector(){

                                    @Override
                                    public IndexedInts getRow() {
                                        return column.getMultiValueRow(cursorOffset.getOffset());
                                    }

                                    @Override
                                    public int getValueCardinality() {
                                        return column.getCardinality();
                                    }

                                    @Override
                                    public String lookupName(int id) {
                                        String value = (String)column.lookupName(id);
                                        return extractionFn == null ? value : extractionFn.apply(value);
                                    }

                                    @Override
                                    public int lookupId(String name) {
                                        if (extractionFn != null) {
                                            throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                                        }
                                        return column.lookupId(name);
                                    }
                                };
                            }
                            return new DimensionSelector(){

                                @Override
                                public IndexedInts getRow() {
                                    return new IndexedInts(){

                                        @Override
                                        public int size() {
                                            return 1;
                                        }

                                        @Override
                                        public int get(int index) {
                                            return column.getSingleValueRow(cursorOffset.getOffset());
                                        }

                                        @Override
                                        public Iterator<Integer> iterator() {
                                            return Iterators.singletonIterator((Object)column.getSingleValueRow(cursorOffset.getOffset()));
                                        }

                                        @Override
                                        public void fill(int index, int[] toFill) {
                                            throw new UnsupportedOperationException("fill not supported");
                                        }

                                        @Override
                                        public void close() throws IOException {
                                        }
                                    };
                                }

                                @Override
                                public int getValueCardinality() {
                                    return column.getCardinality();
                                }

                                @Override
                                public String lookupName(int id) {
                                    String value = (String)column.lookupName(id);
                                    return extractionFn == null ? value : extractionFn.apply(value);
                                }

                                @Override
                                public int lookupId(String name) {
                                    if (extractionFn != null) {
                                        throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                                    }
                                    return column.lookupId(name);
                                }
                            };
                        }

                        @Override
                        public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                            Column holder;
                            GenericColumn cachedMetricVals = (GenericColumn)genericColumnCache.get(columnName);
                            if (cachedMetricVals == null && (holder = CursorSequenceBuilder.this.index.getColumn(columnName)) != null && (holder.getCapabilities().getType() == ValueType.FLOAT || holder.getCapabilities().getType() == ValueType.LONG)) {
                                cachedMetricVals = holder.getGenericColumn();
                                closer.register((Closeable)cachedMetricVals);
                                genericColumnCache.put(columnName, cachedMetricVals);
                            }
                            if (cachedMetricVals == null) {
                                return new FloatColumnSelector(){

                                    @Override
                                    public float get() {
                                        return 0.0f;
                                    }
                                };
                            }
                            final GenericColumn metricVals = cachedMetricVals;
                            return new FloatColumnSelector(){

                                @Override
                                public float get() {
                                    return metricVals.getFloatSingleValueRow(cursorOffset.getOffset());
                                }
                            };
                        }

                        @Override
                        public LongColumnSelector makeLongColumnSelector(String columnName) {
                            Column holder;
                            GenericColumn cachedMetricVals = (GenericColumn)genericColumnCache.get(columnName);
                            if (cachedMetricVals == null && (holder = CursorSequenceBuilder.this.index.getColumn(columnName)) != null && (holder.getCapabilities().getType() == ValueType.LONG || holder.getCapabilities().getType() == ValueType.FLOAT)) {
                                cachedMetricVals = holder.getGenericColumn();
                                closer.register((Closeable)cachedMetricVals);
                                genericColumnCache.put(columnName, cachedMetricVals);
                            }
                            if (cachedMetricVals == null) {
                                return new LongColumnSelector(){

                                    @Override
                                    public long get() {
                                        return 0L;
                                    }
                                };
                            }
                            final GenericColumn metricVals = cachedMetricVals;
                            return new LongColumnSelector(){

                                @Override
                                public long get() {
                                    return metricVals.getLongSingleValueRow(cursorOffset.getOffset());
                                }
                            };
                        }

                        @Override
                        public ObjectColumnSelector makeObjectColumnSelector(String column) {
                            Closeable columnVals;
                            Object cachedColumnVals = objectColumnCache.get(column);
                            if (cachedColumnVals == null) {
                                Column holder = CursorSequenceBuilder.this.index.getColumn(column);
                                if (holder != null) {
                                    ColumnCapabilities capabilities = holder.getCapabilities();
                                    cachedColumnVals = capabilities.isDictionaryEncoded() ? holder.getDictionaryEncoding() : (capabilities.getType() == ValueType.COMPLEX ? holder.getComplexColumn() : holder.getGenericColumn());
                                }
                                if (cachedColumnVals != null) {
                                    closer.register((Closeable)cachedColumnVals);
                                    objectColumnCache.put(column, cachedColumnVals);
                                }
                            }
                            if (cachedColumnVals == null) {
                                return null;
                            }
                            if (cachedColumnVals instanceof GenericColumn) {
                                columnVals = (GenericColumn)cachedColumnVals;
                                ValueType type = columnVals.getType();
                                if (columnVals.hasMultipleValues()) {
                                    throw new UnsupportedOperationException("makeObjectColumnSelector does not support multi-value GenericColumns");
                                }
                                if (type == ValueType.FLOAT) {
                                    return new ObjectColumnSelector<Float>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Float.TYPE;
                                        }

                                        @Override
                                        public Float get() {
                                            return Float.valueOf(this.val$columnVals.getFloatSingleValueRow(cursorOffset.getOffset()));
                                        }
                                    };
                                }
                                if (type == ValueType.LONG) {
                                    return new ObjectColumnSelector<Long>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Long.TYPE;
                                        }

                                        @Override
                                        public Long get() {
                                            return this.val$columnVals.getLongSingleValueRow(cursorOffset.getOffset());
                                        }
                                    };
                                }
                                if (type == ValueType.STRING) {
                                    return new ObjectColumnSelector<String>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return String.class;
                                        }

                                        @Override
                                        public String get() {
                                            return this.val$columnVals.getStringSingleValueRow(cursorOffset.getOffset());
                                        }
                                    };
                                }
                            }
                            if (cachedColumnVals instanceof DictionaryEncodedColumn) {
                                columnVals = (DictionaryEncodedColumn)cachedColumnVals;
                                if (columnVals.hasMultipleValues()) {
                                    return new ObjectColumnSelector<Object>((DictionaryEncodedColumn)columnVals){
                                        final /* synthetic */ DictionaryEncodedColumn val$columnVals;
                                        {
                                            this.val$columnVals = dictionaryEncodedColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Object.class;
                                        }

                                        @Override
                                        public Object get() {
                                            IndexedInts multiValueRow = this.val$columnVals.getMultiValueRow(cursorOffset.getOffset());
                                            if (multiValueRow.size() == 0) {
                                                return null;
                                            }
                                            if (multiValueRow.size() == 1) {
                                                return this.val$columnVals.lookupName(multiValueRow.get(0));
                                            }
                                            String[] strings = new String[multiValueRow.size()];
                                            for (int i = 0; i < multiValueRow.size(); ++i) {
                                                strings[i] = (String)this.val$columnVals.lookupName(multiValueRow.get(i));
                                            }
                                            return strings;
                                        }
                                    };
                                }
                                return new ObjectColumnSelector<String>((DictionaryEncodedColumn)columnVals){
                                    final /* synthetic */ DictionaryEncodedColumn val$columnVals;
                                    {
                                        this.val$columnVals = dictionaryEncodedColumn;
                                    }

                                    @Override
                                    public Class classOfObject() {
                                        return String.class;
                                    }

                                    @Override
                                    public String get() {
                                        return (String)this.val$columnVals.lookupName(this.val$columnVals.getSingleValueRow(cursorOffset.getOffset()));
                                    }
                                };
                            }
                            columnVals = (ComplexColumn)cachedColumnVals;
                            return new ObjectColumnSelector((ComplexColumn)columnVals){
                                final /* synthetic */ ComplexColumn val$columnVals;
                                {
                                    this.val$columnVals = complexColumn;
                                }

                                public Class classOfObject() {
                                    return this.val$columnVals.getClazz();
                                }

                                public Object get() {
                                    return this.val$columnVals.getRowValue(cursorOffset.getOffset());
                                }
                            };
                        }

                        @Override
                        public ColumnCapabilities getColumnCapabilities(String columnName) {
                            return QueryableIndexStorageAdapter.getColumnCapabilites(CursorSequenceBuilder.this.index, columnName);
                        }
                    }
                    long timeStart = Math.max(CursorSequenceBuilder.this.interval.getStartMillis(), input);
                    long timeEnd = Math.min(CursorSequenceBuilder.this.interval.getEndMillis(), CursorSequenceBuilder.this.gran.next(input));
                    if (CursorSequenceBuilder.this.descending) {
                        while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) >= timeEnd) {
                            baseOffset.increment();
                        }
                    } else {
                        while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) < timeStart) {
                            baseOffset.increment();
                        }
                    }
                    TimestampCheckingOffset offset = CursorSequenceBuilder.this.descending ? new DescendingTimestampCheckingOffset(baseOffset, timestamps, timeStart, CursorSequenceBuilder.this.minDataTimestamp >= timeStart) : new AscendingTimestampCheckingOffset(baseOffset, timestamps, timeEnd, CursorSequenceBuilder.this.maxDataTimestamp < timeEnd);
                    final Offset initOffset = offset.clone();
                    final DateTime myBucket = CursorSequenceBuilder.this.gran.toDateTime(input);
                    final CursorOffsetHolder cursorOffsetHolder = new CursorOffsetHolder();
                    if (CursorSequenceBuilder.this.postFilter == null) {
                        return new QueryableIndexBaseCursor(){
                            {
                                this.reset();
                            }

                            @Override
                            public DateTime getTime() {
                                return myBucket;
                            }

                            @Override
                            public void advance() {
                                if (Thread.interrupted()) {
                                    throw new QueryInterruptedException(new InterruptedException());
                                }
                                this.cursorOffset.increment();
                            }

                            @Override
                            public void advanceTo(int offset) {
                                for (int count = 0; count < offset && !this.isDone(); ++count) {
                                    this.advance();
                                }
                            }

                            @Override
                            public boolean isDone() {
                                return !this.cursorOffset.withinBounds();
                            }

                            @Override
                            public void reset() {
                                this.cursorOffset = initOffset.clone();
                                cursorOffsetHolder.set(this.cursorOffset);
                            }
                        };
                    }
                    return new QueryableIndexBaseCursor(){
                        CursorOffsetHolderValueMatcherFactory valueMatcherFactory;
                        RowOffsetMatcherFactory rowOffsetMatcherFactory;
                        final ValueMatcher filterMatcher;
                        {
                            this.valueMatcherFactory = new CursorOffsetHolderValueMatcherFactory(CursorSequenceBuilder.this.index, this);
                            this.rowOffsetMatcherFactory = new CursorOffsetHolderRowOffsetMatcherFactory(cursorOffsetHolder, CursorSequenceBuilder.this.descending);
                            this.filterMatcher = CursorSequenceBuilder.this.postFilter instanceof BooleanFilter ? ((BooleanFilter)CursorSequenceBuilder.this.postFilter).makeMatcher(CursorSequenceBuilder.this.bitmapIndexSelector, this.valueMatcherFactory, this.rowOffsetMatcherFactory) : (CursorSequenceBuilder.this.postFilter.supportsBitmapIndex(CursorSequenceBuilder.this.bitmapIndexSelector) ? this.rowOffsetMatcherFactory.makeRowOffsetMatcher(CursorSequenceBuilder.this.postFilter.getBitmapIndex(CursorSequenceBuilder.this.bitmapIndexSelector)) : CursorSequenceBuilder.this.postFilter.makeMatcher(this.valueMatcherFactory));
                            this.reset();
                        }

                        @Override
                        public DateTime getTime() {
                            return myBucket;
                        }

                        @Override
                        public void advance() {
                            if (Thread.interrupted()) {
                                throw new QueryInterruptedException(new InterruptedException());
                            }
                            this.cursorOffset.increment();
                            while (!this.isDone()) {
                                if (Thread.interrupted()) {
                                    throw new QueryInterruptedException(new InterruptedException());
                                }
                                if (this.filterMatcher.matches()) {
                                    return;
                                }
                                this.cursorOffset.increment();
                            }
                        }

                        @Override
                        public void advanceTo(int offset) {
                            for (int count = 0; count < offset && !this.isDone(); ++count) {
                                this.advance();
                            }
                        }

                        @Override
                        public boolean isDone() {
                            return !this.cursorOffset.withinBounds();
                        }

                        @Override
                        public void reset() {
                            this.cursorOffset = initOffset.clone();
                            cursorOffsetHolder.set(this.cursorOffset);
                            if (!this.isDone()) {
                                if (this.filterMatcher.matches()) {
                                    return;
                                }
                                this.advance();
                            }
                        }
                    };
                }
            }), (Closeable)closer);
        }
    }

    private static interface CursorAdvancer {
        public void advance();

        public void advanceTo(int var1);

        public boolean isDone();

        public void reset();
    }
}

