/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.lookup.LookupExtractionFn;
import io.druid.query.lookup.LookupExtractor;
import io.druid.query.lookup.LookupExtractorFactory;
import io.druid.query.lookup.LookupReferencesManager;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class RegisteredLookupExtractionFn
implements ExtractionFn {
    private volatile LookupExtractionFn delegate = null;
    private final Object delegateLock = new Object();
    private final LookupReferencesManager manager;
    private final String lookup;
    private final boolean retainMissingValue;
    private final String replaceMissingValueWith;
    private final boolean injective;
    private final boolean optimize;

    @JsonCreator
    public RegisteredLookupExtractionFn(@JacksonInject LookupReferencesManager manager, @JsonProperty(value="lookup") String lookup, @JsonProperty(value="retainMissingValue") boolean retainMissingValue, @Nullable @JsonProperty(value="replaceMissingValueWith") String replaceMissingValueWith, @JsonProperty(value="injective") boolean injective, @JsonProperty(value="optimize") Boolean optimize) {
        Preconditions.checkArgument((lookup != null ? 1 : 0) != 0, (Object)"`lookup` required");
        this.manager = manager;
        this.replaceMissingValueWith = replaceMissingValueWith;
        this.retainMissingValue = retainMissingValue;
        this.injective = injective;
        this.optimize = optimize == null ? true : optimize;
        this.lookup = lookup;
    }

    @JsonProperty(value="lookup")
    public String getLookup() {
        return this.lookup;
    }

    @JsonProperty(value="retainMissingValue")
    public boolean isRetainMissingValue() {
        return this.retainMissingValue;
    }

    @JsonProperty(value="replaceMissingValueWith")
    public String getReplaceMissingValueWith() {
        return this.replaceMissingValueWith;
    }

    @JsonProperty(value="injective")
    public boolean isInjective() {
        return this.injective;
    }

    @JsonProperty(value="optimize")
    public boolean isOptimize() {
        return this.optimize;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] keyPrefix = StringUtils.toUtf8((String)this.getClass().getCanonicalName());
        byte[] lookupName = StringUtils.toUtf8((String)this.getLookup());
        byte[] delegateKey = this.ensureDelegate().getCacheKey();
        return ByteBuffer.allocate(keyPrefix.length + 1 + lookupName.length + 1 + delegateKey.length).put(keyPrefix).put((byte)-1).put(lookupName).put((byte)-1).put(delegateKey).array();
    }

    @Override
    public String apply(Object value) {
        return this.ensureDelegate().apply(value);
    }

    @Override
    public String apply(String value) {
        return this.ensureDelegate().apply(value);
    }

    @Override
    public String apply(long value) {
        return this.ensureDelegate().apply(value);
    }

    @Override
    public boolean preservesOrdering() {
        return this.ensureDelegate().preservesOrdering();
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.ensureDelegate().getExtractionType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LookupExtractionFn ensureDelegate() {
        if (null == this.delegate) {
            Object object = this.delegateLock;
            synchronized (object) {
                if (null == this.delegate) {
                    this.delegate = new LookupExtractionFn((LookupExtractor)((LookupExtractorFactory)Preconditions.checkNotNull((Object)this.manager.get(this.getLookup()), (String)"Lookup [%s] not found", (Object[])new Object[]{this.getLookup()})).get(), this.isRetainMissingValue(), this.getReplaceMissingValueWith(), this.isInjective(), this.isOptimize());
                }
            }
        }
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredLookupExtractionFn that = (RegisteredLookupExtractionFn)o;
        if (this.isRetainMissingValue() != that.isRetainMissingValue()) {
            return false;
        }
        if (this.isInjective() != that.isInjective()) {
            return false;
        }
        if (this.isOptimize() != that.isOptimize()) {
            return false;
        }
        if (!this.getLookup().equals(that.getLookup())) {
            return false;
        }
        return this.getReplaceMissingValueWith() != null ? this.getReplaceMissingValueWith().equals(that.getReplaceMissingValueWith()) : that.getReplaceMissingValueWith() == null;
    }

    public int hashCode() {
        int result = this.getLookup().hashCode();
        result = 31 * result + (this.isRetainMissingValue() ? 1 : 0);
        result = 31 * result + (this.getReplaceMissingValueWith() != null ? this.getReplaceMissingValueWith().hashCode() : 0);
        result = 31 * result + (this.isInjective() ? 1 : 0);
        result = 31 * result + (this.isOptimize() ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RegisteredLookupExtractionFn{delegate=" + this.delegate + ", lookup='" + this.lookup + '\'' + ", retainMissingValue=" + this.retainMissingValue + ", replaceMissingValueWith='" + this.replaceMissingValueWith + '\'' + ", injective=" + this.injective + ", optimize=" + this.optimize + '}';
    }
}

