/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Longs;
import io.druid.data.input.Row;
import java.util.regex.Pattern;

class HavingSpecMetricComparator {
    static final Pattern LONG_PAT = Pattern.compile("[-|+]?\\d+");

    HavingSpecMetricComparator() {
    }

    static int compare(Row row, String aggregationName, Number value) {
        Object metricValueObj = row.getRaw(aggregationName);
        if (metricValueObj != null) {
            String metricValueStr;
            if (metricValueObj instanceof Long) {
                long l = (Long)metricValueObj;
                return Longs.compare((long)l, (long)value.longValue());
            }
            if (metricValueObj instanceof String && LONG_PAT.matcher(metricValueStr = (String)metricValueObj).matches()) {
                long l = row.getLongMetric(aggregationName);
                return Longs.compare((long)l, (long)value.longValue());
            }
        }
        float f = row.getFloatMetric(aggregationName);
        return Floats.compare((float)f, (float)value.floatValue());
    }
}

