/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.metamx.common.StringUtils;
import io.druid.data.input.Row;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.IdentityExtractionFn;
import io.druid.query.groupby.having.HavingSpec;
import java.nio.ByteBuffer;
import java.util.List;

public class DimensionSelectorHavingSpec
implements HavingSpec {
    private static final byte CACHE_KEY = 8;
    private static final byte STRING_SEPARATOR = -1;
    private final String dimension;
    private final String value;
    private final ExtractionFn extractionFn;

    @JsonCreator
    public DimensionSelectorHavingSpec(@JsonProperty(value="dimension") String dimName, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimName, (Object)"Must have attribute 'dimension'");
        this.value = value;
        this.extractionFn = extractionFn != null ? extractionFn : IdentityExtractionFn.getInstance();
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public boolean eval(Row row) {
        List dimRowValList = row.getDimension(this.dimension);
        if (dimRowValList == null || dimRowValList.isEmpty()) {
            return Strings.isNullOrEmpty((String)this.value);
        }
        for (String rowVal : dimRowValList) {
            String extracted = this.getExtractionFn().apply(rowVal);
            if (this.value != null && this.value.equals(extracted)) {
                return true;
            }
            if (extracted != null && !extracted.isEmpty()) continue;
            return Strings.isNullOrEmpty((String)this.value);
        }
        return false;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] valBytes = StringUtils.toUtf8((String)this.value);
        byte[] extractionFnBytes = this.getExtractionFn().getCacheKey();
        return ByteBuffer.allocate(3 + dimBytes.length + valBytes.length + extractionFnBytes.length).put((byte)8).put(dimBytes).put((byte)-1).put(valBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionSelectorHavingSpec that = (DimensionSelectorHavingSpec)o;
        boolean valEquals = false;
        boolean dimEquals = false;
        if (this.value != null && that.value != null) {
            valEquals = this.value.equals(that.value);
        } else if (this.value == null && that.value == null) {
            valEquals = true;
        }
        if (this.dimension != null && that.dimension != null) {
            dimEquals = this.dimension.equals(that.dimension);
        } else if (this.dimension == null && that.dimension == null) {
            dimEquals = true;
        }
        return valEquals && dimEquals && this.extractionFn.equals(that.extractionFn);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DimensionSelectorHavingSpec");
        sb.append("{dimension='").append(this.dimension).append('\'');
        sb.append(", value='").append(this.value);
        sb.append("', extractionFunction='").append(this.getExtractionFn());
        sb.append("'}");
        return sb.toString();
    }
}

