/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.metamx.common.StringUtils;
import io.druid.query.dimension.BaseFilteredDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.segment.DimensionSelector;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Set;

public class ListFilteredDimensionSpec
extends BaseFilteredDimensionSpec {
    private static final byte CACHE_TYPE_ID = 3;
    private final Set<String> values;
    private final boolean isWhitelist;

    public ListFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="values") Set<String> values, @JsonProperty(value="isWhitelist") Boolean isWhitelist) {
        super(delegate);
        Preconditions.checkArgument((values != null && values.size() > 0 ? 1 : 0) != 0, (Object)"values list must be non-empty");
        this.values = values;
        this.isWhitelist = isWhitelist == null ? true : isWhitelist;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="isWhitelist")
    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        if (selector == null) {
            return selector;
        }
        int selectorCardinality = selector.getValueCardinality();
        if (selectorCardinality < 0) {
            throw new UnsupportedOperationException("Cannot decorate a selector with no dictionary");
        }
        int cardinality = this.isWhitelist ? this.values.size() : selectorCardinality;
        int count = 0;
        HashMap<Integer, Integer> forwardMapping = new HashMap<Integer, Integer>(cardinality);
        int[] reverseMapping = new int[cardinality];
        if (this.isWhitelist) {
            for (String value : this.values) {
                int i = selector.lookupId(value);
                if (i < 0) continue;
                forwardMapping.put(i, count);
                reverseMapping[count++] = i;
            }
        } else {
            for (int i = 0; i < selectorCardinality; ++i) {
                if (this.values.contains(Strings.nullToEmpty((String)selector.lookupName(i)))) continue;
                forwardMapping.put(i, count);
                reverseMapping[count++] = i;
            }
        }
        return BaseFilteredDimensionSpec.decorate(selector, forwardMapping, reverseMapping);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] delegateCacheKey = this.delegate.getCacheKey();
        byte[][] valuesBytes = new byte[this.values.size()][];
        int valuesBytesSize = 0;
        int index = 0;
        for (String value : this.values) {
            valuesBytes[index] = StringUtils.toUtf8((String)value);
            valuesBytesSize += valuesBytes[index].length + 1;
            ++index;
        }
        ByteBuffer filterCacheKey = ByteBuffer.allocate(3 + delegateCacheKey.length + valuesBytesSize).put((byte)3).put(delegateCacheKey).put((byte)(this.isWhitelist ? 1 : 0)).put((byte)-1);
        for (byte[] bytes : valuesBytes) {
            filterCacheKey.put(bytes).put((byte)-1);
        }
        return filterCacheKey.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListFilteredDimensionSpec that = (ListFilteredDimensionSpec)o;
        if (this.isWhitelist != that.isWhitelist) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.values.hashCode();
        result = 31 * result + (this.isWhitelist ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ListFilteredDimensionSpec{values=" + this.values + ", isWhitelist=" + this.isWhitelist + '}';
    }
}

