/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.UnionDataSource;
import java.util.Map;

public class UnionQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public UnionQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof UnionDataSource) {
            return new MergeSequence(query.getResultOrdering(), Sequences.simple((Iterable)Lists.transform(((UnionDataSource)dataSource).getDataSources(), (Function)new Function<DataSource, Sequence<T>>(){

                public Sequence<T> apply(DataSource singleSource) {
                    return UnionQueryRunner.this.baseRunner.run(query.withDataSource(singleSource), responseContext);
                }
            })));
        }
        return this.baseRunner.run(query, responseContext);
    }
}

