/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.MapRSecurityUtil;

public class ClientXmlSslConfig
implements Closeable {
    private static final String SSL_CLIENT_XML = "ssl-client.xml";
    private final String clientTruststoreLocation;
    private final String clientKeystoreLocation;
    private final char[] clientKeystorePassword;
    private final char[] clientTruststorePassword;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientXmlSslConfig() {
        String maprConfDir = MapRSecurityUtil.findMapRHome() + "/conf/";
        File sslClientXml = new File(maprConfDir, SSL_CLIENT_XML);
        Closeable inStreamServer = null;
        FileInputStream inStreamClient = null;
        try {
            Configuration conf2332 = new Configuration(true);
            inStreamClient = new FileInputStream(sslClientXml);
            conf2332.addResource((InputStream)inStreamClient, false);
            this.clientTruststoreLocation = conf2332.get("ssl.client.truststore.location");
            this.clientKeystoreLocation = conf2332.get("ssl.client.keystore.location");
            this.clientKeystorePassword = conf2332.getPassword("ssl.client.keystore.password");
            this.clientTruststorePassword = conf2332.getPassword("ssl.client.truststore.password");
        }
        catch (IOException e) {
            try {
                throw new SecurityException("Unable to read SSL configuration from XML files", e);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(inStreamClient, true);
                    Closeables.close(inStreamServer, true);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Closeables.close(inStreamClient, true);
            Closeables.close(inStreamServer, true);
            return;
        }
        catch (IOException conf2332) {
            return;
        }
    }

    public String getClientTruststoreLocation() throws SecurityException {
        return this.clientTruststoreLocation;
    }

    public char[] getClientTruststorePassword() throws SecurityException {
        return this.clientTruststorePassword == null ? null : Arrays.copyOf(this.clientTruststorePassword, this.clientTruststorePassword.length);
    }

    public String getClientKeystoreLocation() throws SecurityException {
        return this.clientKeystoreLocation;
    }

    public char[] getClientKeystorePassword() throws SecurityException {
        return this.clientKeystorePassword == null ? null : Arrays.copyOf(this.clientKeystorePassword, this.clientKeystorePassword.length);
    }

    @Override
    public void close() {
        char[][] passwords;
        for (char[] password : passwords = new char[][]{this.clientKeystorePassword, this.clientTruststorePassword}) {
            if (password == null) continue;
            Arrays.fill(password, '\u0000');
        }
    }
}

